/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.interop.texture;

import io.homo.superresolution.core.impl.texture.TextureFormat;
import io.homo.superresolution.core.interop.memory.SharedMemory;
import io.homo.superresolution.core.vulkan.Utils;
import io.homo.superresolution.core.vulkan.VkDeviceManager;
import io.homo.superresolution.core.vulkan.texture.VkAllocatedImage;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.opengl.EXTMemoryObject;
import org.lwjgl.opengl.GL46;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.vulkan.VK11;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkExtent3D;
import org.lwjgl.vulkan.VkExternalMemoryImageCreateInfo;
import org.lwjgl.vulkan.VkImageCreateInfo;
import org.lwjgl.vulkan.VkImageViewCreateInfo;
import org.lwjgl.vulkan.VkImportMemoryFdInfoKHR;
import org.lwjgl.vulkan.VkMemoryAllocateInfo;
import org.lwjgl.vulkan.VkMemoryRequirements;

public class GlToVkTexture {
    private final VkDeviceManager deviceManager;
    public VkAllocatedImage vkImage = new VkAllocatedImage();
    public int glMemoryObject;
    public int glTextureId;
    public int width;
    public int height;
    public SharedMemory memory = new SharedMemory();
    protected TextureFormat format;

    public GlToVkTexture(int width, int height, VkDeviceManager deviceManager) {
        this.deviceManager = deviceManager;
        this.width = width;
        this.height = height;
    }

    public GlToVkTexture setFormat(TextureFormat format) {
        this.format = format;
        return this;
    }

    private void createGLResources() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pMemObj = stack.callocInt(1);
            EXTMemoryObject.glCreateMemoryObjectsEXT((IntBuffer)pMemObj);
            this.glMemoryObject = pMemObj.get(0);
            EXTMemoryObject.glNamedBufferStorageMemEXT((int)this.glMemoryObject, (long)((long)this.width * (long)this.height * 4L), (int)0, (long)38278L);
            IntBuffer pFd = stack.callocInt(1);
            this.memory.fd = pFd.get(0);
            IntBuffer pTexture = stack.callocInt(1);
            GL46.glGenTextures((IntBuffer)pTexture);
            this.glTextureId = pTexture.get(0);
            GL46.glBindTexture((int)3553, (int)this.glTextureId);
            EXTMemoryObject.glTexStorageMem2DEXT((int)3553, (int)1, (int)this.format.gl(), (int)this.width, (int)this.height, (int)this.glMemoryObject, (long)0L);
            GL46.glBindTexture((int)3553, (int)0);
        }
    }

    private void createVulkanResources() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkExternalMemoryImageCreateInfo extMemInfo = VkExternalMemoryImageCreateInfo.calloc((MemoryStack)stack).sType(1000072001).handleTypes(1);
            VkImageCreateInfo imageInfo = VkImageCreateInfo.calloc((MemoryStack)stack).sType(14).pNext(extMemInfo).imageType(1).format(this.format.vk()).extent(VkExtent3D.calloc((MemoryStack)stack).set(this.width, this.height, 1)).mipLevels(1).arrayLayers(1).samples(1).tiling(0).usage(4).sharingMode(0).initialLayout(0);
            LongBuffer pImage = stack.callocLong(1);
            Utils.VK_CHECK(VK11.vkCreateImage((VkDevice)this.deviceManager.device, (VkImageCreateInfo)imageInfo, null, (LongBuffer)pImage), "\u521b\u5efaVulkan\u56fe\u50cf\u5931\u8d25");
            this.vkImage.image = pImage.get(0);
            VkMemoryRequirements memReqs = VkMemoryRequirements.calloc((MemoryStack)stack);
            VK11.vkGetImageMemoryRequirements((VkDevice)this.deviceManager.device, (long)this.vkImage.image, (VkMemoryRequirements)memReqs);
            VkImportMemoryFdInfoKHR importInfo = VkImportMemoryFdInfoKHR.calloc((MemoryStack)stack).sType(1000074000).handleType(1).fd(this.memory.fd);
            VkMemoryAllocateInfo allocInfo = VkMemoryAllocateInfo.calloc((MemoryStack)stack).sType(5).pNext(importInfo).allocationSize(memReqs.size());
            LongBuffer pMemory = stack.callocLong(1);
            Utils.VK_CHECK(VK11.vkAllocateMemory((VkDevice)this.deviceManager.device, (VkMemoryAllocateInfo)allocInfo, null, (LongBuffer)pMemory), "\u5bfc\u5165\u5185\u5b58\u5931\u8d25");
            this.vkImage.memory = pMemory.get(0);
            VK11.vkBindImageMemory((VkDevice)this.deviceManager.device, (long)this.vkImage.image, (long)this.vkImage.memory, (long)0L);
        }
    }

    public void create() {
        this.createGLResources();
        this.createVulkanResources();
    }

    public void cleanup() {
        if (this.glTextureId != 0) {
            GL46.glDeleteTextures((int)this.glTextureId);
            this.glTextureId = 0;
        }
        if (this.glMemoryObject != 0) {
            EXTMemoryObject.glDeleteMemoryObjectsEXT((int)this.glMemoryObject);
            this.glMemoryObject = 0;
        }
        if (this.vkImage.image != 0L) {
            VK11.vkDestroyImage((VkDevice)this.deviceManager.device, (long)this.vkImage.image, null);
            this.vkImage.image = 0L;
        }
        if (this.vkImage.memory != 0L) {
            VK11.vkFreeMemory((VkDevice)this.deviceManager.device, (long)this.vkImage.memory, null);
            this.vkImage.memory = 0L;
        }
    }

    public long createImageView() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkImageViewCreateInfo viewInfo = VkImageViewCreateInfo.calloc((MemoryStack)stack).sType(15).image(this.vkImage.image).viewType(1).format(this.format.vk()).subresourceRange(it -> it.aspectMask(1).baseMipLevel(0).levelCount(1).baseArrayLayer(0).layerCount(1));
            LongBuffer pView = stack.callocLong(1);
            Utils.VK_CHECK(VK11.vkCreateImageView((VkDevice)this.deviceManager.device, (VkImageViewCreateInfo)viewInfo, null, (LongBuffer)pView), "\u521b\u5efa\u56fe\u50cf\u89c6\u56fe\u5931\u8d25");
            long l = pView.get(0);
            return l;
        }
    }
}

