/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.renderdoc;

import com.sun.jna.Native;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import io.homo.superresolution.common.platform.OSType;
import io.homo.superresolution.common.platform.Platform;
import io.homo.superresolution.core.renderdoc.RenderdocLibrary;
import java.nio.file.Path;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderDoc {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"SuperResolution-RenderDoc");
    public static RenderdocLibrary.RenderdocApi renderdoc;

    private RenderDoc() {
    }

    public static void init() {
        PointerByReference apiPointer = new PointerByReference();
        RenderdocLibrary.RenderdocApi apiInstance = null;
        if (OSType.isCurrentOS(OSType.WINDOWS)) {
            try {
                String projectDir = Platform.currentPlatform.getGameFolder().getParent().toAbsolutePath().toString();
                String libPath = Path.of(projectDir, "renderdoc", "renderdoc.dll").toAbsolutePath().toString();
                LOGGER.info("RenderDoc\u5e93\u8def\u5f84 {}", (Object)libPath);
                System.load(libPath);
                RenderdocLibrary renderdocLibrary = (RenderdocLibrary)Native.load((String)"renderdoc", RenderdocLibrary.class);
                int initResult = renderdocLibrary.RENDERDOC_GetAPI(10500, apiPointer);
                if (initResult != 1) {
                    LOGGER.error("\u65e0\u6cd5\u521d\u59cb\u5316RenderDoc");
                } else {
                    apiInstance = new RenderdocLibrary.RenderdocApi(apiPointer.getValue());
                    IntByReference major = new IntByReference();
                    IntByReference minor = new IntByReference();
                    IntByReference patch = new IntByReference();
                    apiInstance.GetAPIVersion.call(major, minor, patch);
                    LOGGER.info("RenderDoc\u7248\u672c {}.{}.{}", new Object[]{major.getValue(), minor.getValue(), patch.getValue()});
                }
            }
            catch (UnsatisfiedLinkError ignored) {
                LOGGER.error("\u65e0\u6cd5\u52a0\u8f7dRenderDoc\u5e93");
            }
        }
        renderdoc = apiInstance;
    }

    public static Capture getCapture(int index) {
        if (renderdoc == null) {
            return null;
        }
        IntByReference length = new IntByReference();
        if (RenderDoc.renderdoc.GetCapture.call(index, null, length, null).intValue() != 1) {
            return null;
        }
        byte[] filename = new byte[length.getValue()];
        LongByReference timestamp = new LongByReference();
        RenderDoc.renderdoc.GetCapture.call(index, filename, length, timestamp);
        return new Capture(new String(filename, 0, filename.length - 1), Instant.ofEpochSecond(timestamp.getValue()));
    }

    public static int getNumCaptures() {
        if (renderdoc == null) {
            return -1;
        }
        return RenderDoc.renderdoc.GetNumCaptures.call().intValue();
    }

    public record Capture(String path, Instant timestamp) {
    }
}

