/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.vulkan;

import io.homo.superresolution.core.vulkan.VkException;
import java.nio.LongBuffer;
import java.util.Collection;
import java.util.List;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.Pointer;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkImageMemoryBarrier;

public class Utils {
    public static PointerBuffer asPointerBuffer(MemoryStack stack, Collection<String> collection) {
        PointerBuffer buffer = stack.mallocPointer(collection.size());
        collection.stream().map(arg_0 -> ((MemoryStack)stack).UTF8(arg_0)).forEach(arg_0 -> ((PointerBuffer)buffer).put(arg_0));
        return (PointerBuffer)buffer.rewind();
    }

    public static PointerBuffer asPointerBuffer(MemoryStack stack, List<? extends Pointer> list) {
        PointerBuffer buffer = stack.mallocPointer(list.size());
        list.forEach(arg_0 -> ((PointerBuffer)buffer).put(arg_0));
        return (PointerBuffer)buffer.rewind();
    }

    public static LongBuffer createLongBuffer() {
        return MemoryStack.stackCallocLong((int)1);
    }

    public static void VK_CHECK(int code) {
        if (code != 0) {
            throw new VkException();
        }
    }

    public static void VK_CHECK(int code, String msg) {
        if (code != 0) {
            throw new VkException(msg);
        }
    }

    public static void transitionImageLayout(VkCommandBuffer commandBuffer, long image, int format, int oldLayout, int newLayout, boolean isCubeMap) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            int destinationStage;
            int sourceStage;
            VkImageMemoryBarrier.Buffer barrier = VkImageMemoryBarrier.calloc((int)1, (MemoryStack)stack).sType(45).oldLayout(oldLayout).newLayout(newLayout).srcQueueFamilyIndex(-1).dstQueueFamilyIndex(-1).image(image);
            if (newLayout == 3) {
                barrier.subresourceRange().aspectMask(2);
                if (Utils.hasStencilComponent(format)) {
                    barrier.subresourceRange().aspectMask(barrier.subresourceRange().aspectMask() | 4);
                }
            } else if (newLayout == 1) {
                barrier.subresourceRange().aspectMask(1);
            } else {
                barrier.subresourceRange().aspectMask(1);
            }
            barrier.subresourceRange().baseMipLevel(0).levelCount(1).baseArrayLayer(0).layerCount(isCubeMap ? 6 : 1);
            if (oldLayout == 0 && newLayout == 7) {
                barrier.srcAccessMask(0);
                barrier.dstAccessMask(4096);
                sourceStage = 1;
                destinationStage = 4096;
            } else if (oldLayout == 7 && newLayout == 5) {
                barrier.srcAccessMask(4096);
                barrier.dstAccessMask(32);
                sourceStage = 4096;
                destinationStage = 128;
            } else if (oldLayout == 0 && newLayout == 3) {
                barrier.srcAccessMask(0);
                barrier.dstAccessMask(1536);
                sourceStage = 1;
                destinationStage = 256;
            } else if (newLayout == 1) {
                barrier.srcAccessMask(98304);
                barrier.dstAccessMask(98304);
                sourceStage = 65536;
                destinationStage = 65536;
            } else {
                throw new IllegalArgumentException("unsupported layout transition!");
            }
            VK10.vkCmdPipelineBarrier((VkCommandBuffer)commandBuffer, (int)sourceStage, (int)destinationStage, (int)0, null, null, (VkImageMemoryBarrier.Buffer)barrier);
        }
    }

    private static boolean hasStencilComponent(int format) {
        return format == 130 || format == 129;
    }
}

