/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.vulkan;

import io.homo.superresolution.common.platform.Platform;
import io.homo.superresolution.core.impl.Destroyable;
import io.homo.superresolution.core.impl.Resizable;
import io.homo.superresolution.core.vulkan.VkDeviceManager;
import io.homo.superresolution.core.vulkan.VkException;
import io.homo.superresolution.core.vulkan.VkValidationLayers;
import java.nio.LongBuffer;
import java.util.ArrayList;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VK12;
import org.lwjgl.vulkan.VkApplicationInfo;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkCommandBufferAllocateInfo;
import org.lwjgl.vulkan.VkCommandBufferBeginInfo;
import org.lwjgl.vulkan.VkCommandPoolCreateInfo;
import org.lwjgl.vulkan.VkDebugUtilsMessengerCreateInfoEXT;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkExtensionProperties;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkInstanceCreateInfo;
import org.lwjgl.vulkan.VkQueue;
import org.lwjgl.vulkan.VkSubmitInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VkApplication
implements Destroyable,
Resizable {
    public static final boolean ENABLE_VALIDATION = Platform.currentPlatform.isDevelopmentEnvironment();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"SuperResolution-Vulkan");
    private static final int DEFAULT_API_VERSION = VK12.VK_API_VERSION_1_2;
    public final VkValidationLayers validationLayers;
    public final VkDeviceManager deviceManager;
    protected final ArrayList<String> instanceRequiredExtensions = new ArrayList();
    protected final ArrayList<String> deviceRequiredExtensions = new ArrayList();
    public VkInstance instance;
    public long commandPool;
    public VkCommandBuffer commandBuffer;
    protected int width;
    protected int height;
    private boolean needResize;

    protected VkApplication() {
        this.validationLayers = new VkValidationLayers(this);
        this.deviceManager = new VkDeviceManager(this);
        this.instanceRequiredExtensions.add("VK_EXT_debug_utils");
    }

    public static VkApplication create() {
        VkApplication app = new VkApplication();
        if (!VkValidationLayers.checkValidationLayerSupport() && ENABLE_VALIDATION) {
            throw new VkException("Validation is necessary but not supported");
        }
        return app;
    }

    public static void main(String[] args) {
        ArrayList<String> supportedExtensions = new ArrayList<String>();
        try (MemoryStack stack = MemoryStack.stackPush();){
            int[] extensionCount = new int[1];
            VK10.vkEnumerateInstanceExtensionProperties((CharSequence)null, (int[])extensionCount, null);
            VkExtensionProperties.Buffer extensions = VkExtensionProperties.calloc((int)extensionCount[0], (MemoryStack)stack);
            VK10.vkEnumerateInstanceExtensionProperties((CharSequence)null, (int[])extensionCount, (VkExtensionProperties.Buffer)extensions);
            for (int i = 0; i < extensions.capacity(); ++i) {
                supportedExtensions.add(((VkExtensionProperties)extensions.get(i)).extensionNameString());
            }
        }
        for (String extension : supportedExtensions) {
            System.out.println(extension);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private void createInstance() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer instancePtr;
            VkApplicationInfo appInfo = VkApplicationInfo.calloc((MemoryStack)stack).sType(0).apiVersion(DEFAULT_API_VERSION).pEngineName(MemoryUtil.memUTF8((CharSequence)"Engine")).engineVersion(VK10.VK_MAKE_VERSION((int)0, (int)1, (int)3)).pApplicationName(MemoryUtil.memUTF8((CharSequence)"App")).applicationVersion(VK10.VK_MAKE_VERSION((int)1, (int)0, (int)0));
            VkInstanceCreateInfo createInfo = VkInstanceCreateInfo.calloc((MemoryStack)stack).sType(1).pApplicationInfo(appInfo).ppEnabledExtensionNames(this.getInstanceRequiredExtensions(stack));
            if (ENABLE_VALIDATION) {
                createInfo.ppEnabledLayerNames(this.validationLayers.validationLayersAsPointerBuffer(stack));
                VkDebugUtilsMessengerCreateInfoEXT debugCreateInfo = VkDebugUtilsMessengerCreateInfoEXT.calloc((MemoryStack)stack);
                this.validationLayers.populateDebugMessengerCreateInfo(debugCreateInfo);
                createInfo.pNext(debugCreateInfo.address());
            }
            if (VK10.vkCreateInstance((VkInstanceCreateInfo)createInfo, null, (PointerBuffer)(instancePtr = stack.mallocPointer(1))) != 0) {
                throw new VkException("Failed to create instance");
            }
            this.instance = new VkInstance(instancePtr.get(0), createInfo);
        }
    }

    private void initVulkan() {
        this.createInstance();
        if (ENABLE_VALIDATION) {
            this.validationLayers.setupDebugMessenger();
        }
        this.deviceManager.init();
        this.createCommand();
    }

    private PointerBuffer getInstanceRequiredExtensions(MemoryStack stack) {
        PointerBuffer extensions = stack.mallocPointer(this.instanceRequiredExtensions.size());
        for (String name : this.instanceRequiredExtensions) {
            extensions.put(stack.UTF8((CharSequence)name));
        }
        return (PointerBuffer)extensions.rewind();
    }

    public VkApplication addInstanceRequiredExtensions(String name) {
        if (this.instance != null) {
            return this;
        }
        this.instanceRequiredExtensions.add(name);
        return this;
    }

    private PointerBuffer getDeviceRequiredExtensions(MemoryStack stack) {
        PointerBuffer extensions = stack.mallocPointer(this.deviceRequiredExtensions.size());
        for (String name : this.deviceRequiredExtensions) {
            extensions.put(stack.UTF8((CharSequence)name));
        }
        return (PointerBuffer)extensions.rewind();
    }

    public VkApplication addDeviceRequiredExtensions(String name) {
        if (this.instance != null) {
            return this;
        }
        this.deviceRequiredExtensions.add(name);
        return this;
    }

    public VkApplication init() {
        this.initVulkan();
        LOGGER.info("Vulkan\u521d\u59cb\u5316\u5b8c\u6210");
        return this;
    }

    @Override
    public void destroy() {
        VkDevice device = this.deviceManager.device;
        this.deviceManager.destroy();
        this.validationLayers.destroy();
        VK10.vkDestroyInstance((VkInstance)this.instance, null);
    }

    private void onResize(long window, int width, int height) {
        this.resize(width, height);
    }

    @Override
    public void resize(int width, int height) {
        this.width = width;
        this.height = height;
        this.needResize = true;
    }

    public void onResize() {
        VkDevice device = this.deviceManager.device;
        VK10.vkDeviceWaitIdle((VkDevice)device);
    }

    public void createCommand() {
        VkCommandPoolCreateInfo info = VkCommandPoolCreateInfo.calloc();
        info.sType(39);
        info.queueFamilyIndex(this.deviceManager.queueFamilyIndices.graphicsFamily.intValue());
        LongBuffer ptr = MemoryStack.stackCallocLong((int)1);
        VK10.vkCreateCommandPool((VkDevice)this.deviceManager.device, (VkCommandPoolCreateInfo)info, null, (LongBuffer)ptr);
        this.commandPool = ptr.get(0);
        info = VkCommandBufferAllocateInfo.calloc();
        info.sType(40);
        info.commandPool(this.commandPool);
        info.level(0);
        info.commandBufferCount(1);
        ptr = MemoryStack.stackCallocPointer((int)1);
        VK10.vkAllocateCommandBuffers((VkDevice)this.deviceManager.device, (VkCommandBufferAllocateInfo)info, (PointerBuffer)ptr);
        this.commandBuffer = new VkCommandBuffer(ptr.get(0), this.deviceManager.device);
    }

    public VkCommandBuffer beginOneTimeSubmitCmd() {
        VK10.vkResetCommandPool((VkDevice)this.deviceManager.device, (long)this.commandPool, (int)0);
        VkCommandBufferBeginInfo info = VkCommandBufferBeginInfo.calloc();
        info.sType(42);
        info.flags(1);
        VK10.vkBeginCommandBuffer((VkCommandBuffer)this.commandBuffer, (VkCommandBufferBeginInfo)info);
        return this.commandBuffer;
    }

    public void endOneTimeSubmitCmd() {
        VkSubmitInfo info = VkSubmitInfo.calloc();
        info.sType(4);
        PointerBuffer ptr = MemoryStack.stackCallocPointer((int)1);
        ptr.put(this.commandBuffer.address());
        info.pCommandBuffers(ptr);
        VK10.vkEndCommandBuffer((VkCommandBuffer)this.commandBuffer);
        VK10.vkQueueSubmit((VkQueue)this.deviceManager.graphicsQueue, (VkSubmitInfo)info, (long)0L);
        VK10.vkDeviceWaitIdle((VkDevice)this.deviceManager.device);
    }

    public void loop() {
        while (true) {
            if (this.needResize) {
                this.onResize();
                this.needResize = false;
            }
            VK10.vkDeviceWaitIdle((VkDevice)this.deviceManager.device);
        }
    }
}

