/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.vulkan.shader;

import io.homo.superresolution.core.vulkan.VkDeviceManager;
import io.homo.superresolution.core.vulkan.shader.VkShaderUniformType;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VkDescriptorBufferInfo;
import org.lwjgl.vulkan.VkDescriptorSetLayoutBinding;
import org.lwjgl.vulkan.VkDevice;

public class VkShaderUniform {
    public VkShaderUniformType type;
    public int binding;
    public int stageFlags = 32;
    public long sampler = -1L;
    public int size;
    public String name;
    public long bufferDeviceMemory = -1L;
    public long bufferMemory = -1L;
    public long bufferData = -1L;
    public long bufferSize = 0L;
    public PointerBuffer bufferDataPointer;

    public String getName() {
        return this.name;
    }

    public VkShaderUniform name(String name) {
        this.name = name;
        return this;
    }

    protected VkDescriptorSetLayoutBinding build() {
        VkDescriptorSetLayoutBinding bindingLayout = VkDescriptorSetLayoutBinding.calloc();
        bindingLayout.binding(this.binding);
        bindingLayout.descriptorType(this.type.getValue());
        bindingLayout.descriptorCount(1);
        bindingLayout.stageFlags(this.stageFlags);
        if (this.sampler != -1L) {
            LongBuffer buf = MemoryStack.stackLongs((long)this.sampler);
            bindingLayout.pImmutableSamplers(buf);
        }
        return bindingLayout;
    }

    public VkShaderUniform type(VkShaderUniformType type) {
        this.type = type;
        return this;
    }

    public VkShaderUniform binding(int binding) {
        this.binding = binding;
        return this;
    }

    public VkShaderUniform stageFlags(int stageFlags) {
        this.stageFlags = stageFlags;
        return this;
    }

    public VkShaderUniform sampler(long sampler) {
        this.sampler = sampler;
        return this;
    }

    public VkShaderUniform size(int size) {
        this.size = size;
        return this;
    }

    protected VkDescriptorBufferInfo createBufferInfo(VkDeviceManager deviceManager) {
        LongBuffer buffer = MemoryStack.stackCallocLong((int)1);
        LongBuffer deviceBuffer = MemoryStack.stackCallocLong((int)1);
        this.bufferDataPointer = MemoryStack.stackCallocPointer((int)1);
        long align = deviceManager.physicalDeviceProperties.limits().minUniformBufferOffsetAlignment();
        this.bufferSize = ((long)this.size + align - 1L) / align * align;
        deviceManager.createBuffer(this.bufferSize, 16, 6, buffer, deviceBuffer);
        this.bufferMemory = buffer.get(0);
        this.bufferDeviceMemory = deviceBuffer.get(0);
        VK10.vkMapMemory((VkDevice)deviceManager.device, (long)this.bufferDeviceMemory, (long)0L, (long)this.bufferSize, (int)0, (PointerBuffer)this.bufferDataPointer);
        this.bufferData = this.bufferDataPointer.get(0);
        VkDescriptorBufferInfo info = VkDescriptorBufferInfo.calloc();
        info.buffer(this.bufferMemory);
        info.offset(0L);
        info.range((long)this.size);
        return info;
    }

    public ByteBuffer getBuffer() {
        return this.bufferDataPointer.getByteBuffer(0, this.size);
    }
}

