/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.fsr2;

import io.homo.superresolution.core.gl.buffer.GlUniformBuffer;
import io.homo.superresolution.fsr2.Fsr2ContextConfig;
import io.homo.superresolution.fsr2.Fsr2Dimensions;
import io.homo.superresolution.fsr2.Fsr2DispatchDescription;
import io.homo.superresolution.fsr2.Fsr2PipelineDispatchResource;
import io.homo.superresolution.fsr2.Fsr2PipelineResourceType;
import io.homo.superresolution.fsr2.Fsr2PipelineResources;
import io.homo.superresolution.fsr2.pipelines.Fsr2AccumulatePipeline;
import io.homo.superresolution.fsr2.pipelines.Fsr2AccumulateSharpenPipeline;
import io.homo.superresolution.fsr2.pipelines.Fsr2ComputeLuminancePyramidPipeline;
import io.homo.superresolution.fsr2.pipelines.Fsr2DepthClipPipeline;
import io.homo.superresolution.fsr2.pipelines.Fsr2GenerateReactivePipeline;
import io.homo.superresolution.fsr2.pipelines.Fsr2LockPipeline;
import io.homo.superresolution.fsr2.pipelines.Fsr2RCASPipeline;
import io.homo.superresolution.fsr2.pipelines.Fsr2ReconstructPreviousDepthPipeline;
import io.homo.superresolution.fsr2.pipelines.Fsr2TcrAutogeneratePipeline;
import io.homo.superresolution.fsr2.struct.Fsr2CBFSR2;
import io.homo.superresolution.fsr2.struct.Fsr2CBRcas;
import io.homo.superresolution.fsr2.struct.Fsr2CBSpd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fsr2Context {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"SuperResolution-FSR2");
    public Fsr2AccumulatePipeline accumulatePipeline;
    public Fsr2RCASPipeline rcasPipeline;
    public Fsr2AccumulateSharpenPipeline accumulateSharpenPipeline;
    public Fsr2ComputeLuminancePyramidPipeline computeLuminancePyramidPipeline;
    public Fsr2DepthClipPipeline depthClipPipeline;
    public Fsr2GenerateReactivePipeline generateReactivePipeline;
    public Fsr2LockPipeline lockPipeline;
    public Fsr2ReconstructPreviousDepthPipeline reconstructPreviousDepthPipeline;
    public Fsr2TcrAutogeneratePipeline tcrAutogeneratePipeline;
    public Fsr2PipelineResources resources = new Fsr2PipelineResources();
    public Fsr2ContextConfig config;
    public Fsr2Dimensions dimensions;
    public Fsr2CBFSR2 fsr2Constants = new Fsr2CBFSR2();
    public GlUniformBuffer<Fsr2CBFSR2> fsr2ConstantsUBO = new GlUniformBuffer<Fsr2CBFSR2>(this.fsr2Constants);
    public Fsr2CBSpd fsr2SpdConstants = new Fsr2CBSpd();
    public GlUniformBuffer<Fsr2CBSpd> fsr2SpdConstantsUBO = new GlUniformBuffer<Fsr2CBSpd>(this.fsr2SpdConstants);
    public Fsr2CBRcas fsr2RcasConstants = new Fsr2CBRcas();
    public GlUniformBuffer<Fsr2CBRcas> fsr2RcasConstantsUBO = new GlUniformBuffer<Fsr2CBRcas>(this.fsr2RcasConstants);
    private int frameIndex = 0;

    public Fsr2Context(Fsr2ContextConfig config, Fsr2Dimensions dimensions) {
        this.config = config;
        this.dimensions = dimensions;
    }

    public void resize(Fsr2Dimensions dimensions) {
        this.dimensions = dimensions;
        this.resources.destroy();
        this.resources = null;
        this.resources = new Fsr2PipelineResources();
        this.resources.init(dimensions.renderWidth(), dimensions.renderHeight(), dimensions.screenWidth(), dimensions.screenHeight());
        this.accumulatePipeline = new Fsr2AccumulatePipeline(this);
        this.rcasPipeline = new Fsr2RCASPipeline(this);
        this.accumulateSharpenPipeline = new Fsr2AccumulateSharpenPipeline(this);
        this.computeLuminancePyramidPipeline = new Fsr2ComputeLuminancePyramidPipeline(this);
        this.depthClipPipeline = new Fsr2DepthClipPipeline(this);
        this.generateReactivePipeline = new Fsr2GenerateReactivePipeline(this);
        this.lockPipeline = new Fsr2LockPipeline(this);
        this.reconstructPreviousDepthPipeline = new Fsr2ReconstructPreviousDepthPipeline(this);
        this.tcrAutogeneratePipeline = new Fsr2TcrAutogeneratePipeline(this);
        this.accumulatePipeline.init();
        this.rcasPipeline.init();
        this.accumulateSharpenPipeline.init();
        this.computeLuminancePyramidPipeline.init();
        this.depthClipPipeline.init();
        this.generateReactivePipeline.init();
        this.lockPipeline.init();
        this.reconstructPreviousDepthPipeline.init();
        this.tcrAutogeneratePipeline.init();
        this.accumulatePipeline.resize(dimensions);
        this.rcasPipeline.resize(dimensions);
        this.accumulateSharpenPipeline.resize(dimensions);
        this.computeLuminancePyramidPipeline.resize(dimensions);
        this.depthClipPipeline.resize(dimensions);
        this.generateReactivePipeline.resize(dimensions);
        this.lockPipeline.resize(dimensions);
        this.reconstructPreviousDepthPipeline.resize(dimensions);
        this.tcrAutogeneratePipeline.resize(dimensions);
    }

    public void destroy() {
        this.resources.destroy();
        this.accumulatePipeline.destroy();
        this.rcasPipeline.destroy();
        this.accumulateSharpenPipeline.destroy();
        this.computeLuminancePyramidPipeline.destroy();
        this.depthClipPipeline.destroy();
        this.generateReactivePipeline.destroy();
        this.lockPipeline.destroy();
        this.reconstructPreviousDepthPipeline.destroy();
        this.tcrAutogeneratePipeline.destroy();
    }

    public void init() {
        this.resources = new Fsr2PipelineResources();
        this.resources.init(this.dimensions.renderWidth(), this.dimensions.renderHeight(), this.dimensions.screenWidth(), this.dimensions.screenHeight());
        this.resize(this.dimensions);
    }

    public void dispatch(Fsr2DispatchDescription dispatchDescription) {
        this.resources.resource(Fsr2PipelineResourceType.INPUT_COLOR).setResource(dispatchDescription.color);
        this.resources.resource(Fsr2PipelineResourceType.INPUT_MOTION_VECTORS).setResource(dispatchDescription.motionVectors);
        this.resources.resource(Fsr2PipelineResourceType.INPUT_DEPTH).setResource(dispatchDescription.depth);
        this.resources.resource(Fsr2PipelineResourceType.INPUT_EXPOSURE).setResource(dispatchDescription.exposure == null ? this.resources.resource(Fsr2PipelineResourceType.INTERNAL_DEFAULT_EXPOSURE).getResource() : dispatchDescription.exposure);
        this.resources.resource(Fsr2PipelineResourceType.INPUT_REACTIVE_MASK).setResource(dispatchDescription.reactive == null ? this.resources.resource(Fsr2PipelineResourceType.INTERNAL_DEFAULT_REACTIVITY).getResource() : dispatchDescription.reactive);
        this.resources.resource(Fsr2PipelineResourceType.INPUT_TRANSPARENCY_AND_COMPOSITION_MASK).setResource(dispatchDescription.transparencyAndComposition == null ? this.resources.resource(Fsr2PipelineResourceType.INTERNAL_DEFAULT_REACTIVITY).getResource() : dispatchDescription.transparencyAndComposition);
        this.resources.resource(Fsr2PipelineResourceType.UPSCALED_OUTPUT).setResource(dispatchDescription.output);
        this.fsr2Constants.update(this, dispatchDescription, this.dimensions);
        this.fsr2SpdConstants.update(this, dispatchDescription, this.dimensions);
        this.fsr2RcasConstants.update(this, dispatchDescription, this.dimensions);
        this.fsr2ConstantsUBO.update();
        this.fsr2SpdConstantsUBO.update();
        this.fsr2RcasConstantsUBO.update();
        Fsr2PipelineDispatchResource pipelineDispatchResource = new Fsr2PipelineDispatchResource(this.resources, this.config, this.dimensions, dispatchDescription);
        this.computeLuminancePyramidPipeline.execute(pipelineDispatchResource);
        this.reconstructPreviousDepthPipeline.execute(pipelineDispatchResource);
        this.depthClipPipeline.execute(pipelineDispatchResource);
        this.lockPipeline.execute(pipelineDispatchResource);
        if (dispatchDescription.enableSharpening()) {
            this.accumulateSharpenPipeline.execute(pipelineDispatchResource);
            this.rcasPipeline.execute(pipelineDispatchResource);
        } else {
            this.accumulatePipeline.execute(pipelineDispatchResource);
        }
        if (dispatchDescription.reset()) {
            this.frameIndex = 0;
        } else {
            ++this.frameIndex;
            this.frameIndex %= 16;
        }
    }

    public boolean isOddFrame() {
        return (this.frameIndex & 1) != 0;
    }
}

