/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.fsr2.struct;

import io.homo.superresolution.core.impl.IUniformStruct;
import io.homo.superresolution.core.impl.Vec2;
import io.homo.superresolution.fsr2.Fsr2Context;
import io.homo.superresolution.fsr2.Fsr2Dimensions;
import io.homo.superresolution.fsr2.Fsr2DispatchDescription;
import io.homo.superresolution.fsr2.Fsr2Utils;
import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryStack;

public class Fsr2CBFSR2
implements IUniformStruct {
    private final ByteBuffer container;
    private final int[] renderSize = new int[2];
    private final int[] maxRenderSize = new int[2];
    private final int[] displaySize = new int[2];
    private final int[] inputColorResourceDimensions = new int[2];
    private final int[] lumaMipDimensions = new int[2];
    private final float[] deviceToViewDepth = new float[4];
    private final float[] jitter = new float[2];
    private final float[] previousJitterOffset = new float[2];
    private final float[] motionVectorScale = new float[2];
    private final float[] downscaleFactor = new float[2];
    private final float[] motionVectorJitterCancellation = new float[2];
    private int lumaMipLevelToUse = 0;
    private int frameIndex = 0;
    private float preExposure = 1.0f;
    private float previousFramePreExposure = 1.0f;
    private float tanHalfFOV = 0.0f;
    private float jitterSequenceLength = 1.0f;
    private float deltaTime = 0.0f;
    private float dynamicResChangeFactor = 1.0f;
    private float viewSpaceToMetersFactor = 1.0f;

    public Fsr2CBFSR2() {
        this.container = MemoryStack.stackCalloc((int)this.sizeof());
    }

    public void fillBuffer() {
        this.container.putInt(0, this.renderSize[0]);
        this.container.putInt(4, this.renderSize[1]);
        this.container.putInt(8, this.maxRenderSize[0]);
        this.container.putInt(12, this.maxRenderSize[1]);
        this.container.putInt(16, this.displaySize[0]);
        this.container.putInt(20, this.displaySize[1]);
        this.container.putInt(24, this.inputColorResourceDimensions[0]);
        this.container.putInt(28, this.inputColorResourceDimensions[1]);
        this.container.putInt(32, this.lumaMipDimensions[0]);
        this.container.putInt(36, this.lumaMipDimensions[1]);
        this.container.putInt(40, this.lumaMipLevelToUse);
        this.container.putInt(44, this.frameIndex);
        this.container.putFloat(48, this.deviceToViewDepth[0]);
        this.container.putFloat(52, this.deviceToViewDepth[1]);
        this.container.putFloat(56, this.deviceToViewDepth[2]);
        this.container.putFloat(60, this.deviceToViewDepth[3]);
        this.container.putFloat(64, this.jitter[0]);
        this.container.putFloat(68, this.jitter[1]);
        this.container.putFloat(72, this.motionVectorScale[0]);
        this.container.putFloat(76, this.motionVectorScale[1]);
        this.container.putFloat(80, this.downscaleFactor[0]);
        this.container.putFloat(84, this.downscaleFactor[1]);
        this.container.putFloat(88, this.motionVectorJitterCancellation[0]);
        this.container.putFloat(92, this.motionVectorJitterCancellation[1]);
        this.container.putFloat(96, this.preExposure);
        this.container.putFloat(100, this.previousFramePreExposure);
        this.container.putFloat(104, this.tanHalfFOV);
        this.container.putFloat(108, this.jitterSequenceLength);
        this.container.putFloat(112, this.deltaTime);
        this.container.putFloat(116, this.dynamicResChangeFactor);
        this.container.putFloat(120, this.viewSpaceToMetersFactor);
        this.container.position(128);
        this.container.flip();
    }

    public void update(Fsr2Context context, Fsr2DispatchDescription desc, Fsr2Dimensions dims) {
        this.renderSize[0] = (int)desc.renderSize().x;
        this.renderSize[1] = (int)desc.renderSize().y;
        this.maxRenderSize[0] = (int)desc.renderSize().x;
        this.maxRenderSize[1] = (int)desc.renderSize().y;
        this.displaySize[0] = dims.screenWidth();
        this.displaySize[1] = dims.screenHeight();
        this.inputColorResourceDimensions[0] = (int)desc.renderSize().x;
        this.inputColorResourceDimensions[1] = (int)desc.renderSize().y;
        this.lumaMipLevelToUse = 4;
        int mipLevel = 4;
        int mipDiv = 1 << mipLevel;
        this.lumaMipDimensions[0] = (int)(desc.renderSize().x / (float)mipDiv);
        this.lumaMipDimensions[1] = (int)(desc.renderSize().y / (float)mipDiv);
        this.frameIndex = 0;
        this.computeDeviceToViewDepth(desc.cameraNear, desc.cameraFar, context.config.flags.isEnableDepthInverted(), context.config.flags.isEnableDepthInfinite(), (int)desc.renderSize().x, (int)desc.renderSize().y, desc.cameraFovAngleVertical);
        Vec2 jitterVec = desc.jitterOffset() != null ? desc.jitterOffset() : new Vec2(0.0f, 0.0f);
        this.jitter[0] = jitterVec.x;
        this.jitter[1] = jitterVec.y;
        Vec2 mvScale = desc.motionVectorScale() != null ? desc.motionVectorScale() : new Vec2(1.0f, 1.0f);
        this.motionVectorScale[0] = mvScale.x;
        this.motionVectorScale[1] = mvScale.y;
        this.downscaleFactor[0] = (float)dims.renderWidth() / (float)dims.screenWidth();
        this.downscaleFactor[1] = (float)dims.renderHeight() / (float)dims.screenHeight();
        if (context.config.flags.isEnableMotionVectorsJitterCancellation()) {
            int width = context.config.flags.isEnableDisplayResolutionMotionVectors() ? dims.screenWidth() : dims.renderWidth();
            int height = context.config.flags.isEnableDisplayResolutionMotionVectors() ? dims.screenHeight() : dims.renderHeight();
            this.motionVectorJitterCancellation[0] = (this.previousJitterOffset[0] - this.jitter[0]) / (float)width;
            this.motionVectorJitterCancellation[1] = (this.previousJitterOffset[1] - this.jitter[1]) / (float)height;
            this.previousJitterOffset[0] = this.jitter[0];
            this.previousJitterOffset[1] = this.jitter[1];
        }
        this.previousFramePreExposure = this.preExposure;
        this.preExposure = desc.preExposure();
        float aspect = (float)dims.renderWidth() / (float)Math.max(1, dims.renderHeight());
        float cameraFovAngleHorizontal = (float)(Math.atan(Math.tan(desc.cameraFovAngleVertical() / 2.0f) * (double)aspect) * 2.0);
        this.tanHalfFOV = (float)Math.tan((double)cameraFovAngleHorizontal * 0.5);
        int jitterPhaseCount = Fsr2Utils.ffxFsr2GetJitterPhaseCount(dims.renderWidth(), dims.screenWidth());
        if (desc.reset() || this.jitterSequenceLength == 0.0f) {
            this.jitterSequenceLength = jitterPhaseCount;
        } else {
            int jitterPhaseCountDelta = (int)((float)jitterPhaseCount - this.jitterSequenceLength);
            if (jitterPhaseCountDelta > 0) {
                this.jitterSequenceLength += 1.0f;
            } else if (jitterPhaseCountDelta < 0) {
                this.jitterSequenceLength -= 1.0f;
            }
        }
        this.deltaTime = desc.frameTimeDelta();
        this.dynamicResChangeFactor = 0.0f;
        this.viewSpaceToMetersFactor = desc.viewSpaceToMetersFactor() > 0.0f ? desc.viewSpaceToMetersFactor() : 1.0f;
        this.fillBuffer();
    }

    @Override
    public ByteBuffer container() {
        return this.container;
    }

    @Override
    public int sizeof() {
        return 128;
    }

    public void computeDeviceToViewDepth(float cameraNear, float cameraFar, boolean depthInverted, boolean depthInfinite, float renderWidth, float renderHeight, float cameraFovAngleVertical) {
        float fMin = Math.min(cameraNear, cameraFar);
        float fMax = Math.max(cameraNear, cameraFar);
        boolean bInverted = depthInverted;
        boolean bInfinite = depthInfinite;
        if (bInverted) {
            float tmp = fMin;
            fMin = fMax;
            fMax = tmp;
        }
        float fQ = fMax / (fMin - fMax);
        float d = -1.0f;
        float FLT_EPSILON = 1.0E-7f;
        float[][] matrix_elem_c = new float[][]{{fQ, -1.0000001f}, {fQ, 1.0E-7f}};
        float[][] matrix_elem_e = new float[][]{{fQ * fMin, -fMin - 1.0E-7f}, {fQ * fMin, fMax}};
        int iInverted = bInverted ? 1 : 0;
        int iInfinite = bInfinite ? 1 : 0;
        this.deviceToViewDepth[0] = d * matrix_elem_c[iInverted][iInfinite];
        this.deviceToViewDepth[1] = matrix_elem_e[iInverted][iInfinite];
        float aspect = renderWidth / Math.max(1.0f, renderHeight);
        float cotHalfFovY = (float)(Math.cos(0.5 * (double)cameraFovAngleVertical) / Math.sin(0.5 * (double)cameraFovAngleVertical));
        float a = cotHalfFovY / aspect;
        float b = cotHalfFovY;
        this.deviceToViewDepth[2] = 1.0f / a;
        this.deviceToViewDepth[3] = 1.0f / b;
    }
}

