/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.api.registry;

import io.homo.superresolution.api.AbstractAlgorithm;
import io.homo.superresolution.api.utils.Requirement;
import java.util.Objects;
import java.util.UUID;

public class AlgorithmDescription<T extends AbstractAlgorithm> {
    public final String briefName;
    public final String codeName;
    public final String displayName;
    public final Requirement requirement;
    protected final Class<T> clazz;
    private final String uuid = UUID.randomUUID().toString();

    public AlgorithmDescription(Class<T> clazz, String briefName, String codeName, String displayName, Requirement requirement) {
        this.clazz = clazz;
        this.briefName = briefName;
        this.codeName = codeName;
        this.displayName = displayName;
        this.requirement = requirement;
    }

    public Requirement getRequirement() {
        return this.requirement;
    }

    public String getBriefName() {
        return this.briefName;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public T createNewInstance() {
        try {
            AbstractAlgorithm instance = (AbstractAlgorithm)this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            instance.init();
            return (T)instance;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlgorithmDescription that = (AlgorithmDescription)o;
        return Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hashCode(this.uuid);
    }
}

