/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft;

import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import io.homo.superresolution.common.minecraft.GpuTextureAdapter;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.graphics.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.opengl.Gl;
import io.homo.superresolution.core.graphics.opengl.GlState;
import io.homo.superresolution.core.graphics.opengl.utils.GlBlitRenderer;
import net.minecraft.class_276;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameBufferRenderTargetAdapter
extends class_276 {
    private IFrameBuffer frameBuffer;

    FrameBufferRenderTargetAdapter(IFrameBuffer frameBuffer) {
        super(frameBuffer.handle() + "-IFrameBuffer-" + frameBuffer.getTextureId(FrameBufferAttachmentType.Color), frameBuffer.getDepthTextureFormat() != null);
        this.frameBuffer = frameBuffer;
        this.updateState();
    }

    protected static FrameBufferRenderTargetAdapter ofRenderTarget(IFrameBuffer frameBuffer) {
        return new FrameBufferRenderTargetAdapter(frameBuffer);
    }

    private void updateState() {
        this.field_1482 = this.frameBuffer.getWidth();
        this.field_1481 = this.frameBuffer.getHeight();
        this.field_1480 = this.frameBuffer.getWidth();
        this.field_1477 = this.frameBuffer.getHeight();
        this.field_1475 = GpuTextureAdapter.ofTexture(this.frameBuffer.getTexture(FrameBufferAttachmentType.Color));
        ((GpuTextureAdapter)this.field_1475).bindFramebuffer(this.frameBuffer);
        ITexture texture = this.frameBuffer.getTexture(FrameBufferAttachmentType.DepthStencil);
        if (texture != null) {
            this.field_56739 = GpuTextureAdapter.ofTexture(texture);
        } else {
            texture = this.frameBuffer.getTexture(FrameBufferAttachmentType.Depth);
            if (texture != null) {
                this.field_56739 = GpuTextureAdapter.ofTexture(texture);
            }
        }
        if (this.field_56739 != null) {
            ((GpuTextureAdapter)this.field_56739).bindFramebuffer(this.frameBuffer);
        }
    }

    public void method_1234(int i, int j) {
        this.updateState();
    }

    public void method_1238() {
        this.updateState();
    }

    public void method_29329(@NotNull class_276 renderTarget) {
        this.updateState();
        super.method_29329(renderTarget);
    }

    public void method_1231(int i, int j) {
        this.updateState();
    }

    public void method_58226(FilterMode filterMode) {
        this.updateState();
    }

    private void setFilterMode(FilterMode filterMode, boolean bl) {
        this.updateState();
    }

    public void method_1237() {
        this.updateState();
        Gl.DSA.blitFramebuffer((int)this.frameBuffer.handle(), new GlState((long)32L).wFbo, 0, 0, this.frameBuffer.getWidth(), this.frameBuffer.getHeight(), 0, 0, this.frameBuffer.getWidth(), this.frameBuffer.getHeight(), 16384, 9728);
    }

    public void method_68445(GpuTexture gpuTexture) {
        this.updateState();
        GlBlitRenderer.blitToScreen(this.frameBuffer.getTexture(FrameBufferAttachmentType.Color), this.field_1480, this.field_1477);
    }

    @Nullable
    public GpuTexture method_30277() {
        this.updateState();
        return this.field_1475;
    }

    @Nullable
    public GpuTexture method_30278() {
        this.updateState();
        return this.field_56739;
    }

    public FrameBufferRenderTargetAdapter bindFrameBuffer(IFrameBuffer frameBuffer) {
        this.frameBuffer = frameBuffer;
        return this;
    }
}

