/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft.handler;

import io.homo.superresolution.common.minecraft.CallType;
import io.homo.superresolution.common.minecraft.MinecraftRenderTargetType;
import io.homo.superresolution.common.minecraft.handler.IMinecraftRenderHandler;
import io.homo.superresolution.common.minecraft.handler.RenderHandlerManager;
import io.homo.superresolution.common.minecraft.handler.SRShaderCompatConfig;
import io.homo.superresolution.common.minecraft.handler.TextureInfo;
import io.homo.superresolution.core.graphics.impl.framebuffer.IBindableFrameBuffer;
import io.homo.superresolution.core.graphics.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_279;
import net.minecraft.class_310;

public class ShaderCompatHandler
implements IMinecraftRenderHandler {
    private final Map<MinecraftRenderTargetType, IBindableFrameBuffer> renderTargets = new HashMap<MinecraftRenderTargetType, IBindableFrameBuffer>();

    public static void irisApiReloadShader() {
        try {
            Class<?> irisApiClazz = Class.forName("net.irisshaders.iris.Iris");
            irisApiClazz.getMethod("reload", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean irisApiIsShaderPackInUse() {
        try {
            Class<?> irisApiClazz = Class.forName("net.irisshaders.iris.api.v0.IrisApi");
            Object irisApiInstance = irisApiClazz.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            return (Boolean)irisApiClazz.getMethod("isShaderPackInUse", new Class[0]).invoke(irisApiInstance, new Object[0]);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isShaderPackCompatSuperResolution() {
        try {
            Class<?> irisApiClazz = Class.forName("io.homo.superresolution.shadercompat.IrisShaderPipelineHandle");
            return (Boolean)irisApiClazz.getMethod("shouldApplySuperResolutionChanges", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static Optional<SRShaderCompatConfig> getShaderPackCompatConfig() {
        try {
            Class<?> irisApiClazz = Class.forName("io.homo.superresolution.shadercompat.IrisShaderPipelineHandle");
            return (Optional)irisApiClazz.getMethod("getCurrentShaderPackConfig", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            return Optional.empty();
        }
    }

    public static Optional<SRShaderCompatConfig.WorldConfig> getCurrentLevelCompatConfig() {
        try {
            Class<?> irisApiClazz = Class.forName("io.homo.superresolution.shadercompat.ShaderCompatUpscaleDispatcher");
            return Optional.ofNullable((SRShaderCompatConfig.WorldConfig)irisApiClazz.getMethod("getCurrentConfig", new Class[0]).invoke(null, new Object[0]));
        }
        catch (Throwable e) {
            return Optional.empty();
        }
    }

    public static boolean isShaderPackCompatSuperResolutionJitter() {
        try {
            Class<?> irisApiClazz = Class.forName("io.homo.superresolution.shadercompat.IrisShaderPipelineHandle");
            return (Boolean)irisApiClazz.getMethod("shouldApplySuperResolutionChangesJitter", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public void updateRenderTarget() {
        this.renderTargets.clear();
        for (MinecraftRenderTargetType minecraftRenderTargetType : MinecraftRenderTargetType.values()) {
            IBindableFrameBuffer renderTarget = minecraftRenderTargetType.get(class_310.method_1551().field_1769);
            if (renderTarget == null) continue;
            this.renderTargets.put(minecraftRenderTargetType, renderTarget);
        }
    }

    public void callOnRenderTargets(Consumer<IFrameBuffer> callback) {
        this.renderTargets.forEach((minecraftRenderTargetType, renderTarget) -> {
            if (renderTarget != null && minecraftRenderTargetType != MinecraftRenderTargetType.HAND) {
                callback.accept((IFrameBuffer)renderTarget);
            }
        });
    }

    public void updateRenderTargetSize() {
        int screenWidth = RenderHandlerManager.getScreenWidth();
        int screenHeight = RenderHandlerManager.getScreenHeight();
        this.callOnRenderTargets(renderTarget -> {
            if (renderTarget.getWidth() != screenWidth || renderTarget.getHeight() != screenHeight) {
                renderTarget.resizeFrameBuffer(screenWidth, screenHeight);
            }
        });
        IBindableFrameBuffer handRenderTarget = this.getRenderTarget(MinecraftRenderTargetType.HAND);
        if (handRenderTarget.getWidth() != screenWidth || handRenderTarget.getHeight() != screenHeight) {
            handRenderTarget.resizeFrameBuffer(screenWidth, screenHeight);
        }
    }

    public IBindableFrameBuffer getRenderTarget(MinecraftRenderTargetType type) {
        return this.renderTargets.get((Object)type);
    }

    @Override
    public void onRenderWorldBegin(CallType type) {
        this.updateRenderTarget();
        this.updateRenderTargetSize();
    }

    @Override
    public void onRenderWorldEnd(CallType type) {
        this.updateRenderTarget();
        this.updateRenderTargetSize();
    }

    @Override
    public void onRenderHandBegin() {
    }

    @Override
    public void onRenderHandEnd() {
    }

    @Override
    public void onProcessPostChain(class_279 postChain) {
    }

    @Override
    public IBindableFrameBuffer getFullSizeRenderTarget() {
        return RenderHandlerManager.getOriginRenderTarget();
    }

    @Override
    public IBindableFrameBuffer getScaledRenderTarget() {
        return RenderHandlerManager.getOriginRenderTarget();
    }

    @Override
    public void initialize() {
    }

    @Override
    public void resize() {
    }

    @Override
    public void destroy() {
    }

    private Class<?> getShaderCompatUpscaleDispatcher() throws ClassNotFoundException {
        return Class.forName("io.homo.superresolution.shadercompat.ShaderCompatUpscaleDispatcher");
    }

    @Override
    public ITexture getColorTexture() {
        try {
            Class<?> dispatcherClass = this.getShaderCompatUpscaleDispatcher();
            return ((TextureInfo)dispatcherClass.getField("colorTexture").get(null)).getInternalTexture();
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ITexture getDepthTexture() {
        try {
            Class<?> dispatcherClass = this.getShaderCompatUpscaleDispatcher();
            return ((TextureInfo)dispatcherClass.getField("depthTexture").get(null)).getInternalTexture();
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

