/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.opengl.shader;

import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.common.config.SuperResolutionConfig;
import io.homo.superresolution.core.graphics.glslang.GlslangCompileShaderResult;
import io.homo.superresolution.core.graphics.glslang.GlslangShaderCompiler;
import io.homo.superresolution.core.graphics.glslang.enums.EProfile;
import io.homo.superresolution.core.graphics.glslang.enums.EShClient;
import io.homo.superresolution.core.graphics.glslang.enums.EShLanguage;
import io.homo.superresolution.core.graphics.glslang.enums.EShSource;
import io.homo.superresolution.core.graphics.glslang.enums.EShTargetClientVersion;
import io.homo.superresolution.core.graphics.glslang.enums.EShTargetLanguage;
import io.homo.superresolution.core.graphics.glslang.enums.EShTargetLanguageVersion;
import io.homo.superresolution.core.graphics.glslang.enums.GlslangCompileShaderError;
import io.homo.superresolution.core.graphics.impl.IDebuggableObject;
import io.homo.superresolution.core.graphics.impl.shader.IShaderProgram;
import io.homo.superresolution.core.graphics.impl.shader.ShaderCompileException;
import io.homo.superresolution.core.graphics.impl.shader.ShaderDescription;
import io.homo.superresolution.core.graphics.impl.shader.ShaderSource;
import io.homo.superresolution.core.graphics.impl.shader.ShaderType;
import io.homo.superresolution.core.graphics.opengl.Gl;
import io.homo.superresolution.core.graphics.opengl.GlDebug;
import io.homo.superresolution.core.graphics.opengl.shader.GlShader;
import io.homo.superresolution.core.graphics.opengl.shader.uniform.GlShaderUniforms;
import io.homo.superresolution.core.graphics.shader.ShaderCompiler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.lwjgl.opengl.GL46;

public class GlShaderProgram
implements IShaderProgram<GlShaderUniforms>,
IDebuggableObject {
    private final ShaderDescription description;
    private int handle;
    private boolean isCompiled = false;
    private GlShaderUniforms uniforms;

    public GlShaderProgram(ShaderDescription description) {
        this.description = description;
        this.handle = GL46.glCreateProgram();
    }

    @Override
    public long handle() {
        return this.handle;
    }

    @Override
    public String getDebugLabel() {
        return this.description.shaderName() + "-" + this.handle;
    }

    @Override
    public void updateDebugLabel(String newLabel) {
        GlDebug.objectLabel(33506, this.handle, newLabel);
    }

    protected void checkProgram() {
        if (GL46.glGetProgrami((int)this.handle, (int)35714) == 0) {
            String log = GL46.glGetProgramInfoLog((int)this.handle);
            String errorDetails = String.format("\u7740\u8272\u5668\u7a0b\u5e8f '%s' \u94fe\u63a5\u5931\u8d25\uff0c\u6682\u65f6\u5ffd\u7565\n\u9519\u8bef\u65e5\u5fd7:\n%s", this.description.shaderName(), log);
            SuperResolution.LOGGER.error(errorDetails);
            this.saveLinkErrorArtifacts(log);
        }
    }

    protected String preprocessShaderCode(String code) {
        List<String> codeLines = List.of(code.split("\n"));
        ArrayList<String> preprocessedCodeLines = new ArrayList<String>();
        for (String line : codeLines) {
            if (line.trim().startsWith("#line") || line.trim().startsWith("#extension") && line.contains("GL_GOOGLE_include_directive")) continue;
            preprocessedCodeLines.add(line);
        }
        return String.join((CharSequence)"\n", preprocessedCodeLines);
    }

    protected GlShader compileSingleShader(ShaderSource source, boolean compat) {
        int glShaderType = switch (source.getType()) {
            default -> throw new MatchException(null, null);
            case ShaderType.Vertex -> 35633;
            case ShaderType.Compute -> 37305;
            case ShaderType.Fragment -> 35632;
        };
        Objects.requireNonNull(source, "ShaderSource cannot be null");
        GlShader shader = new GlShader(source.getType());
        if (shader.id() == 0) {
            throw new RuntimeException("Failed to create shader object (Type: " + glShaderType + ")");
        }
        try {
            String sourceCode = source.getSource();
            if (compat) {
                ShaderCompiler.LOGGER.info("\u4f7f\u7528\u517c\u5bb9\u6027\u7740\u8272\u5668\u7f16\u8bd1\u5668\u7f16\u8bd1\u7740\u8272\u5668 {}", (Object)this.description.shaderName());
                String string = source.getSource();
                GlslangCompileShaderResult result = GlslangShaderCompiler.compileShaderToSpirv(string, switch (source.getType()) {
                    default -> throw new MatchException(null, null);
                    case ShaderType.Vertex -> EShLanguage.EShLangVertex;
                    case ShaderType.Fragment -> EShLanguage.EShLangFragment;
                    case ShaderType.Compute -> EShLanguage.EShLangCompute;
                }, EShSource.EShSourceGlsl, EShClient.EShClientOpenGL, EShTargetClientVersion.EShTargetOpenGL_450, EShTargetLanguage.EShTargetSpv, EShTargetLanguageVersion.EShTargetSpv_1_4, Gl.isLegacy() ? 410 : 460, EProfile.ENoProfile, true, false);
                sourceCode = this.preprocessShaderCode(result.preprocessedCode());
                if (result.error() == GlslangCompileShaderError.PREPROCESS_ERROR) {
                    String errorDetails = String.format("%s Shader \u9884\u5904\u7406\u5931\u8d25\n\u7c7b\u578b: %s\n\u9519\u8bef\u65e5\u5fd7:\n%s", new Object[]{source.getType(), result.error().name(), result.log()});
                    SuperResolution.LOGGER.error(errorDetails);
                    this.saveErrorArtifacts(source.getType(), sourceCode, result.log());
                    throw new ShaderCompileException(errorDetails);
                }
                GL46.glShaderSource((int)shader.id(), (CharSequence)sourceCode);
                GL46.glCompileShader((int)shader.id());
            } else {
                ShaderCompiler.ShaderBinary binary = ShaderCompiler.getOpenGLShaderBinary(this, source.getType());
                if (binary == null) {
                    throw new RuntimeException("SPIR-V binary not found for " + String.valueOf((Object)source.getType()));
                }
                GL46.glShaderBinary((int[])new int[]{shader.id()}, (int)binary.format(), (ByteBuffer)binary.binary());
                GL46.glSpecializeShader((int)shader.id(), (CharSequence)"main", null, (int[])null);
                binary.close();
            }
            if (GL46.glGetShaderi((int)shader.id(), (int)35713) == 0) {
                String infoLog = GL46.glGetShaderInfoLog((int)shader.id());
                String errorDetails = SuperResolutionConfig.isEnableCompatShaderCompiler() ? String.format("%s Shader \u7f16\u8bd1\u5931\u8d25\n\u9519\u8bef\u65e5\u5fd7:\n%s", source.getType().name(), infoLog) : String.format("%s Shader SPIR-V\u52a0\u8f7d\u5931\u8d25\n\u9519\u8bef\u65e5\u5fd7:\n%s", source.getType().name(), infoLog);
                SuperResolution.LOGGER.error(errorDetails);
                this.saveErrorArtifacts(source.getType(), sourceCode, infoLog);
                throw new ShaderCompileException(errorDetails);
            }
            GlDebug.objectLabel(33505, shader.id(), "Shader_" + String.valueOf((Object)source.getType()));
            return shader;
        }
        catch (Exception e) {
            shader.destroy();
            throw e;
        }
    }

    private void saveErrorArtifacts(ShaderType type, String sourceCode, String log) {
        String time = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String baseName = String.format("errorArtifact_%s_%s.%s", this.description.shaderName(), type.name(), time);
        Path sourcePath = Path.of(baseName + ".glsl", new String[0]);
        Path logPath = Path.of(baseName + ".log", new String[0]);
        try {
            Files.writeString(sourcePath, (CharSequence)sourceCode, new OpenOption[0]);
            Files.writeString(logPath, (CharSequence)log, new OpenOption[0]);
            SuperResolution.LOGGER.info("\u4fdd\u5b58\u9519\u8bef\u7740\u8272\u5668\u6e90\u7801\u81f3: {}, \u65e5\u5fd7\u81f3: {}", (Object)sourcePath, (Object)logPath);
        }
        catch (IOException e) {
            SuperResolution.LOGGER.error("\u65e0\u6cd5\u4fdd\u5b58\u7740\u8272\u5668\u6e90\u7801\u6216\u65e5\u5fd7\u6587\u4ef6: {}", (Object)e.getMessage());
        }
    }

    private void saveLinkErrorArtifacts(String log) {
        String time = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String baseName = String.format("linkError_%s.%s", this.description.shaderName(), time);
        Path logPath = Path.of(baseName + ".log", new String[0]);
        Path infoPath = Path.of(baseName + ".info", new String[0]);
        try {
            Files.writeString(logPath, (CharSequence)log, new OpenOption[0]);
            StringBuilder info = new StringBuilder();
            info.append("\u7740\u8272\u5668\u7a0b\u5e8f: ").append(this.description.shaderName()).append("\n");
            info.append("\u94fe\u63a5\u72b6\u6001: GL_FALSE\n");
            info.append("\n\u9644\u52a0\u7684\u7740\u8272\u5668\u4fe1\u606f:\n");
            int attachedShaders = GL46.glGetProgrami((int)this.handle, (int)35717);
            info.append("\u9644\u52a0\u7684\u7740\u8272\u5668\u6570\u91cf: ").append(attachedShaders).append("\n");
            this.description.sourceMap().forEach((type, source) -> {
                info.append("\u9644\u52a0\u7684\u7740\u8272\u5668\u7c7b\u578b: ").append(type.name()).append("\n");
                info.append("\u9644\u52a0\u7684\u7740\u8272\u5668\u4ee3\u7801: ").append(source.getSource()).append("\n");
            });
            Files.writeString(infoPath, (CharSequence)info.toString(), new OpenOption[0]);
            SuperResolution.LOGGER.info("\u4fdd\u5b58\u94fe\u63a5\u9519\u8bef\u65e5\u5fd7\u81f3: {}, \u7a0b\u5e8f\u4fe1\u606f\u81f3: {}", (Object)logPath, (Object)infoPath);
        }
        catch (IOException e) {
            SuperResolution.LOGGER.error("\u65e0\u6cd5\u4fdd\u5b58\u94fe\u63a5\u9519\u8bef\u4fe1\u606f: {}", (Object)e.getMessage());
        }
    }

    private void validateShaderTypes() {
        Set<ShaderType> types = this.description.sourceMap().keySet();
        if (types.contains((Object)ShaderType.Vertex) || types.contains((Object)ShaderType.Fragment)) {
            if (!types.contains((Object)ShaderType.Vertex) || !types.contains((Object)ShaderType.Fragment)) {
                throw new IllegalStateException("\u901a\u7528\u7740\u8272\u5668\u5fc5\u987b\u540c\u65f6\u62e5\u6709VERTEX\u4e0eFRAGMENT\u7c7b\u578b\u7684ShaderSource");
            }
            if (types.stream().anyMatch(t -> t != ShaderType.Vertex && t != ShaderType.Fragment)) {
                throw new IllegalStateException("\u901a\u7528\u7740\u8272\u5668\u4ec5\u652f\u6301VERTEX\u4e0eFRAGMENT\u7c7b\u578b\u7684ShaderSource");
            }
        } else if (types.size() != 1 || !types.contains((Object)ShaderType.Compute)) {
            throw new IllegalStateException("\u8ba1\u7b97\u7740\u8272\u5668\u53ea\u9700\u8981\u4e00\u4e2a\u7740\u8272\u5668\u6e90\u7801\u4e14\u7c7b\u578b\u5fc5\u987b\u4e3aCOMPUTE");
        }
    }

    @Override
    public void compile() {
        this.compile(SuperResolutionConfig.isEnableCompatShaderCompiler());
    }

    public void compile(boolean compat) {
        EnumMap<ShaderType, ShaderSource> shaderSources = this.description.sourceMap();
        this.validateShaderTypes();
        if (!(SuperResolutionConfig.isEnableCompatShaderCompiler() || compat || ShaderCompiler.checkOpenGLProgramBinary(this))) {
            ShaderCompiler.saveOpenGLProgramBinary(this);
        }
        ArrayList shaders = new ArrayList();
        try {
            shaderSources.forEach((type, source) -> {
                GlShader shader = this.compileSingleShader((ShaderSource)source, SuperResolutionConfig.isEnableCompatShaderCompiler() || compat);
                shaders.add(shader);
            });
            if (this.handle != 0) {
                GL46.glDeleteProgram((int)this.handle);
            }
            this.handle = GL46.glCreateProgram();
            GL46.glFlush();
            shaders.forEach(s -> GL46.glAttachShader((int)this.handle, (int)s.id()));
            GL46.glLinkProgram((int)this.handle);
            GL46.glFlush();
            this.checkProgram();
            this.updateDebugLabel(this.getDebugLabel());
            this.isCompiled = true;
        }
        catch (ShaderCompileException e) {
            throw e;
        }
        catch (Exception e) {
            SuperResolution.LOGGER.error("\u7740\u8272\u5668\u7a0b\u5e8f '{}' \u7f16\u8bd1\u8fc7\u7a0b\u4e2d\u53d1\u751f\u672a\u9884\u671f\u7684\u9519\u8bef", (Object)this.description.shaderName(), (Object)e);
            e.printStackTrace();
            throw new ShaderCompileException("\u7740\u8272\u5668\u7a0b\u5e8f\u7f16\u8bd1\u5931\u8d25: " + e.getMessage());
        }
        finally {
            shaders.forEach(GlShader::destroy);
        }
        this.uniforms = new GlShaderUniforms(this, this.getDescription());
    }

    @Override
    public boolean isCompiled() {
        return this.isCompiled;
    }

    @Override
    public void destroy() {
        if (this.uniforms != null) {
            this.uniforms.destroy();
        }
        if (this.handle != 0) {
            GL46.glDeleteProgram((int)this.handle);
            this.handle = 0;
        }
    }

    @Override
    public ShaderDescription getDescription() {
        return this.description;
    }

    @Override
    public GlShaderUniforms uniforms() {
        if (!this.isCompiled) {
            throw new RuntimeException("\u7740\u8272\u5668\u5c1a\u672a\u7f16\u8bd1");
        }
        return this.uniforms;
    }
}

