/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.system;

import io.homo.superresolution.core.graphics.impl.BlendFactor;
import io.homo.superresolution.core.graphics.impl.DepthFunc;

public interface IRenderState {
    public float[] viewport();

    public IRenderState viewport(float var1, float var2, float var3, float var4);

    public boolean depthTest();

    public IRenderState depthTest(boolean var1);

    public boolean depthWrite();

    public IRenderState depthWrite(boolean var1);

    public boolean blend();

    public IRenderState blend(boolean var1);

    public boolean cullFace();

    public IRenderState cullFace(boolean var1);

    public boolean stencilTest();

    public IRenderState stencilTest(boolean var1);

    public boolean colorMaskR();

    public IRenderState colorMaskR(boolean var1);

    public boolean colorMaskG();

    public IRenderState colorMaskG(boolean var1);

    public boolean colorMaskB();

    public IRenderState colorMaskB(boolean var1);

    public boolean colorMaskA();

    public IRenderState colorMaskA(boolean var1);

    default public IRenderState colorMask(boolean r, boolean g, boolean b, boolean a) {
        this.colorMaskR(r);
        this.colorMaskG(g);
        this.colorMaskB(b);
        this.colorMaskA(a);
        return this;
    }

    public BlendFactor blendSrcFactor();

    public IRenderState blendSrcFactor(BlendFactor var1);

    public BlendFactor blendDstFactor();

    public IRenderState blendDstFactor(BlendFactor var1);

    default public IRenderState blendFunc(BlendFactor src, BlendFactor dst) {
        return this.blendSrcFactor(src).blendDstFactor(dst);
    }

    public DepthFunc depthFunc();

    public IRenderState depthFunc(DepthFunc var1);

    public StateSnapshot get();

    default public void apply(StateSnapshot snapshot) {
        this.depthTest(snapshot.depthTest);
        this.depthWrite(snapshot.depthWrite);
        this.blend(snapshot.blend);
        this.cullFace(snapshot.cullFace);
        this.stencilTest(snapshot.stencilTest);
        this.colorMaskR(snapshot.colorMaskR);
        this.colorMaskG(snapshot.colorMaskG);
        this.colorMaskB(snapshot.colorMaskB);
        this.colorMaskA(snapshot.colorMaskA);
        this.blendSrcFactor(snapshot.blendSrcFactor);
        this.blendDstFactor(snapshot.blendDstFactor);
        this.depthFunc(snapshot.depthFunc);
    }

    public static class StateSnapshot {
        public final boolean depthTest;
        public final boolean depthWrite;
        public final boolean blend;
        public final boolean cullFace;
        public final boolean stencilTest;
        public final boolean colorMaskR;
        public final boolean colorMaskG;
        public final boolean colorMaskB;
        public final boolean colorMaskA;
        public final BlendFactor blendSrcFactor;
        public final BlendFactor blendDstFactor;
        public final DepthFunc depthFunc;
        public final float[] viewport;

        public StateSnapshot(IRenderState state) {
            this.depthTest = state.depthTest();
            this.depthWrite = state.depthWrite();
            this.blend = state.blend();
            this.cullFace = state.cullFace();
            this.stencilTest = state.stencilTest();
            this.colorMaskR = state.colorMaskR();
            this.colorMaskG = state.colorMaskG();
            this.colorMaskB = state.colorMaskB();
            this.colorMaskA = state.colorMaskA();
            this.blendSrcFactor = state.blendSrcFactor();
            this.blendDstFactor = state.blendDstFactor();
            this.depthFunc = state.depthFunc();
            this.viewport = state.viewport();
        }
    }
}

