/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.vulkan.utils;

import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VkExtensionProperties;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkPhysicalDeviceFeatures;
import org.lwjgl.vulkan.VkPhysicalDeviceMemoryProperties;
import org.lwjgl.vulkan.VkPhysicalDeviceProperties;

public class VulkanCapabilities {
    private VkInstance instance;
    private VkPhysicalDevice physicalDevice;
    private List<String> instanceExtensions = new ArrayList<String>();
    private List<String> deviceExtensions = new ArrayList<String>();
    private VkPhysicalDeviceProperties deviceProperties;
    private VkPhysicalDeviceFeatures deviceFeatures;
    private VkPhysicalDeviceMemoryProperties memoryProperties;
    private boolean initialized = false;

    public void init(VkInstance instance, VkPhysicalDevice physicalDevice) {
        if (this.initialized) {
            return;
        }
        this.instance = instance;
        this.physicalDevice = physicalDevice;
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer extensionCount = stack.ints(0);
            VK10.vkEnumerateInstanceExtensionProperties((CharSequence)null, (IntBuffer)extensionCount, null);
            VkExtensionProperties.Buffer iExts = VkExtensionProperties.malloc((int)extensionCount.get(0));
            VK10.vkEnumerateInstanceExtensionProperties((CharSequence)null, (IntBuffer)extensionCount, (VkExtensionProperties.Buffer)iExts);
            this.instanceExtensions.clear();
            for (int i = 0; i < iExts.capacity(); ++i) {
                this.instanceExtensions.add(((VkExtensionProperties)iExts.get(i)).extensionNameString());
            }
            extensionCount.rewind();
            VK10.vkEnumerateDeviceExtensionProperties((VkPhysicalDevice)physicalDevice, (CharSequence)null, (IntBuffer)extensionCount, null);
            VkExtensionProperties.Buffer dExts = VkExtensionProperties.malloc((int)extensionCount.get(0));
            VK10.vkEnumerateDeviceExtensionProperties((VkPhysicalDevice)physicalDevice, (CharSequence)null, (IntBuffer)extensionCount, (VkExtensionProperties.Buffer)dExts);
            this.deviceExtensions.clear();
            for (int i = 0; i < dExts.capacity(); ++i) {
                this.deviceExtensions.add(((VkExtensionProperties)dExts.get(i)).extensionNameString());
            }
            this.deviceProperties = VkPhysicalDeviceProperties.malloc();
            VK10.vkGetPhysicalDeviceProperties((VkPhysicalDevice)physicalDevice, (VkPhysicalDeviceProperties)this.deviceProperties);
            this.deviceFeatures = VkPhysicalDeviceFeatures.malloc();
            VK10.vkGetPhysicalDeviceFeatures((VkPhysicalDevice)physicalDevice, (VkPhysicalDeviceFeatures)this.deviceFeatures);
            this.memoryProperties = VkPhysicalDeviceMemoryProperties.malloc();
            VK10.vkGetPhysicalDeviceMemoryProperties((VkPhysicalDevice)physicalDevice, (VkPhysicalDeviceMemoryProperties)this.memoryProperties);
            this.initialized = true;
        }
    }

    public void destroy() {
        if (this.deviceProperties != null) {
            this.deviceProperties.free();
            this.deviceProperties = null;
        }
        if (this.deviceFeatures != null) {
            this.deviceFeatures.free();
            this.deviceFeatures = null;
        }
        if (this.memoryProperties != null) {
            this.memoryProperties.free();
            this.memoryProperties = null;
        }
        this.instanceExtensions = Collections.emptyList();
        this.deviceExtensions = Collections.emptyList();
        this.initialized = false;
    }

    public List<String> getInstanceExtensions() {
        return this.instanceExtensions;
    }

    public List<String> getDeviceExtensions() {
        return this.deviceExtensions;
    }

    public VkPhysicalDeviceProperties getDeviceProperties() {
        return this.deviceProperties;
    }

    public VkPhysicalDeviceFeatures getDeviceFeatures() {
        return this.deviceFeatures;
    }

    public VkPhysicalDeviceMemoryProperties getMemoryProperties() {
        return this.memoryProperties;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

