/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.icyllis.modernui.animation;

import io.homo.superresolution.thirdparty.icyllis.modernui.animation.Animator;
import io.homo.superresolution.thirdparty.icyllis.modernui.animation.ObjectAnimator;
import io.homo.superresolution.thirdparty.icyllis.modernui.annotation.NonNull;
import io.homo.superresolution.thirdparty.icyllis.modernui.core.Core;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class AnimationHandler {
    private static volatile AnimationHandler instance;
    private static final Object instanceLock;
    private final ArrayList<FrameCallback> animationCallbacks = new ArrayList();
    private final Object2LongOpenHashMap<FrameCallback> delayedStartTime = new Object2LongOpenHashMap();
    private boolean isListDirty = false;

    private AnimationHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static AnimationHandler getInstance() {
        if (instance == null) {
            Object object = instanceLock;
            synchronized (object) {
                if (instance == null) {
                    instance = new AnimationHandler();
                }
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAnimationCount() {
        if (instance == null) {
            return 0;
        }
        ArrayList<FrameCallback> arrayList = AnimationHandler.instance.animationCallbacks;
        synchronized (arrayList) {
            return instance.getCallbackSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFrameCallback(@NonNull FrameCallback callback, long delay) {
        ArrayList<FrameCallback> arrayList = this.animationCallbacks;
        synchronized (arrayList) {
            boolean newlyAdded;
            if (!this.animationCallbacks.contains(callback)) {
                this.animationCallbacks.add(callback);
                newlyAdded = true;
            } else {
                newlyAdded = false;
            }
            if (delay > 0L) {
                this.delayedStartTime.put((Object)callback, Core.timeMillis() + delay);
            } else if (!newlyAdded) {
                this.delayedStartTime.removeLong((Object)callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallback(@NonNull FrameCallback callback) {
        ArrayList<FrameCallback> arrayList = this.animationCallbacks;
        synchronized (arrayList) {
            int id = this.animationCallbacks.indexOf(callback);
            if (id >= 0) {
                this.animationCallbacks.set(id, null);
                this.delayedStartTime.removeLong((Object)callback);
                this.isListDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAnimationFrame(long frameTime) {
        ArrayList<FrameCallback> callbacks;
        long currentTime = Core.timeMillis();
        ArrayList<FrameCallback> arrayList = this.animationCallbacks;
        synchronized (arrayList) {
            callbacks = new ArrayList<FrameCallback>(this.animationCallbacks);
        }
        for (int i = 0; i < callbacks.size(); ++i) {
            FrameCallback callback = callbacks.get(i);
            if (callback == null || !this.isCallbackDue(callback, currentTime)) continue;
            callback.doAnimationFrame(frameTime);
        }
        ArrayList<FrameCallback> arrayList2 = this.animationCallbacks;
        synchronized (arrayList2) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCallbackDue(@NonNull FrameCallback callback, long currentTime) {
        ArrayList<FrameCallback> arrayList = this.animationCallbacks;
        synchronized (arrayList) {
            long startTime = this.delayedStartTime.getLong((Object)callback);
            if (startTime == 0L) {
                return true;
            }
            if (currentTime >= startTime) {
                this.delayedStartTime.removeLong((Object)callback);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void autoCancelBasedOn(@NonNull ObjectAnimator animator) {
        ArrayList<FrameCallback> arrayList = this.animationCallbacks;
        synchronized (arrayList) {
            for (int i = this.animationCallbacks.size() - 1; i >= 0; --i) {
                FrameCallback cb = this.animationCallbacks.get(i);
                if (cb == null || !animator.shouldAutoCancel(cb)) continue;
                ((Animator)((Object)cb)).cancel();
            }
        }
    }

    private void cleanUpList() {
        if (this.isListDirty) {
            for (int i = this.animationCallbacks.size() - 1; i >= 0; --i) {
                if (this.animationCallbacks.get(i) != null) continue;
                this.animationCallbacks.remove(i);
            }
            this.isListDirty = false;
        }
    }

    private int getCallbackSize() {
        int count = 0;
        for (int i = this.animationCallbacks.size() - 1; i >= 0; --i) {
            if (this.animationCallbacks.get(i) == null) continue;
            ++count;
        }
        return count;
    }

    static {
        instanceLock = new Object();
    }

    public static interface FrameCallback {
        public boolean doAnimationFrame(long var1);
    }
}

