/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.icyllis.modernui.util;

import io.homo.superresolution.common.SuperResolution;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ArrayMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final Marker MARKER = MarkerFactory.getMarker((String)"ArrayMap");
    private static final int BASE_SIZE = 4;
    private static final int CACHE_SIZE = 10;
    private static Object[] mBaseCache;
    private static int mBaseCacheSize;
    private static Object[] mTwiceBaseCache;
    private static int mTwiceBaseCacheSize;
    private static final Object sBaseCacheLock;
    private static final Object sTwiceBaseCacheLock;
    private final boolean mIdentityHashCode;
    int[] mHashes;
    Object[] mArray;
    int mSize;
    EntrySet mEntrySet;
    KeySet mKeySet;
    ValuesCollection mValues;

    public ArrayMap() {
        this(0, false);
    }

    public ArrayMap(int initialCapacity) {
        this(initialCapacity, false);
    }

    @ApiStatus.Internal
    public ArrayMap(int initialCapacity, boolean identityHashCode) {
        this.mIdentityHashCode = identityHashCode;
        if (initialCapacity == 0) {
            this.mHashes = IntArrays.EMPTY_ARRAY;
            this.mArray = ObjectArrays.EMPTY_ARRAY;
        } else if (initialCapacity > 0) {
            this.allocArrays(initialCapacity);
        } else {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
    }

    public ArrayMap(@Nonnull Map<K, V> map) {
        this(0, false);
        this.putAll(map);
    }

    @Override
    public void clear() {
        if (this.mSize > 0) {
            int[] hashes = this.mHashes;
            Object[] array = this.mArray;
            int size = this.mSize;
            this.mHashes = IntArrays.EMPTY_ARRAY;
            this.mArray = ObjectArrays.EMPTY_ARRAY;
            this.mSize = 0;
            ArrayMap.freeArrays(hashes, array, size);
        }
        if (this.mSize > 0) {
            throw new ConcurrentModificationException();
        }
    }

    @ApiStatus.Internal
    public void erase() {
        if (this.mSize > 0) {
            int N = this.mSize << 1;
            Object[] array = this.mArray;
            for (int i = 0; i < N; ++i) {
                array[i] = null;
            }
            this.mSize = 0;
        }
    }

    public void ensureCapacity(int minimumCapacity) {
        int size = this.mSize;
        if (this.mHashes.length < minimumCapacity) {
            int[] hashes = this.mHashes;
            Object[] array = this.mArray;
            this.allocArrays(minimumCapacity);
            if (this.mSize > 0) {
                System.arraycopy(hashes, 0, this.mHashes, 0, size);
                System.arraycopy(array, 0, this.mArray, 0, size << 1);
            }
            ArrayMap.freeArrays(hashes, array, size);
        }
        if (this.mSize != size) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.indexOfKey(key) >= 0;
    }

    public int indexOfKey(Object key) {
        return key == null ? this.indexOfNull() : this.indexOf(key, this.mIdentityHashCode ? System.identityHashCode(key) : key.hashCode());
    }

    public int indexOfValue(Object value) {
        int N = this.mSize * 2;
        Object[] array = this.mArray;
        if (value == null) {
            for (int i = 1; i < N; i += 2) {
                if (array[i] != null) continue;
                return i >> 1;
            }
        } else {
            for (int i = 1; i < N; i += 2) {
                if (!value.equals(array[i])) continue;
                return i >> 1;
            }
        }
        return -1;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.indexOfValue(value) >= 0;
    }

    @Override
    public V get(Object key) {
        int index = this.indexOfKey(key);
        return (V)(index >= 0 ? this.mArray[(index << 1) + 1] : null);
    }

    public K keyAt(int index) {
        if (index >= this.mSize) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (K)this.mArray[index << 1];
    }

    public V valueAt(int index) {
        if (index >= this.mSize) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (V)this.mArray[(index << 1) + 1];
    }

    public V setValueAt(int index, V value) {
        if (index >= this.mSize) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        index = (index << 1) + 1;
        Object old = this.mArray[index];
        this.mArray[index] = value;
        return (V)old;
    }

    @Override
    public boolean isEmpty() {
        return this.mSize == 0;
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        int index;
        int hash;
        int oldSize = this.mSize;
        if (key == null) {
            hash = 0;
            index = this.indexOfNull();
        } else {
            hash = this.mIdentityHashCode ? System.identityHashCode(key) : key.hashCode();
            index = this.indexOf(key, hash);
        }
        if (index >= 0) {
            index = (index << 1) + 1;
            Object old = this.mArray[index];
            this.mArray[index] = value;
            return (V)old;
        }
        index ^= 0xFFFFFFFF;
        if (oldSize >= this.mHashes.length) {
            int n = oldSize >= 8 ? oldSize + (oldSize >> 1) : (oldSize >= 4 ? 8 : 4);
            int[] hashes = this.mHashes;
            Object[] array = this.mArray;
            this.allocArrays(n);
            if (oldSize != this.mSize) {
                throw new ConcurrentModificationException();
            }
            if (this.mHashes.length > 0) {
                System.arraycopy(hashes, 0, this.mHashes, 0, hashes.length);
                System.arraycopy(array, 0, this.mArray, 0, array.length);
            }
            ArrayMap.freeArrays(hashes, array, oldSize);
        }
        if (index < oldSize) {
            System.arraycopy(this.mHashes, index, this.mHashes, index + 1, oldSize - index);
            System.arraycopy(this.mArray, index << 1, this.mArray, index + 1 << 1, this.mSize - index << 1);
        }
        if (oldSize != this.mSize || index >= this.mHashes.length) {
            throw new ConcurrentModificationException();
        }
        this.mHashes[index] = hash;
        this.mArray[index << 1] = key;
        this.mArray[(index << 1) + 1] = value;
        ++this.mSize;
        return null;
    }

    @ApiStatus.Internal
    public void append(K key, V value) {
        int hash;
        int index = this.mSize;
        int n = key == null ? 0 : (hash = this.mIdentityHashCode ? System.identityHashCode(key) : key.hashCode());
        if (index >= this.mHashes.length) {
            throw new IllegalStateException("Array is full");
        }
        if (index > 0 && this.mHashes[index - 1] > hash) {
            SuperResolution.LOGGER.warn(MARKER, "New hash " + hash + " is before end of array hash " + this.mHashes[index - 1] + " at index " + index + " key " + String.valueOf(key), new RuntimeException("here").fillInStackTrace());
            this.put(key, value);
            return;
        }
        this.mSize = index + 1;
        this.mHashes[index] = hash;
        this.mArray[index <<= 1] = key;
        this.mArray[index + 1] = value;
    }

    @ApiStatus.Internal
    public void validate() {
        int size = this.mSize;
        if (size <= 1) {
            return;
        }
        int baseHash = this.mHashes[0];
        int baseIndex = 0;
        for (int i = 1; i < size; ++i) {
            int hash = this.mHashes[i];
            if (hash != baseHash) {
                baseHash = hash;
                baseIndex = i;
                continue;
            }
            Object cur = this.mArray[i << 1];
            for (int j = i - 1; j >= baseIndex; --j) {
                Object prev = this.mArray[j << 1];
                if (cur == prev) {
                    throw new IllegalArgumentException("Duplicate key in ArrayMap: " + String.valueOf(cur));
                }
                if (cur == null || !cur.equals(prev)) continue;
                throw new IllegalArgumentException("Duplicate key in ArrayMap: " + String.valueOf(cur));
            }
        }
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Objects.requireNonNull(action);
        int size = this.mSize;
        for (int i = 0; i < size; ++i) {
            if (size != this.mSize) {
                throw new ConcurrentModificationException();
            }
            action.accept(this.keyAt(i), this.valueAt(i));
        }
    }

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends V> map) {
        block4: {
            block2: {
                int size;
                ArrayMap array;
                block3: {
                    if (!(map instanceof ArrayMap)) break block2;
                    array = (ArrayMap)map;
                    size = array.mSize;
                    this.ensureCapacity(this.mSize + size);
                    if (this.mSize != 0) break block3;
                    if (size <= 0) break block4;
                    System.arraycopy(array.mHashes, 0, this.mHashes, 0, size);
                    System.arraycopy(array.mArray, 0, this.mArray, 0, size << 1);
                    this.mSize = size;
                    break block4;
                }
                for (int i = 0; i < size; ++i) {
                    this.put(array.keyAt(i), array.valueAt(i));
                }
                break block4;
            }
            this.ensureCapacity(this.mSize + map.size());
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public V remove(Object key) {
        int index = this.indexOfKey(key);
        if (index >= 0) {
            return this.removeAt(index);
        }
        return null;
    }

    public V removeAt(int index) {
        int newSize;
        if (index >= this.mSize) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        Object old = this.mArray[(index << 1) + 1];
        int oldSize = this.mSize;
        if (oldSize <= 1) {
            int[] hashes = this.mHashes;
            Object[] array = this.mArray;
            this.mHashes = IntArrays.EMPTY_ARRAY;
            this.mArray = ObjectArrays.EMPTY_ARRAY;
            ArrayMap.freeArrays(hashes, array, oldSize);
            newSize = 0;
        } else {
            newSize = oldSize - 1;
            if (this.mHashes.length > 8 && this.mSize < this.mHashes.length / 3) {
                int n = oldSize > 8 ? oldSize + (oldSize >> 1) : 8;
                int[] hashes = this.mHashes;
                Object[] array = this.mArray;
                this.allocArrays(n);
                if (oldSize != this.mSize) {
                    throw new ConcurrentModificationException();
                }
                if (index > 0) {
                    System.arraycopy(hashes, 0, this.mHashes, 0, index);
                    System.arraycopy(array, 0, this.mArray, 0, index << 1);
                }
                if (index < newSize) {
                    System.arraycopy(hashes, index + 1, this.mHashes, index, newSize - index);
                    System.arraycopy(array, index + 1 << 1, this.mArray, index << 1, newSize - index << 1);
                }
            } else {
                if (index < newSize) {
                    System.arraycopy(this.mHashes, index + 1, this.mHashes, index, newSize - index);
                    System.arraycopy(this.mArray, index + 1 << 1, this.mArray, index << 1, newSize - index << 1);
                }
                this.mArray[newSize << 1] = null;
                this.mArray[(newSize << 1) + 1] = null;
            }
        }
        if (oldSize != this.mSize) {
            throw new ConcurrentModificationException();
        }
        this.mSize = newSize;
        return (V)old;
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            if (this.size() != map.size()) {
                return false;
            }
            try {
                for (int i = 0; i < this.mSize; ++i) {
                    K key = this.keyAt(i);
                    V mine = this.valueAt(i);
                    Object theirs = map.get(key);
                    if (!(mine == null ? theirs != null || !map.containsKey(key) : !mine.equals(theirs))) continue;
                    return false;
                }
            }
            catch (ClassCastException | NullPointerException ignored) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int[] hashes = this.mHashes;
        Object[] array = this.mArray;
        int result = 0;
        int i = 0;
        int v = 1;
        int s = this.mSize;
        while (i < s) {
            Object value = array[v];
            result += hashes[i] ^ (value == null ? 0 : value.hashCode());
            ++i;
            v += 2;
        }
        return result;
    }

    @Override
    @Nonnull
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.mSize * 28);
        buffer.append('{');
        for (int i = 0; i < this.mSize; ++i) {
            K key;
            if (i > 0) {
                buffer.append(", ");
            }
            if ((key = this.keyAt(i)) != this) {
                buffer.append(key);
            } else {
                buffer.append("(this Map)");
            }
            buffer.append('=');
            V value = this.valueAt(i);
            if (value != this) {
                buffer.append(ArrayMap.deepToString(value));
                continue;
            }
            buffer.append("(this Map)");
        }
        buffer.append('}');
        return buffer.toString();
    }

    private static String deepToString(Object value) {
        if (value != null && value.getClass().isArray()) {
            if (value.getClass() == boolean[].class) {
                return Arrays.toString((boolean[])value);
            }
            if (value.getClass() == byte[].class) {
                return Arrays.toString((byte[])value);
            }
            if (value.getClass() == char[].class) {
                return Arrays.toString((char[])value);
            }
            if (value.getClass() == double[].class) {
                return Arrays.toString((double[])value);
            }
            if (value.getClass() == float[].class) {
                return Arrays.toString((float[])value);
            }
            if (value.getClass() == int[].class) {
                return Arrays.toString((int[])value);
            }
            if (value.getClass() == long[].class) {
                return Arrays.toString((long[])value);
            }
            if (value.getClass() == short[].class) {
                return Arrays.toString((short[])value);
            }
            return Arrays.deepToString((Object[])value);
        }
        return String.valueOf(value);
    }

    public boolean containsAll(@Nonnull Collection<?> collection) {
        for (Object o : collection) {
            if (this.containsKey(o)) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(@Nonnull Collection<?> collection) {
        int oldSize = this.mSize;
        for (Object o : collection) {
            this.remove(o);
        }
        return oldSize != this.mSize;
    }

    public boolean retainAll(@Nonnull Collection<?> collection) {
        int oldSize = this.mSize;
        ArrayIterator it = new ArrayIterator(0);
        while (it.hasNext()) {
            if (collection.contains(it.next())) continue;
            it.remove();
        }
        return oldSize != this.mSize;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.mEntrySet == null) {
            this.mEntrySet = new EntrySet();
        }
        return this.mEntrySet;
    }

    @Override
    public Set<K> keySet() {
        if (this.mKeySet == null) {
            this.mKeySet = new KeySet();
        }
        return this.mKeySet;
    }

    @Override
    public Collection<V> values() {
        if (this.mValues == null) {
            this.mValues = new ValuesCollection();
        }
        return this.mValues;
    }

    int indexOf(@Nonnull Object key, int hash) {
        int end;
        int index;
        int N = this.mSize;
        if (N == 0) {
            return -1;
        }
        try {
            index = Arrays.binarySearch(this.mHashes, 0, N, hash);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ConcurrentModificationException();
        }
        if (index < 0) {
            return index;
        }
        if (key.equals(this.mArray[index << 1])) {
            return index;
        }
        for (end = index + 1; end < N && this.mHashes[end] == hash; ++end) {
            if (!key.equals(this.mArray[end << 1])) continue;
            return end;
        }
        for (int i = index - 1; i >= 0 && this.mHashes[i] == hash; --i) {
            if (!key.equals(this.mArray[i << 1])) continue;
            return i;
        }
        return ~end;
    }

    int indexOfNull() {
        int end;
        int index;
        int N = this.mSize;
        if (N == 0) {
            return -1;
        }
        try {
            index = Arrays.binarySearch(this.mHashes, 0, N, 0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ConcurrentModificationException();
        }
        if (index < 0) {
            return index;
        }
        if (null == this.mArray[index << 1]) {
            return index;
        }
        for (end = index + 1; end < N && this.mHashes[end] == 0; ++end) {
            if (null != this.mArray[end << 1]) continue;
            return end;
        }
        for (int i = index - 1; i >= 0 && this.mHashes[i] == 0; --i) {
            if (null != this.mArray[i << 1]) continue;
            return i;
        }
        return ~end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allocArrays(int size) {
        if (size == 8) {
            Object object = sTwiceBaseCacheLock;
            synchronized (object) {
                if (mTwiceBaseCache != null) {
                    Object[] array = mTwiceBaseCache;
                    this.mArray = array;
                    try {
                        mTwiceBaseCache = (Object[])array[0];
                        this.mHashes = (int[])array[1];
                        if (this.mHashes != null) {
                            array[1] = null;
                            array[0] = null;
                            --mTwiceBaseCacheSize;
                            return;
                        }
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    SuperResolution.LOGGER.error(MARKER, "Found corrupt ArrayMap cache: [0]=" + String.valueOf(array[0]) + " [1]=" + String.valueOf(array[1]));
                    mTwiceBaseCache = null;
                    mTwiceBaseCacheSize = 0;
                }
            }
        }
        if (size == 4) {
            Object object = sBaseCacheLock;
            synchronized (object) {
                if (mBaseCache != null) {
                    Object[] array = mBaseCache;
                    this.mArray = array;
                    try {
                        mBaseCache = (Object[])array[0];
                        this.mHashes = (int[])array[1];
                        if (this.mHashes != null) {
                            array[1] = null;
                            array[0] = null;
                            --mBaseCacheSize;
                            return;
                        }
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    SuperResolution.LOGGER.error(MARKER, "Found corrupt ArrayMap cache: [0]=" + String.valueOf(array[0]) + " [1]=" + String.valueOf(array[1]));
                    mBaseCache = null;
                    mBaseCacheSize = 0;
                }
            }
        }
        this.mHashes = new int[size];
        this.mArray = new Object[size << 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void freeArrays(@Nonnull int[] hashes, @Nonnull Object[] array, int size) {
        if (hashes.length == 8) {
            Object object = sTwiceBaseCacheLock;
            synchronized (object) {
                if (mTwiceBaseCacheSize < 10) {
                    array[0] = mTwiceBaseCache;
                    array[1] = hashes;
                    for (int i = (size << 1) - 1; i >= 2; --i) {
                        array[i] = null;
                    }
                    mTwiceBaseCache = array;
                    ++mTwiceBaseCacheSize;
                }
            }
        }
        if (hashes.length == 4) {
            Object object = sBaseCacheLock;
            synchronized (object) {
                if (mBaseCacheSize < 10) {
                    array[0] = mBaseCache;
                    array[1] = hashes;
                    for (int i = (size << 1) - 1; i >= 2; --i) {
                        array[i] = null;
                    }
                    mBaseCache = array;
                    ++mBaseCacheSize;
                }
            }
        }
    }

    static {
        sBaseCacheLock = new Object();
        sTwiceBaseCacheLock = new Object();
    }

    final class ArrayIterator<T>
    implements Iterator<T> {
        final int mOffset;
        int mIndex;
        boolean mCanRemove = false;

        ArrayIterator(int offset) {
            this.mOffset = offset;
        }

        @Override
        public boolean hasNext() {
            return this.mIndex < ArrayMap.this.mSize;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object res = ArrayMap.this.mArray[(this.mIndex << 1) + this.mOffset];
            ++this.mIndex;
            this.mCanRemove = true;
            return (T)res;
        }

        @Override
        public void remove() {
            if (!this.mCanRemove) {
                throw new IllegalStateException();
            }
            --this.mIndex;
            --ArrayMap.this.mSize;
            this.mCanRemove = false;
            ArrayMap.this.removeAt(this.mIndex);
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public boolean add(Map.Entry<K, V> kvEntry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(@Nonnull Collection<? extends Map.Entry<K, V>> collection) {
            int oldSize = ArrayMap.this.mSize;
            for (Map.Entry entry : collection) {
                ArrayMap.this.put(entry.getKey(), entry.getValue());
            }
            return oldSize != ArrayMap.this.mSize;
        }

        @Override
        public void clear() {
            ArrayMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            int index = ArrayMap.this.indexOfKey(e.getKey());
            if (index < 0) {
                return false;
            }
            return Objects.equals(ArrayMap.this.mArray[(index << 1) + 1], e.getValue());
        }

        @Override
        public boolean isEmpty() {
            return ArrayMap.this.mSize == 0;
        }

        @Override
        @Nonnull
        public Iterator<Map.Entry<K, V>> iterator() {
            return new MapIterator();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return ArrayMap.this.mSize;
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(@Nonnull T[] array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            if (c.size() != this.size()) {
                return false;
            }
            try {
                return this.containsAll(c);
            }
            catch (ClassCastException | NullPointerException ignored) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            int result = 0;
            for (int i = ArrayMap.this.mSize - 1; i >= 0; --i) {
                Object key = ArrayMap.this.mArray[i << 1];
                Object value = ArrayMap.this.mArray[(i << 1) + 1];
                result += (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
            }
            return result;
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public boolean add(K object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(@Nonnull Collection<? extends K> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ArrayMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return ArrayMap.this.indexOfKey(object) >= 0;
        }

        @Override
        public boolean containsAll(@Nonnull Collection<?> collection) {
            return ArrayMap.this.containsAll(collection);
        }

        @Override
        public boolean isEmpty() {
            return ArrayMap.this.mSize == 0;
        }

        @Override
        @Nonnull
        public Iterator<K> iterator() {
            return new ArrayIterator(0);
        }

        @Override
        public boolean remove(Object object) {
            int index = ArrayMap.this.indexOfKey(object);
            if (index >= 0) {
                ArrayMap.this.removeAt(index);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> collection) {
            return ArrayMap.this.removeAll(collection);
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> collection) {
            return ArrayMap.this.retainAll(collection);
        }

        @Override
        public int size() {
            return ArrayMap.this.mSize;
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int N = ArrayMap.this.mSize;
            Object[] result = new Object[N];
            for (int i = 0; i < N; ++i) {
                result[i] = ArrayMap.this.mArray[i << 1];
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] array) {
            int N = ArrayMap.this.mSize;
            if (array.length < N) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), N);
            }
            for (int i = 0; i < N; ++i) {
                array[i] = ArrayMap.this.mArray[i << 1];
            }
            if (array.length > N) {
                array[N] = null;
            }
            return array;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            if (c.size() != this.size()) {
                return false;
            }
            try {
                return this.containsAll(c);
            }
            catch (ClassCastException | NullPointerException ignored) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            int result = 0;
            for (int i = ArrayMap.this.mSize - 1; i >= 0; --i) {
                Object obj = ArrayMap.this.mArray[i << 1];
                result += obj == null ? 0 : obj.hashCode();
            }
            return result;
        }
    }

    final class ValuesCollection
    extends AbstractCollection<V> {
        ValuesCollection() {
        }

        @Override
        public boolean add(V object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(@Nonnull Collection<? extends V> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ArrayMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return ArrayMap.this.indexOfValue(object) >= 0;
        }

        @Override
        public boolean containsAll(@Nonnull Collection<?> collection) {
            for (Object o : collection) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return ArrayMap.this.mSize == 0;
        }

        @Override
        @Nonnull
        public Iterator<V> iterator() {
            return new ArrayIterator(1);
        }

        @Override
        public boolean remove(Object object) {
            int index = ArrayMap.this.indexOfValue(object);
            if (index >= 0) {
                ArrayMap.this.removeAt(index);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> collection) {
            int size = ArrayMap.this.mSize;
            boolean changed = false;
            for (int i = 0; i < size; ++i) {
                Object cur = ArrayMap.this.mArray[(i << 1) + 1];
                if (!collection.contains(cur)) continue;
                ArrayMap.this.removeAt(i);
                --i;
                --size;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> collection) {
            int size = ArrayMap.this.mSize;
            boolean changed = false;
            for (int i = 0; i < size; ++i) {
                Object cur = ArrayMap.this.mArray[(i << 1) + 1];
                if (collection.contains(cur)) continue;
                ArrayMap.this.removeAt(i);
                --i;
                --size;
                changed = true;
            }
            return changed;
        }

        @Override
        public int size() {
            return ArrayMap.this.mSize;
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = ArrayMap.this.mSize;
            Object[] result = new Object[size];
            for (int i = 0; i < size; ++i) {
                result[i] = ArrayMap.this.mArray[(i << 1) + 1];
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] array) {
            int size = ArrayMap.this.mSize;
            if (array.length < size) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
            }
            for (int i = 0; i < size; ++i) {
                array[i] = ArrayMap.this.mArray[(i << 1) + 1];
            }
            if (array.length > size) {
                array[size] = null;
            }
            return array;
        }
    }

    final class MapIterator
    implements Iterator<Map.Entry<K, V>>,
    Map.Entry<K, V> {
        int mEnd;
        int mIndex;
        boolean mEntryValid = false;

        MapIterator() {
            this.mEnd = ArrayMap.this.mSize - 1;
            this.mIndex = -1;
        }

        @Override
        public boolean hasNext() {
            return this.mIndex < this.mEnd;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.mIndex;
            this.mEntryValid = true;
            return this;
        }

        @Override
        public void remove() {
            if (!this.mEntryValid) {
                throw new IllegalStateException();
            }
            ArrayMap.this.removeAt(this.mIndex);
            --this.mIndex;
            --this.mEnd;
            this.mEntryValid = false;
        }

        @Override
        public K getKey() {
            if (!this.mEntryValid) {
                throw new IllegalStateException("This container does not support retaining Map.Entry objects");
            }
            return ArrayMap.this.mArray[this.mIndex << 1];
        }

        @Override
        public V getValue() {
            if (!this.mEntryValid) {
                throw new IllegalStateException("This container does not support retaining Map.Entry objects");
            }
            return ArrayMap.this.mArray[(this.mIndex << 1) + 1];
        }

        @Override
        public V setValue(V object) {
            if (!this.mEntryValid) {
                throw new IllegalStateException("This container does not support retaining Map.Entry objects");
            }
            return ArrayMap.this.setValueAt(this.mIndex, object);
        }

        @Override
        public boolean equals(Object o) {
            if (!this.mEntryValid) {
                throw new IllegalStateException("This container does not support retaining Map.Entry objects");
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Objects.equals(e.getKey(), ArrayMap.this.mArray[this.mIndex << 1]) && Objects.equals(e.getValue(), ArrayMap.this.mArray[(this.mIndex << 1) + 1]);
        }

        @Override
        public int hashCode() {
            if (!this.mEntryValid) {
                throw new IllegalStateException("This container does not support retaining Map.Entry objects");
            }
            Object key = ArrayMap.this.mArray[this.mIndex << 1];
            Object value = ArrayMap.this.mArray[(this.mIndex << 1) + 1];
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        @Nonnull
        public String toString() {
            return String.valueOf(this.getKey()) + "=" + String.valueOf(this.getValue());
        }
    }
}

