/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.api.config;

import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.io.ParsingException;
import io.homo.superresolution.api.config.ConfigValue;
import io.homo.superresolution.api.config.ListValue;
import io.homo.superresolution.api.config.ModConfigSpec;
import io.homo.superresolution.api.config.values.list.BooleanListValue;
import io.homo.superresolution.api.config.values.list.DoubleListValue;
import io.homo.superresolution.api.config.values.list.EnumListValue;
import io.homo.superresolution.api.config.values.list.FloatListValue;
import io.homo.superresolution.api.config.values.list.IntListValue;
import io.homo.superresolution.api.config.values.list.LongListValue;
import io.homo.superresolution.api.config.values.list.StringListValue;
import io.homo.superresolution.api.config.values.single.BooleanValue;
import io.homo.superresolution.api.config.values.single.DoubleValue;
import io.homo.superresolution.api.config.values.single.EnumValue;
import io.homo.superresolution.api.config.values.single.FloatValue;
import io.homo.superresolution.api.config.values.single.IntValue;
import io.homo.superresolution.api.config.values.single.LongValue;
import io.homo.superresolution.api.config.values.single.StringValue;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class ModConfigSpecBuilder {
    protected final Map<List<String>, ConfigValue<?>> values = new LinkedHashMap();
    protected final Map<List<String>, String> comments = new HashMap<List<String>, String>();
    protected boolean autoSave = false;
    protected boolean autoReload = false;
    protected final ConfigSpec spec = new ConfigSpec();
    protected List<String> lastPath = List.of();
    protected Path configPath;

    protected static List<String> splitPath(String path) {
        return Arrays.asList(path.split("/"));
    }

    public ModConfigSpecBuilder autoSave(boolean autoSave) {
        this.autoSave = autoSave;
        return this;
    }

    public ModConfigSpecBuilder autoReload(boolean autoReload) {
        this.autoReload = autoReload;
        return this;
    }

    public ModConfigSpecBuilder configPath(Path configPath) {
        this.configPath = configPath;
        return this;
    }

    public ModConfigSpecBuilder comment(String comment) {
        if (this.lastPath.isEmpty()) {
            throw new RuntimeException();
        }
        this.comments.put(new ArrayList<String>(this.lastPath), comment);
        return this;
    }

    public ModConfigSpecBuilder comment(String path, String comment) {
        this.comments.put(new ArrayList<String>(ModConfigSpecBuilder.splitPath(path)), comment);
        return this;
    }

    public BooleanValue defineBoolean(String path, Supplier<Boolean> defaultSupplier) {
        return this.defineBoolean(path, defaultSupplier, null, (Boolean v) -> true);
    }

    public BooleanValue defineBoolean(List<String> path, Supplier<Boolean> defaultSupplier) {
        return this.defineBoolean(path, defaultSupplier, null, (Boolean v) -> true);
    }

    public BooleanValue defineBoolean(String path, Supplier<Boolean> defaultSupplier, String comment) {
        return this.defineBoolean(path, defaultSupplier, comment, (Boolean v) -> true);
    }

    public BooleanValue defineBoolean(List<String> path, Supplier<Boolean> defaultSupplier, String comment) {
        return this.defineBoolean(path, defaultSupplier, comment, (Boolean v) -> true);
    }

    public BooleanValue defineBoolean(String path, Supplier<Boolean> defaultSupplier, Predicate<Boolean> validator) {
        return this.defineBoolean(path, defaultSupplier, null, validator);
    }

    public BooleanValue defineBoolean(List<String> path, Supplier<Boolean> defaultSupplier, Predicate<Boolean> validator) {
        return this.defineBoolean(path, defaultSupplier, null, validator);
    }

    public BooleanValue defineBoolean(String path, Supplier<Boolean> defaultSupplier, String comment, Predicate<Boolean> validator) {
        return this.defineBoolean(ModConfigSpecBuilder.splitPath(path), defaultSupplier, comment, validator);
    }

    public BooleanValue defineBoolean(List<String> path, Supplier<Boolean> defaultSupplier, String comment, Predicate<Boolean> validator) {
        this.lastPath = path;
        BooleanValue value = new BooleanValue(path, defaultSupplier, comment, validator);
        this.values.put(path, value);
        this.comments.put(path, comment);
        return value;
    }

    public <T extends Enum<T>> EnumValue<T> defineEnum(String path, Class<T> enumClass, Supplier<T> defaultSupplier) {
        return this.defineEnum(path, enumClass, defaultSupplier, null);
    }

    public <T extends Enum<T>> EnumValue<T> defineEnum(List<String> path, Class<T> enumClass, Supplier<T> defaultSupplier) {
        return this.defineEnum(path, enumClass, defaultSupplier, null);
    }

    public <T extends Enum<T>> EnumValue<T> defineEnum(String path, Class<T> enumClass, Supplier<T> defaultSupplier, String comment) {
        return this.defineEnum(ModConfigSpecBuilder.splitPath(path), enumClass, defaultSupplier, comment);
    }

    public <T extends Enum<T>> EnumValue<T> defineEnum(List<String> path, Class<T> enumClass, Supplier<T> defaultSupplier, String comment) {
        this.lastPath = path;
        EnumValue<T> value = new EnumValue<T>(path, defaultSupplier, enumClass, comment);
        this.values.put(path, value);
        this.comments.put(path, comment);
        return value;
    }

    public FloatValue defineFloat(String path, Supplier<Float> defaultSupplier) {
        return this.defineFloat(path, defaultSupplier, null, (Float v) -> true);
    }

    public FloatValue defineFloat(List<String> path, Supplier<Float> defaultSupplier) {
        return this.defineFloat(path, defaultSupplier, null, (Float v) -> true);
    }

    public FloatValue defineFloat(String path, Supplier<Float> defaultSupplier, String comment) {
        return this.defineFloat(path, defaultSupplier, comment, (Float v) -> true);
    }

    public FloatValue defineFloat(List<String> path, Supplier<Float> defaultSupplier, String comment) {
        return this.defineFloat(path, defaultSupplier, comment, (Float v) -> true);
    }

    public FloatValue defineFloat(String path, Supplier<Float> defaultSupplier, Predicate<Float> validator) {
        return this.defineFloat(path, defaultSupplier, null, validator);
    }

    public FloatValue defineFloat(List<String> path, Supplier<Float> defaultSupplier, Predicate<Float> validator) {
        return this.defineFloat(path, defaultSupplier, null, validator);
    }

    public FloatValue defineFloat(String path, Supplier<Float> defaultSupplier, String comment, Predicate<Float> validator) {
        return this.defineFloat(ModConfigSpecBuilder.splitPath(path), defaultSupplier, comment, validator);
    }

    public FloatValue defineFloat(List<String> path, Supplier<Float> defaultSupplier, String comment, Predicate<Float> validator) {
        this.lastPath = path;
        FloatValue value = new FloatValue(path, defaultSupplier, comment, validator);
        this.values.put(path, value);
        this.comments.put(path, comment);
        return value;
    }

    public IntValue defineInt(String path, Supplier<Integer> defaultSupplier) {
        return this.defineInt(path, defaultSupplier, null, (Integer v) -> true);
    }

    public IntValue defineInt(List<String> path, Supplier<Integer> defaultSupplier) {
        return this.defineInt(path, defaultSupplier, null, (Integer v) -> true);
    }

    public IntValue defineInt(String path, Supplier<Integer> defaultSupplier, String comment) {
        return this.defineInt(path, defaultSupplier, comment, (Integer v) -> true);
    }

    public IntValue defineInt(List<String> path, Supplier<Integer> defaultSupplier, String comment) {
        return this.defineInt(path, defaultSupplier, comment, (Integer v) -> true);
    }

    public IntValue defineInt(String path, Supplier<Integer> defaultSupplier, Predicate<Integer> validator) {
        return this.defineInt(path, defaultSupplier, null, validator);
    }

    public IntValue defineInt(List<String> path, Supplier<Integer> defaultSupplier, Predicate<Integer> validator) {
        return this.defineInt(path, defaultSupplier, null, validator);
    }

    public IntValue defineInt(String path, Supplier<Integer> defaultSupplier, String comment, Predicate<Integer> validator) {
        return this.defineInt(ModConfigSpecBuilder.splitPath(path), defaultSupplier, comment, validator);
    }

    public IntValue defineInt(List<String> path, Supplier<Integer> defaultSupplier, String comment, Predicate<Integer> validator) {
        this.lastPath = path;
        IntValue value = new IntValue(path, defaultSupplier, comment, validator);
        this.values.put(path, value);
        this.comments.put(path, comment);
        return value;
    }

    public LongValue defineLong(String path, Supplier<Long> defaultSupplier) {
        return this.defineLong(path, defaultSupplier, null, (Long v) -> true);
    }

    public LongValue defineLong(List<String> path, Supplier<Long> defaultSupplier) {
        return this.defineLong(path, defaultSupplier, null, (Long v) -> true);
    }

    public LongValue defineLong(String path, Supplier<Long> defaultSupplier, String comment) {
        return this.defineLong(path, defaultSupplier, comment, (Long v) -> true);
    }

    public LongValue defineLong(List<String> path, Supplier<Long> defaultSupplier, String comment) {
        return this.defineLong(path, defaultSupplier, comment, (Long v) -> true);
    }

    public LongValue defineLong(String path, Supplier<Long> defaultSupplier, Predicate<Long> validator) {
        return this.defineLong(path, defaultSupplier, null, validator);
    }

    public LongValue defineLong(List<String> path, Supplier<Long> defaultSupplier, Predicate<Long> validator) {
        return this.defineLong(path, defaultSupplier, null, validator);
    }

    public LongValue defineLong(String path, Supplier<Long> defaultSupplier, String comment, Predicate<Long> validator) {
        return this.defineLong(ModConfigSpecBuilder.splitPath(path), defaultSupplier, comment, validator);
    }

    public LongValue defineLong(List<String> path, Supplier<Long> defaultSupplier, String comment, Predicate<Long> validator) {
        this.lastPath = path;
        LongValue value = new LongValue(path, defaultSupplier, comment, validator);
        this.values.put(path, value);
        this.comments.put(path, comment);
        return value;
    }

    public StringValue defineString(String path, Supplier<String> defaultSupplier) {
        return this.defineString(path, defaultSupplier, null, (String v) -> true);
    }

    public StringValue defineString(List<String> path, Supplier<String> defaultSupplier) {
        return this.defineString(path, defaultSupplier, null, (String v) -> true);
    }

    public StringValue defineString(String path, Supplier<String> defaultSupplier, String comment) {
        return this.defineString(path, defaultSupplier, comment, (String v) -> true);
    }

    public StringValue defineString(List<String> path, Supplier<String> defaultSupplier, String comment) {
        return this.defineString(path, defaultSupplier, comment, (String v) -> true);
    }

    public StringValue defineString(String path, Supplier<String> defaultSupplier, Predicate<String> validator) {
        return this.defineString(path, defaultSupplier, null, validator);
    }

    public StringValue defineString(List<String> path, Supplier<String> defaultSupplier, Predicate<String> validator) {
        return this.defineString(path, defaultSupplier, null, validator);
    }

    public StringValue defineString(String path, Supplier<String> defaultSupplier, String comment, Predicate<String> validator) {
        return this.defineString(ModConfigSpecBuilder.splitPath(path), defaultSupplier, comment, validator);
    }

    public StringValue defineString(List<String> path, Supplier<String> defaultSupplier, String comment, Predicate<String> validator) {
        this.lastPath = path;
        StringValue value = new StringValue(path, defaultSupplier, comment, validator);
        this.values.put(path, value);
        this.comments.put(path, comment);
        return value;
    }

    public DoubleValue defineDouble(String path, Supplier<Double> defaultSupplier) {
        return this.defineDouble(path, defaultSupplier, null, (Double v) -> true);
    }

    public DoubleValue defineDouble(List<String> path, Supplier<Double> defaultSupplier) {
        return this.defineDouble(path, defaultSupplier, null, (Double v) -> true);
    }

    public DoubleValue defineDouble(String path, Supplier<Double> defaultSupplier, String comment) {
        return this.defineDouble(path, defaultSupplier, comment, (Double v) -> true);
    }

    public DoubleValue defineDouble(List<String> path, Supplier<Double> defaultSupplier, String comment) {
        return this.defineDouble(path, defaultSupplier, comment, (Double v) -> true);
    }

    public DoubleValue defineDouble(String path, Supplier<Double> defaultSupplier, Predicate<Double> validator) {
        return this.defineDouble(path, defaultSupplier, null, validator);
    }

    public DoubleValue defineDouble(List<String> path, Supplier<Double> defaultSupplier, Predicate<Double> validator) {
        return this.defineDouble(path, defaultSupplier, null, validator);
    }

    public DoubleValue defineDouble(String path, Supplier<Double> defaultSupplier, String comment, Predicate<Double> validator) {
        return this.defineDouble(ModConfigSpecBuilder.splitPath(path), defaultSupplier, comment, validator);
    }

    public DoubleValue defineDouble(List<String> path, Supplier<Double> defaultSupplier, String comment, Predicate<Double> validator) {
        this.lastPath = path;
        DoubleValue value = new DoubleValue(path, defaultSupplier, comment, validator);
        this.values.put(path, value);
        this.comments.put(path, comment);
        return value;
    }

    public <E> ListValue<E> defineList(String path, Supplier<List<E>> defaultSupplier) {
        return this.defineList(path, defaultSupplier, null, (Object obj) -> obj, (E v) -> true);
    }

    public <E> ListValue<E> defineList(List<String> path, Supplier<List<E>> defaultSupplier) {
        return this.defineList(path, defaultSupplier, null, (Object obj) -> obj, (E v) -> true);
    }

    public <E> ListValue<E> defineList(String path, Supplier<List<E>> defaultSupplier, String comment) {
        return this.defineList(path, defaultSupplier, comment, (Object obj) -> obj, (E v) -> true);
    }

    public <E> ListValue<E> defineList(List<String> path, Supplier<List<E>> defaultSupplier, String comment) {
        return this.defineList(path, defaultSupplier, comment, (Object obj) -> obj, (E v) -> true);
    }

    public <E> ListValue<E> defineList(String path, Supplier<List<E>> defaultSupplier, Function<Object, E> elementConverter, Predicate<E> elementValidator) {
        return this.defineList(path, defaultSupplier, null, elementConverter, elementValidator);
    }

    public <E> ListValue<E> defineList(List<String> path, Supplier<List<E>> defaultSupplier, Function<Object, E> elementConverter, Predicate<E> elementValidator) {
        return this.defineList(path, defaultSupplier, null, elementConverter, elementValidator);
    }

    public <E> ListValue<E> defineList(String path, Supplier<List<E>> defaultSupplier, String comment, Function<Object, E> elementConverter, Predicate<E> elementValidator) {
        return this.defineList(ModConfigSpecBuilder.splitPath(path), defaultSupplier, comment, elementConverter, elementValidator);
    }

    public <E> ListValue<E> defineList(List<String> path, Supplier<List<E>> defaultSupplier, String comment, Function<Object, E> elementConverter, Predicate<E> elementValidator) {
        this.lastPath = path;
        ListValue<E> value = new ListValue<E>(path, defaultSupplier, comment, elementConverter, elementValidator);
        this.values.put(path, value);
        this.comments.put(path, comment);
        return value;
    }

    public BooleanListValue defineBooleanList(String path, Supplier<List<Boolean>> defaultSupplier) {
        return this.defineBooleanList(path, defaultSupplier, null, (Boolean v) -> true);
    }

    public BooleanListValue defineBooleanList(List<String> path, Supplier<List<Boolean>> defaultSupplier) {
        return this.defineBooleanList(path, defaultSupplier, null, (Boolean v) -> true);
    }

    public BooleanListValue defineBooleanList(String path, Supplier<List<Boolean>> defaultSupplier, String comment) {
        return this.defineBooleanList(path, defaultSupplier, comment, (Boolean v) -> true);
    }

    public BooleanListValue defineBooleanList(List<String> path, Supplier<List<Boolean>> defaultSupplier, String comment) {
        return this.defineBooleanList(path, defaultSupplier, comment, (Boolean v) -> true);
    }

    public BooleanListValue defineBooleanList(String path, Supplier<List<Boolean>> defaultSupplier, Predicate<Boolean> elementValidator) {
        return this.defineBooleanList(path, defaultSupplier, null, elementValidator);
    }

    public BooleanListValue defineBooleanList(List<String> path, Supplier<List<Boolean>> defaultSupplier, Predicate<Boolean> elementValidator) {
        return this.defineBooleanList(path, defaultSupplier, null, elementValidator);
    }

    public BooleanListValue defineBooleanList(String path, Supplier<List<Boolean>> defaultSupplier, String comment, Predicate<Boolean> elementValidator) {
        return this.defineBooleanList(ModConfigSpecBuilder.splitPath(path), defaultSupplier, comment, elementValidator);
    }

    public BooleanListValue defineBooleanList(List<String> path, Supplier<List<Boolean>> defaultSupplier, String comment, Predicate<Boolean> elementValidator) {
        this.lastPath = path;
        BooleanListValue value = new BooleanListValue(path, defaultSupplier, comment, elementValidator);
        this.values.put(path, value);
        this.comments.put(path, comment);
        return value;
    }

    public DoubleListValue defineDoubleList(String path, Supplier<List<Double>> defaultSupplier) {
        return this.defineDoubleList(path, defaultSupplier, null, (Double v) -> true);
    }

    public DoubleListValue defineDoubleList(List<String> path, Supplier<List<Double>> defaultSupplier) {
        return this.defineDoubleList(path, defaultSupplier, null, (Double v) -> true);
    }

    public DoubleListValue defineDoubleList(String path, Supplier<List<Double>> defaultSupplier, String comment) {
        return this.defineDoubleList(path, defaultSupplier, comment, (Double v) -> true);
    }

    public DoubleListValue defineDoubleList(List<String> path, Supplier<List<Double>> defaultSupplier, String comment) {
        return this.defineDoubleList(path, defaultSupplier, comment, (Double v) -> true);
    }

    public DoubleListValue defineDoubleList(String path, Supplier<List<Double>> defaultSupplier, Predicate<Double> elementValidator) {
        return this.defineDoubleList(path, defaultSupplier, null, elementValidator);
    }

    public DoubleListValue defineDoubleList(List<String> path, Supplier<List<Double>> defaultSupplier, Predicate<Double> elementValidator) {
        return this.defineDoubleList(path, defaultSupplier, null, elementValidator);
    }

    public DoubleListValue defineDoubleList(String path, Supplier<List<Double>> defaultSupplier, String comment, Predicate<Double> elementValidator) {
        return this.defineDoubleList(ModConfigSpecBuilder.splitPath(path), defaultSupplier, comment, elementValidator);
    }

    public DoubleListValue defineDoubleList(List<String> path, Supplier<List<Double>> defaultSupplier, String comment, Predicate<Double> elementValidator) {
        this.lastPath = path;
        DoubleListValue value = new DoubleListValue(path, defaultSupplier, comment, elementValidator);
        this.values.put(path, value);
        this.comments.put(path, comment);
        return value;
    }

    public FloatListValue defineFloatList(String path, Supplier<List<Float>> defaultSupplier) {
        return this.defineFloatList(path, defaultSupplier, null, (Float v) -> true);
    }

    public FloatListValue defineFloatList(List<String> path, Supplier<List<Float>> defaultSupplier) {
        return this.defineFloatList(path, defaultSupplier, null, (Float v) -> true);
    }

    public FloatListValue defineFloatList(String path, Supplier<List<Float>> defaultSupplier, String comment) {
        return this.defineFloatList(path, defaultSupplier, comment, (Float v) -> true);
    }

    public FloatListValue defineFloatList(List<String> path, Supplier<List<Float>> defaultSupplier, String comment) {
        return this.defineFloatList(path, defaultSupplier, comment, (Float v) -> true);
    }

    public FloatListValue defineFloatList(String path, Supplier<List<Float>> defaultSupplier, Predicate<Float> elementValidator) {
        return this.defineFloatList(path, defaultSupplier, null, elementValidator);
    }

    public FloatListValue defineFloatList(List<String> path, Supplier<List<Float>> defaultSupplier, Predicate<Float> elementValidator) {
        return this.defineFloatList(path, defaultSupplier, null, elementValidator);
    }

    public FloatListValue defineFloatList(String path, Supplier<List<Float>> defaultSupplier, String comment, Predicate<Float> elementValidator) {
        return this.defineFloatList(ModConfigSpecBuilder.splitPath(path), defaultSupplier, comment, elementValidator);
    }

    public FloatListValue defineFloatList(List<String> path, Supplier<List<Float>> defaultSupplier, String comment, Predicate<Float> elementValidator) {
        this.lastPath = path;
        FloatListValue value = new FloatListValue(path, defaultSupplier, comment, elementValidator);
        this.values.put(path, value);
        this.comments.put(path, comment);
        return value;
    }

    public IntListValue defineIntList(String path, Supplier<List<Integer>> defaultSupplier) {
        return this.defineIntList(path, defaultSupplier, null, (Integer v) -> true);
    }

    public IntListValue defineIntList(List<String> path, Supplier<List<Integer>> defaultSupplier) {
        return this.defineIntList(path, defaultSupplier, null, (Integer v) -> true);
    }

    public IntListValue defineIntList(String path, Supplier<List<Integer>> defaultSupplier, String comment) {
        return this.defineIntList(path, defaultSupplier, comment, (Integer v) -> true);
    }

    public IntListValue defineIntList(List<String> path, Supplier<List<Integer>> defaultSupplier, String comment) {
        return this.defineIntList(path, defaultSupplier, comment, (Integer v) -> true);
    }

    public IntListValue defineIntList(String path, Supplier<List<Integer>> defaultSupplier, Predicate<Integer> elementValidator) {
        return this.defineIntList(path, defaultSupplier, null, elementValidator);
    }

    public IntListValue defineIntList(List<String> path, Supplier<List<Integer>> defaultSupplier, Predicate<Integer> elementValidator) {
        return this.defineIntList(path, defaultSupplier, null, elementValidator);
    }

    public IntListValue defineIntList(String path, Supplier<List<Integer>> defaultSupplier, String comment, Predicate<Integer> elementValidator) {
        return this.defineIntList(ModConfigSpecBuilder.splitPath(path), defaultSupplier, comment, elementValidator);
    }

    public IntListValue defineIntList(List<String> path, Supplier<List<Integer>> defaultSupplier, String comment, Predicate<Integer> elementValidator) {
        this.lastPath = path;
        IntListValue value = new IntListValue(path, defaultSupplier, comment, elementValidator);
        this.values.put(path, value);
        this.comments.put(path, comment);
        return value;
    }

    public LongListValue defineLongList(String path, Supplier<List<Long>> defaultSupplier) {
        return this.defineLongList(path, defaultSupplier, null, (Long v) -> true);
    }

    public LongListValue defineLongList(List<String> path, Supplier<List<Long>> defaultSupplier) {
        return this.defineLongList(path, defaultSupplier, null, (Long v) -> true);
    }

    public LongListValue defineLongList(String path, Supplier<List<Long>> defaultSupplier, String comment) {
        return this.defineLongList(path, defaultSupplier, comment, (Long v) -> true);
    }

    public LongListValue defineLongList(List<String> path, Supplier<List<Long>> defaultSupplier, String comment) {
        return this.defineLongList(path, defaultSupplier, comment, (Long v) -> true);
    }

    public LongListValue defineLongList(String path, Supplier<List<Long>> defaultSupplier, Predicate<Long> elementValidator) {
        return this.defineLongList(path, defaultSupplier, null, elementValidator);
    }

    public LongListValue defineLongList(List<String> path, Supplier<List<Long>> defaultSupplier, Predicate<Long> elementValidator) {
        return this.defineLongList(path, defaultSupplier, null, elementValidator);
    }

    public LongListValue defineLongList(String path, Supplier<List<Long>> defaultSupplier, String comment, Predicate<Long> elementValidator) {
        return this.defineLongList(ModConfigSpecBuilder.splitPath(path), defaultSupplier, comment, elementValidator);
    }

    public LongListValue defineLongList(List<String> path, Supplier<List<Long>> defaultSupplier, String comment, Predicate<Long> elementValidator) {
        this.lastPath = path;
        LongListValue value = new LongListValue(path, defaultSupplier, comment, elementValidator);
        this.values.put(path, value);
        this.comments.put(path, comment);
        return value;
    }

    public StringListValue defineStringList(String path, Supplier<List<String>> defaultSupplier) {
        return this.defineStringList(path, defaultSupplier, null, (String v) -> true);
    }

    public StringListValue defineStringList(List<String> path, Supplier<List<String>> defaultSupplier) {
        return this.defineStringList(path, defaultSupplier, null, (String v) -> true);
    }

    public StringListValue defineStringList(String path, Supplier<List<String>> defaultSupplier, String comment) {
        return this.defineStringList(path, defaultSupplier, comment, (String v) -> true);
    }

    public StringListValue defineStringList(List<String> path, Supplier<List<String>> defaultSupplier, String comment) {
        return this.defineStringList(path, defaultSupplier, comment, (String v) -> true);
    }

    public StringListValue defineStringList(String path, Supplier<List<String>> defaultSupplier, Predicate<String> elementValidator) {
        return this.defineStringList(path, defaultSupplier, null, elementValidator);
    }

    public StringListValue defineStringList(List<String> path, Supplier<List<String>> defaultSupplier, Predicate<String> elementValidator) {
        return this.defineStringList(path, defaultSupplier, null, elementValidator);
    }

    public StringListValue defineStringList(String path, Supplier<List<String>> defaultSupplier, String comment, Predicate<String> elementValidator) {
        return this.defineStringList(ModConfigSpecBuilder.splitPath(path), defaultSupplier, comment, elementValidator);
    }

    public StringListValue defineStringList(List<String> path, Supplier<List<String>> defaultSupplier, String comment, Predicate<String> elementValidator) {
        this.lastPath = path;
        StringListValue value = new StringListValue(path, defaultSupplier, comment, elementValidator);
        this.values.put(path, value);
        this.comments.put(path, comment);
        return value;
    }

    public <T extends Enum<T>> EnumListValue<T> defineEnumList(String path, Class<T> enumClass, Supplier<List<T>> defaultSupplier) {
        return this.defineEnumList(path, enumClass, defaultSupplier, null, (T v) -> true);
    }

    public <T extends Enum<T>> EnumListValue<T> defineEnumList(List<String> path, Class<T> enumClass, Supplier<List<T>> defaultSupplier) {
        return this.defineEnumList(path, enumClass, defaultSupplier, null, (T v) -> true);
    }

    public <T extends Enum<T>> EnumListValue<T> defineEnumList(String path, Class<T> enumClass, Supplier<List<T>> defaultSupplier, String comment) {
        return this.defineEnumList(path, enumClass, defaultSupplier, comment, (T v) -> true);
    }

    public <T extends Enum<T>> EnumListValue<T> defineEnumList(List<String> path, Class<T> enumClass, Supplier<List<T>> defaultSupplier, String comment) {
        return this.defineEnumList(path, enumClass, defaultSupplier, comment, (T v) -> true);
    }

    public <T extends Enum<T>> EnumListValue<T> defineEnumList(String path, Class<T> enumClass, Supplier<List<T>> defaultSupplier, Predicate<T> elementValidator) {
        return this.defineEnumList(path, enumClass, defaultSupplier, null, elementValidator);
    }

    public <T extends Enum<T>> EnumListValue<T> defineEnumList(List<String> path, Class<T> enumClass, Supplier<List<T>> defaultSupplier, Predicate<T> elementValidator) {
        return this.defineEnumList(path, enumClass, defaultSupplier, null, elementValidator);
    }

    public <T extends Enum<T>> EnumListValue<T> defineEnumList(String path, Class<T> enumClass, Supplier<List<T>> defaultSupplier, String comment, Predicate<T> elementValidator) {
        return this.defineEnumList(ModConfigSpecBuilder.splitPath(path), enumClass, defaultSupplier, comment, elementValidator);
    }

    public <T extends Enum<T>> EnumListValue<T> defineEnumList(List<String> path, Class<T> enumClass, Supplier<List<T>> defaultSupplier, String comment, Predicate<T> elementValidator) {
        this.lastPath = path;
        EnumListValue<T> value = new EnumListValue<T>(path, enumClass, defaultSupplier, comment, elementValidator);
        this.values.put(path, value);
        this.comments.put(path, comment);
        return value;
    }

    public ModConfigSpec build() {
        if (this.configPath == null) {
            throw new IllegalStateException("Config path must be set before building");
        }
        ModConfigSpec spec = new ModConfigSpec(this, this.configPath);
        spec.configValues.putAll(this.values);
        spec.comments.putAll(this.comments);
        this.values.values().forEach(values -> {
            values.configSpec = spec;
        });
        spec.fillSpec();
        try {
            spec.load();
        }
        catch (ParsingException e) {
            System.err.println("Failed to parse config file: " + e.getMessage());
            spec.initializeDefaultValues();
            spec.save();
        }
        return spec;
    }
}

