/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.api.config.values.single;

import com.electronwill.nightconfig.core.ConfigSpec;
import io.homo.superresolution.api.config.ConfigValue;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class FloatValue
extends ConfigValue<Float> {
    private final Predicate<Float> validator = obj -> obj != null && validator.test((Float)obj);

    public FloatValue(List<String> path, Supplier<Float> defaultSupplier, String comment, Predicate<Float> validator) {
        super(path, defaultSupplier, comment);
    }

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Number) {
            return this.validator.test(Float.valueOf(((Number)value).floatValue()));
        }
        return false;
    }

    @Override
    protected void fillSpec(ConfigSpec spec) {
        spec.define(this.path, this.defaultSupplier, obj -> this.validator.test(this.convertType(obj)));
    }

    @Override
    protected Float convertType(Object value) {
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Double) {
            return Float.valueOf(((Double)value).floatValue());
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            return Float.valueOf(Float.parseFloat((String)value));
        }
        return null;
    }
}

