/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.api.config.values.single;

import com.electronwill.nightconfig.core.ConfigSpec;
import io.homo.superresolution.api.config.ConfigValue;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class IntValue
extends ConfigValue<Integer> {
    private final Predicate<Integer> validator = obj -> obj != null && validator.test((Integer)obj);

    public IntValue(List<String> path, Supplier<Integer> defaultSupplier, String comment, Predicate<Integer> validator) {
        super(path, defaultSupplier, comment);
    }

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Number) {
            return this.validator.test(((Number)value).intValue());
        }
        return false;
    }

    @Override
    protected void fillSpec(ConfigSpec spec) {
        spec.define(this.path, this.defaultSupplier, obj -> this.validator.test(this.convertType(obj)));
    }

    @Override
    protected Integer convertType(Object value) {
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        return null;
    }
}

