/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.config.special;

import io.homo.superresolution.common.config.ConfigSpecType;
import it.unimi.dsi.fastutil.Pair;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;

public class SpecialConfigDescription<T> {
    protected String key;
    protected ConfigSpecType type;
    protected T value;
    protected T defaultValue;
    protected Function<T, Optional<class_2561>> valueName = a -> Optional.of(class_2561.method_43473());
    protected Function<T, Optional<class_2561>> name = a -> Optional.of(class_2561.method_43473());
    protected Function<T, Optional<class_2561>> tooltipSupplier = a -> Optional.empty();
    protected Class<? extends Enum<?>> clazz = null;
    protected Pair<Float, Float> valueRange = null;
    protected Consumer<T> saveConsumer;
    protected boolean valueNameIsSupplier = false;

    public static <T> SpecialConfigDescription<T> of(String key, ConfigSpecType type, T defaultValue) {
        return new SpecialConfigDescription<T>().setKey(key).setType(type).setDefaultValue(defaultValue).setValue(defaultValue);
    }

    public boolean isValueNameIsSupplier() {
        return this.valueNameIsSupplier;
    }

    public Consumer<T> getSaveConsumer() {
        return this.saveConsumer;
    }

    public SpecialConfigDescription<T> setSaveConsumer(Consumer<T> saveConsumer) {
        this.saveConsumer = saveConsumer;
        return this;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public SpecialConfigDescription<T> setDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public Optional<class_2561> getTooltip() {
        return this.tooltipSupplier.apply(this.getValue());
    }

    public SpecialConfigDescription<T> setTooltip(Function<T, Optional<class_2561>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    public SpecialConfigDescription<T> setTooltip(class_2561 tooltip) {
        this.tooltipSupplier = a -> Optional.ofNullable(tooltip);
        return this;
    }

    public SpecialConfigDescription<T> setName(Function<T, Optional<class_2561>> name) {
        this.name = name;
        return this;
    }

    public SpecialConfigDescription<T> setName(class_2561 name) {
        this.name = a -> Optional.of(name);
        return this;
    }

    public Pair<Float, Float> getValueRange() {
        return this.valueRange;
    }

    public SpecialConfigDescription<T> setValueRange(Pair<Float, Float> valueRange) {
        this.valueRange = valueRange;
        return this;
    }

    public Class<? extends Enum<?>> getClazz() {
        return this.clazz;
    }

    public SpecialConfigDescription<T> setClazz(Class<? extends Enum<?>> clazz) {
        this.clazz = clazz;
        return this;
    }

    public class_2561 getName() {
        return this.name.apply(this.getValue()).orElse((class_2561)class_2561.method_43473());
    }

    public class_2561 getValueName() {
        return this.valueName.apply(this.getValue()).orElse((class_2561)class_2561.method_43473());
    }

    public SpecialConfigDescription<T> setValueName(class_2561 valueName) {
        this.valueNameIsSupplier = false;
        this.valueName = a -> Optional.of(valueName);
        return this;
    }

    public SpecialConfigDescription<T> setValueNameSupplier(Function<T, Optional<class_2561>> valueNameSupplier) {
        this.valueNameIsSupplier = true;
        this.valueName = valueNameSupplier;
        return this;
    }

    public Function<T, Optional<class_2561>> getValueNameSupplier() {
        return this.valueName;
    }

    public Function<Object, Optional<class_2561>> getValueNameSupplierAsObject() {
        return this.valueName;
    }

    public Consumer<Object> getSaveConsumerAsObject() {
        return this.saveConsumer;
    }

    public String getKey() {
        return this.key;
    }

    public SpecialConfigDescription<T> setKey(String key) {
        this.key = key;
        return this;
    }

    public ConfigSpecType getType() {
        return this.type;
    }

    public SpecialConfigDescription<T> setType(ConfigSpecType type) {
        this.type = type;
        return this;
    }

    public T getValue() {
        return this.value;
    }

    public SpecialConfigDescription<T> setValue(T value) {
        this.value = value;
        return this;
    }
}

