/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.gui.entries;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.AbstractConfigScreen;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClothTextListEntry
extends TooltipListEntry<Object> {
    public static final int LINE_HEIGHT = 12;
    public static final int DISABLED_COLOR = Objects.requireNonNull(class_124.field_1063.method_532());
    protected final class_327 textRenderer;
    protected final int color;
    protected final Supplier<class_2561> textSupplier;
    protected int savedWidth;
    protected int savedX;
    protected int savedY;
    protected List<class_5481> wrappedLines;

    public ClothTextListEntry(class_2561 fieldName, Supplier<class_2561> textSupplier, int color, Supplier<Optional<class_2561[]>> tooltipSupplier) {
        super(fieldName, tooltipSupplier);
        this.textRenderer = class_310.method_1551().field_1772;
        this.textSupplier = textSupplier;
        this.color = color;
        this.wrappedLines = Collections.emptyList();
    }

    public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        this.wrappedLines = this.textRenderer.method_1728((class_5348)this.textSupplier.get(), entryWidth);
        this.savedWidth = entryWidth;
        this.savedX = x;
        this.savedY = y;
        int yy = y + 7;
        int textColor = this.isEnabled() ? this.color : DISABLED_COLOR;
        for (class_5481 string : this.wrappedLines) {
            graphics.method_35720(class_310.method_1551().field_1772, string, x, yy, textColor);
            Objects.requireNonNull(class_310.method_1551().field_1772);
            yy += 12;
        }
        class_2583 style = this.getTextAt(mouseX, mouseY);
        AbstractConfigScreen configScreen = this.getConfigScreen();
        if (style != null && configScreen != null) {
            graphics.method_51441(class_310.method_1551().field_1772, style, mouseX, mouseY);
        }
    }

    public int getItemHeight() {
        int lineCount = this.wrappedLines.size();
        return lineCount == 0 ? 0 : 14 + lineCount * 12;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            class_2583 style = this.getTextAt(mouseX, mouseY);
            AbstractConfigScreen configScreen = this.getConfigScreen();
            if (configScreen != null && configScreen.method_25430(style)) {
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Nullable
    protected class_2583 getTextAt(double x, double y) {
        int lineCount = this.wrappedLines.size();
        if (lineCount > 0) {
            int line;
            int textX = class_3532.method_15357((double)(x - (double)this.savedX));
            int textY = class_3532.method_15357((double)(y - 7.0 - (double)this.savedY));
            if (textX >= 0 && textY >= 0 && textX <= this.savedWidth && textY < 12 * lineCount + lineCount && (line = textY / 12) < this.wrappedLines.size()) {
                class_5481 orderedText = this.wrappedLines.get(line);
                return this.textRenderer.method_27527().method_30876(orderedText, textX);
            }
        }
        return null;
    }

    public Object getValue() {
        return null;
    }

    public Optional<Object> getDefaultValue() {
        return Optional.empty();
    }

    @NotNull
    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }

    public List<? extends class_6379> narratables() {
        return Collections.emptyList();
    }
}

