/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.gui.screens;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.homo.superresolution.common.config.SuperResolutionConfig;
import io.homo.superresolution.common.gui.ConfigScreenBuilder;
import io.homo.superresolution.common.gui.Rectangle;
import io.homo.superresolution.common.gui.ScissorsHandler;
import io.homo.superresolution.common.gui.widgets.ClothListWidget;
import io.homo.superresolution.core.utils.ColorUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigScreen;
import me.shedaniel.clothconfig2.gui.AbstractConfigScreen;
import me.shedaniel.clothconfig2.gui.ClothConfigScreen;
import me.shedaniel.clothconfig2.gui.entries.EmptyEntry;
import me.shedaniel.clothconfig2.gui.widget.SearchFieldEntry;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_766;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClothStyleConfigScreen
extends AbstractConfigScreen {
    protected static final class_766 panorama = new class_766(class_442.field_49508);
    protected final LinkedHashMap<class_2561, List<AbstractConfigEntry<?>>> categorizedEntries = Maps.newLinkedHashMap();
    public ClothListWidget listWidget;
    protected class_4185 cancelButton;
    protected class_4185 exitButton;
    protected class_4185 saveButton;
    protected SearchFieldEntry searchFieldEntry;
    protected boolean enableSearch;
    protected double lastScroll = -1145.1145;

    public ClothStyleConfigScreen(class_437 parent, class_2561 title, Map<String, ConfigCategory> categoryMap, class_2960 backgroundLocation) {
        super(parent, title, backgroundLocation);
        categoryMap.forEach((categoryName, category) -> {
            ArrayList entries = Lists.newArrayList();
            for (Object object : category.getEntries()) {
                AbstractConfigListEntry entry = object instanceof class_3545 ? (AbstractConfigListEntry)((class_3545)object).method_15441() : (AbstractConfigListEntry)object;
                entry.setScreen((AbstractConfigScreen)this);
                entries.add(entry);
            }
            this.categorizedEntries.put(category.getCategoryKey(), entries);
        });
    }

    public void setEnableSearch(boolean enableSearch) {
        this.enableSearch = enableSearch;
    }

    public Map<class_2561, List<AbstractConfigEntry<?>>> getCategorizedEntries() {
        return this.categorizedEntries;
    }

    protected void method_25426() {
        super.method_25426();
        this.listWidget = new ClothListWidget(this, this.field_22787, this.field_22789, this.field_22790, 30, this.field_22790 - 32, this.getBackgroundLocation());
        this.method_25429((class_364)this.listWidget);
        if (this.enableSearch) {
            this.listWidget.method_25396().add(new EmptyEntry(5));
            this.searchFieldEntry = new SearchFieldEntry((ConfigScreen)this, (ClothConfigScreen.ListWidget)this.listWidget);
            this.listWidget.method_25396().add(this.searchFieldEntry);
            this.listWidget.method_25396().add(new EmptyEntry(5));
        }
        this.categorizedEntries.forEach((category, entries) -> {
            if (!this.listWidget.method_25396().isEmpty()) {
                this.listWidget.method_25396().add(new EmptyEntry(5));
            }
            this.listWidget.method_25396().add(new EmptyEntry(4));
            this.listWidget.method_25396().add(new CategoryTextEntry((class_2561)category, (class_2561)category.method_27661().method_27692(class_124.field_1067)));
            this.listWidget.method_25396().add(new EmptyEntry(4));
            this.listWidget.method_25396().addAll(entries);
        });
        int buttonWidths = Math.min(200, (this.field_22789 - 50 - 12) / 4);
        this.cancelButton = class_4185.method_46430((class_2561)(this.isEdited() ? class_2561.method_43471((String)"text.cloth-config.cancel_discard") : class_2561.method_43471((String)"gui.cancel")), widget -> this.quit()).method_46434(0, this.field_22790 - 26, buttonWidths, 20).method_46431();
        this.method_25429((class_364)this.cancelButton);
        this.exitButton = new class_4185(0, this.field_22790 - 26, buttonWidths, 20, (class_2561)class_2561.method_43473(), button -> this.saveAll(true), Supplier::get){

            public void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float delta) {
                boolean hasErrors = false;
                block0: for (List<AbstractConfigEntry<?>> entries : ClothStyleConfigScreen.this.categorizedEntries.values()) {
                    for (AbstractConfigEntry<?> entry : entries) {
                        if (!entry.getConfigError().isPresent()) continue;
                        hasErrors = true;
                        break block0;
                    }
                }
                this.field_22763 = ClothStyleConfigScreen.this.isEdited() && !hasErrors;
                this.method_25355((class_2561)(hasErrors ? class_2561.method_43471((String)"text.cloth-config.error_cannot_save") : class_2561.method_43471((String)"text.cloth-config.save_and_done")));
                super.method_48579(graphics, mouseX, mouseY, delta);
            }
        };
        this.method_25429((class_364)this.exitButton);
        this.saveButton = new class_4185(0, this.field_22790 - 26, buttonWidths, 20, (class_2561)class_2561.method_43471((String)"superresolution.screen.button.label.apply"), button -> {
            this.saveAll(false);
            double scroll = this.listWidget.getScroll();
            class_310.method_1551().method_1507(ConfigScreenBuilder.create().buildConfigScreen(this.parent));
            if (class_310.method_1551().field_1755 instanceof ClothStyleConfigScreen) {
                ((ClothStyleConfigScreen)class_310.method_1551().field_1755).lastScroll = scroll;
            }
        }, Supplier::get){

            public void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float delta) {
                boolean hasErrors = false;
                block0: for (List<AbstractConfigEntry<?>> entries : ClothStyleConfigScreen.this.categorizedEntries.values()) {
                    for (AbstractConfigEntry<?> entry : entries) {
                        if (!entry.getConfigError().isPresent()) continue;
                        hasErrors = true;
                        break block0;
                    }
                }
                this.field_22763 = ClothStyleConfigScreen.this.isEdited() && !hasErrors;
                this.method_25355((class_2561)(hasErrors ? class_2561.method_43471((String)"text.cloth-config.error_cannot_save") : class_2561.method_43471((String)"superresolution.screen.button.label.apply")));
                super.method_48579(graphics, mouseX, mouseY, delta);
            }
        };
        this.method_25429((class_364)this.saveButton);
        Optional.ofNullable(this.afterInitConsumer).ifPresent(consumer -> consumer.accept(this));
    }

    public boolean matchesSearch(Iterator<String> tags) {
        if (this.searchFieldEntry == null) {
            return true;
        }
        return this.searchFieldEntry.matchesSearch(tags);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (class_310.method_1551().field_1687 == null) {
            panorama.method_3317(graphics, this.field_22789, this.field_22790, 1.0f, delta);
        }
        graphics.method_25294(0, 0, this.field_22789, this.listWidget.top, ColorUtil.color(60, 0, 0, 0));
        graphics.method_25294(0, this.listWidget.bottom, this.field_22789, this.listWidget.height, ColorUtil.color(60, 0, 0, 0));
        if (this.lastScroll != -1145.1145) {
            this.listWidget.scrollTo(this.lastScroll, false);
            this.lastScroll = -1145.1145;
        }
        this.listWidget.width = this.field_22789;
        this.listWidget.method_25394(graphics, mouseX, mouseY, delta);
        this.saveButton.method_46421(this.field_22789 / 2 - this.saveButton.method_25368() / 2);
        this.cancelButton.method_46421(this.saveButton.method_46426() - 3 - this.saveButton.method_25368());
        this.exitButton.method_46421(this.saveButton.method_46426() + 3 + this.saveButton.method_25368());
        this.cancelButton.method_25394(graphics, mouseX, mouseY, delta);
        this.saveButton.method_25394(graphics, mouseX, mouseY, delta);
        this.exitButton.method_25394(graphics, mouseX, mouseY, delta);
        ScissorsHandler.scissor(new Rectangle(this.listWidget.left, this.listWidget.top, this.listWidget.width, this.listWidget.bottom - this.listWidget.top));
        for (AbstractConfigEntry child : this.listWidget.method_25396()) {
            child.lateRender(graphics, mouseX, mouseY, delta);
        }
        ScissorsHandler.removeLastScissor();
        graphics.method_35720(this.field_22793, this.field_22785.method_30937(), (int)((float)this.field_22789 / 2.0f - (float)this.field_22793.method_27525((class_5348)this.field_22785) / 2.0f), 12, -1);
        super.method_25394(graphics, mouseX, mouseY, delta);
    }

    public void method_25420(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean method_25421() {
        return SuperResolutionConfig.isPauseGameOnGui();
    }

    protected static class CategoryTextEntry
    extends AbstractConfigListEntry<Object> {
        private final class_2561 category;
        private final class_2561 text;

        public CategoryTextEntry(class_2561 category, class_2561 text) {
            super((class_2561)class_2561.method_43470((String)UUID.randomUUID().toString()), false);
            this.category = category;
            this.text = text;
        }

        public int getItemHeight() {
            List strings = class_310.method_1551().field_1772.method_1728((class_5348)this.text, this.getParent().getItemWidth());
            if (strings.isEmpty()) {
                return 0;
            }
            return 4 + strings.size() * 10;
        }

        @Nullable
        public class_8016 method_48205(class_8023 focusNavigationEvent) {
            return null;
        }

        public Object getValue() {
            return null;
        }

        public Optional<Object> getDefaultValue() {
            return Optional.empty();
        }

        public boolean isMouseInside(int mouseX, int mouseY, int x, int y, int entryWidth, int entryHeight) {
            return false;
        }

        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            super.render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
            int yy = y + 2;
            List texts = class_310.method_1551().field_1772.method_1728((class_5348)this.text, this.getParent().getItemWidth());
            for (class_5481 text : texts) {
                graphics.method_35720(class_310.method_1551().field_1772, text, x - 4 + entryWidth / 2 - class_310.method_1551().field_1772.method_30880(text) / 2, yy, -1);
                yy += 10;
            }
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }

        public List<? extends class_6379> narratables() {
            return Collections.emptyList();
        }

        public class_2561 getCategory() {
            return this.category;
        }
    }
}

