/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.gui.screens;

import io.homo.superresolution.common.gui.impl.Text;
import io.homo.superresolution.common.gui.options.OptionCategory;
import io.homo.superresolution.common.minecraft.MinecraftWindow;
import io.homo.superresolution.common.minecraft.handler.RenderHandlerManager;
import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.graphics.impl.framebuffer.IBindableFrameBuffer;
import io.homo.superresolution.core.graphics.impl.texture.TextureDescription;
import io.homo.superresolution.core.graphics.impl.texture.TextureFilterMode;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.impl.texture.TextureType;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsages;
import io.homo.superresolution.core.graphics.impl.texture.TextureWrapMode;
import io.homo.superresolution.core.graphics.opengl.Gl;
import io.homo.superresolution.core.graphics.opengl.framebuffer.GlFrameBuffer;
import io.homo.superresolution.core.gui.GUIAntiAliasingPostprocessing;
import io.homo.superresolution.core.gui.MaterialScheme;
import io.homo.superresolution.core.gui.NanoVGScreen;
import io.homo.superresolution.core.gui.core.ContainerWidget;
import io.homo.superresolution.core.gui.core.UIInputState;
import io.homo.superresolution.core.gui.core.backends.interfaces.IUIDrawContext;
import io.homo.superresolution.core.gui.core.backends.nanovg.NanoVGDrawContext;
import io.homo.superresolution.core.gui.widgets.MaterialScrollableContainerWidget;
import io.homo.superresolution.core.gui.widgets.button.MaterialButton;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2f;

public class MaterialStyleConfigScreen
extends NanoVGScreen<MaterialStyleConfigScreen> {
    protected List<OptionCategory> categories;
    protected OptionCategory currentCategory;
    protected MaterialScheme materialScheme = MaterialScheme.defaultDark;
    protected IBindableFrameBuffer uiFrameBuffer;
    protected GUIAntiAliasingPostprocessing antiAliasingPostprocessing;
    protected ContainerWidget mainContainer;
    protected MaterialScrollableContainerWidget optionsContainer;
    protected ContainerWidget actionContainer;
    protected ContainerWidget headerContainer;
    protected MaterialButton saveButton;
    protected MaterialButton saveAndExitButton;
    protected MaterialButton exitButton;
    protected MaterialButton resetButton;
    protected LayoutConstants constants = new LayoutConstants();
    protected class_437 parent;

    public class_437 getParent() {
        return this.parent;
    }

    public MaterialStyleConfigScreen setParent(class_437 parent) {
        this.parent = parent;
        return this;
    }

    public MaterialStyleConfigScreen(Text title, List<OptionCategory> categories) {
        super((class_2561)class_2561.method_43470((String)title.toString()));
        this.categories = categories;
        this.currentCategory = categories.get(0);
    }

    @Override
    protected void buildWidgets() {
    }

    @Override
    public void drawBefore(IUIDrawContext drawContext, UIInputState inputState) {
        super.drawBefore(drawContext, inputState);
        Vector2f screenSize = MinecraftWindow.getWindowSize();
        drawContext.beginBatch();
        drawContext.drawRect(0.0f, 0.0f, screenSize.x, screenSize.y, this.materialScheme.background(), true);
        this.drawHeaderBackground(drawContext, screenSize);
        this.drawActionsBackground(drawContext, screenSize);
        drawContext.endBatch(0);
    }

    private void drawHeaderBackground(IUIDrawContext drawContext, Vector2f screenSize) {
        drawContext.beginPath();
        drawContext.fillColor(this.materialScheme.surfaceContainer());
        drawContext.roundedRectComplex(0.0f, 0.0f, screenSize.x, this.constants.HEADER_HEIGHT, 24.0f, 24.0f, 0.0f, 0.0f);
        drawContext.endPath();
    }

    private void drawActionsBackground(IUIDrawContext drawContext, Vector2f screenSize) {
        drawContext.beginPath();
        drawContext.fillColor(this.materialScheme.surfaceContainer());
        drawContext.roundedRectComplex(0.0f, screenSize.y - this.constants.ACTIONS_HEIGHT, screenSize.x, this.constants.ACTIONS_HEIGHT, 0.0f, 0.0f, 24.0f, 24.0f);
        drawContext.endPath();
    }

    @Override
    public void method_25410(@NotNull class_310 minecraft, int width, int height) {
        this.initUIFrameBuffer();
    }

    protected void initUIFrameBuffer() {
        if (this.uiFrameBuffer != null) {
            this.uiFrameBuffer.getTexture(FrameBufferAttachmentType.Color).destroy();
            this.uiFrameBuffer.getTexture(FrameBufferAttachmentType.AnyDepth).destroy();
            this.uiFrameBuffer.destroy();
        }
        this.uiFrameBuffer = GlFrameBuffer.create(RenderSystems.current().device().createTexture(TextureDescription.create().type(TextureType.Texture2D).usages(TextureUsages.create().sampler().storage().attachmentColor()).filterMode(TextureFilterMode.Linear).wrapMode(TextureWrapMode.ClampToEdge).format(TextureFormat.R11G11B10F).size(MinecraftWindow.getWindowWidth(), MinecraftWindow.getWindowHeight()).build()), RenderSystems.current().device().createTexture(TextureDescription.create().type(TextureType.Texture2D).usages(TextureUsages.create().sampler().storage().attachmentColor()).filterMode(TextureFilterMode.Linear).wrapMode(TextureWrapMode.ClampToEdge).format(TextureFormat.DEPTH24_STENCIL8).size(MinecraftWindow.getWindowWidth(), MinecraftWindow.getWindowHeight()).build()));
    }

    @Override
    protected void method_25426() {
        this.initUIFrameBuffer();
        if (this.antiAliasingPostprocessing == null) {
            this.antiAliasingPostprocessing = new GUIAntiAliasingPostprocessing();
            this.antiAliasingPostprocessing.init();
        }
        this.antiAliasingPostprocessing.resize(RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight());
    }

    @Override
    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    @Override
    public void method_25394(@NotNull class_332 guiGraphics, int mouseX_, int mouseY_, float partialTick) {
        float mouseX = (float)(class_310.method_1551().method_22683().method_4495() * (double)mouseX_);
        float mouseY = (float)(class_310.method_1551().method_22683().method_4495() * (double)mouseY_);
        this.drawBefore(guiGraphics, (int)mouseX, (int)mouseY, partialTick);
        this.uiFrameBuffer.bind(FrameBufferBindPoint.Write);
        this.nvg.begin(this.transparent);
        this.nvg.resetGlobalTransform();
        this.nvg.resetTransform();
        this.nvg.globalAlpha(1.0f);
        NanoVGDrawContext drawContext = new NanoVGDrawContext(this.nvg);
        this.draw(drawContext, new UIInputState(new Vector2f(mouseX, mouseY), partialTick));
        drawContext.drawAll();
        this.nvg.end();
        this.uiFrameBuffer.unbind(FrameBufferBindPoint.Write);
        RenderHandlerManager.getOriginRenderTarget().bind(FrameBufferBindPoint.All);
        Gl.DSA.blitFramebuffer((int)this.uiFrameBuffer.handle(), (int)RenderHandlerManager.getOriginRenderTarget().handle(), 0, 0, RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight(), 0, 0, RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight(), 16384, 9729);
        this.drawAfter(guiGraphics, (int)mouseX, (int)mouseY, partialTick);
    }

    private static class LayoutConstants {
        public float ACTIONS_HEIGHT = 64.0f;
        public float HEADER_HEIGHT = 64.0f;
        public float PADDING = 72.0f;
        public float TOP_PADDING = 24.0f;
        public float BOTTOM_PADDING = 24.0f;
        public float OPTIONS_SCROLLBAR_WIDTH = 8.0f;
        public float OPTIONS_HORIZONTAL_PADDING = 6.0f;
        public float HEADER_BUTTON_GAP = 8.0f;

        private LayoutConstants() {
        }
    }
}

