/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.upscale.nis;

import io.homo.superresolution.common.upscale.DispatchResource;
import io.homo.superresolution.common.upscale.nis.enums.NISHDRMode;
import io.homo.superresolution.common.upscale.nis.struct.NISConfig;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.system.MemoryStack;

public class NVIDIAImageScalingConfig {
    public NISConfig config = new NISConfig();
    public ByteBuffer container = MemoryStack.stackCalloc((int)256);

    public boolean NVScalerUpdateConfig(float sharpness, int inputViewportOriginX, int inputViewportOriginY, int inputViewportWidth, int inputViewportHeight, int inputTextureWidth, int inputTextureHeight, int outputViewportOriginX, int outputViewportOriginY, int outputViewportWidth, int outputViewportHeight, int outputTextureWidth, int outputTextureHeight, NISHDRMode hdrMode) {
        float sharpenSlider = (sharpness = Math.max(Math.min(1.0f, sharpness), 0.0f)) - 0.5f;
        float maxScale = sharpenSlider >= 0.0f ? 1.25f : 1.75f;
        float minScale = sharpenSlider >= 0.0f ? 1.25f : 1.0f;
        float limitScale = sharpenSlider >= 0.0f ? 1.25f : 1.0f;
        float kDetectRatio = 2.2011719f;
        float kDetectThres = 0.0625f;
        float kMinContrastRatio = 2.0f;
        float kMaxContrastRatio = 10.0f;
        float kSharpStartY = 0.45f;
        float kSharpEndY = 0.9f;
        float kSharpStrengthMin = Math.max(0.0f, 0.4f + sharpenSlider * minScale * 1.2f);
        float kSharpStrengthMax = 1.6f + sharpenSlider * maxScale * 1.8f;
        float kSharpLimitMin = Math.max(0.1f, 0.14f + sharpenSlider * limitScale * 0.32f);
        float kSharpLimitMax = 0.5f + sharpenSlider * limitScale * 0.6f;
        if (hdrMode == NISHDRMode.Linear || hdrMode == NISHDRMode.PQ) {
            kDetectThres = 0.03125f;
            kMinContrastRatio = 1.5f;
            kMaxContrastRatio = 5.0f;
            kSharpStrengthMin = Math.max(0.0f, 0.4f + sharpenSlider * minScale * 1.1f);
            kSharpStrengthMax = 2.2f + sharpenSlider * maxScale * 1.8f;
            kSharpLimitMin = Math.max(0.06f, 0.1f + sharpenSlider * limitScale * 0.28f);
            kSharpLimitMax = 0.6f + sharpenSlider * limitScale * 0.6f;
            if (hdrMode == NISHDRMode.PQ) {
                kSharpStartY = 0.35f;
                kSharpEndY = 0.55f;
            } else {
                kSharpStartY = 0.3f;
                kSharpEndY = 0.5f;
            }
        }
        float kRatioNorm = 1.0f / (kMaxContrastRatio - kMinContrastRatio);
        float kSharpScaleY = 1.0f / (kSharpEndY - kSharpStartY);
        float kSharpStrengthScale = kSharpStrengthMax - kSharpStrengthMin;
        float kSharpLimitScale = kSharpLimitMax - kSharpLimitMin;
        this.config.kInputViewportWidth = inputViewportWidth == 0 ? inputTextureWidth : inputViewportWidth;
        this.config.kInputViewportHeight = inputViewportHeight == 0 ? inputTextureHeight : inputViewportHeight;
        this.config.kOutputViewportWidth = outputViewportWidth == 0 ? outputTextureWidth : outputViewportWidth;
        int n = this.config.kOutputViewportHeight = outputViewportHeight == 0 ? outputTextureHeight : outputViewportHeight;
        if (this.config.kInputViewportWidth == 0 || this.config.kInputViewportHeight == 0 || this.config.kOutputViewportWidth == 0 || this.config.kOutputViewportHeight == 0) {
            return false;
        }
        this.config.kInputViewportOriginX = inputViewportOriginX;
        this.config.kInputViewportOriginY = inputViewportOriginY;
        this.config.kOutputViewportOriginX = outputViewportOriginX;
        this.config.kOutputViewportOriginY = outputViewportOriginY;
        this.config.kSrcNormX = 1.0f / (float)inputTextureWidth;
        this.config.kSrcNormY = 1.0f / (float)inputTextureHeight;
        this.config.kDstNormX = 1.0f / (float)outputTextureWidth;
        this.config.kDstNormY = 1.0f / (float)outputTextureHeight;
        this.config.kScaleX = (float)this.config.kInputViewportWidth / (float)this.config.kOutputViewportWidth;
        this.config.kScaleY = (float)this.config.kInputViewportHeight / (float)this.config.kOutputViewportHeight;
        this.config.kDetectRatio = kDetectRatio;
        this.config.kDetectThres = kDetectThres;
        this.config.kMinContrastRatio = kMinContrastRatio;
        this.config.kRatioNorm = kRatioNorm;
        this.config.kContrastBoost = 1.0f;
        this.config.kEps = 0.003921569f;
        this.config.kSharpStartY = kSharpStartY;
        this.config.kSharpScaleY = kSharpScaleY;
        this.config.kSharpStrengthMin = kSharpStrengthMin;
        this.config.kSharpStrengthScale = kSharpStrengthScale;
        this.config.kSharpLimitMin = kSharpLimitMin;
        this.config.kSharpLimitScale = kSharpLimitScale;
        return !(this.config.kScaleX < 0.5f || this.config.kScaleX > 1.0f || this.config.kScaleY < 0.5f || this.config.kScaleY > 1.0f);
    }

    public boolean NVSharpenUpdateConfig(float sharpness, int inputViewportOriginX, int inputViewportOriginY, int inputViewportWidth, int inputViewportHeight, int inputTextureWidth, int inputTextureHeight, int outputViewportOriginX, int outputViewportOriginY, NISHDRMode hdrMode) {
        return this.NVScalerUpdateConfig(sharpness, inputViewportOriginX, inputViewportOriginY, inputViewportWidth, inputViewportHeight, inputTextureWidth, inputTextureHeight, outputViewportOriginX, outputViewportOriginY, inputViewportWidth, inputViewportHeight, inputTextureWidth, inputTextureHeight, hdrMode);
    }

    public void updateData(DispatchResource dispatchResource) {
        this.container.clear();
        this.container.order(ByteOrder.LITTLE_ENDIAN);
        this.container.putFloat(this.config.kDetectRatio);
        this.container.putFloat(this.config.kDetectThres);
        this.container.putFloat(this.config.kMinContrastRatio);
        this.container.putFloat(this.config.kRatioNorm);
        this.container.putFloat(this.config.kContrastBoost);
        this.container.putFloat(this.config.kEps);
        this.container.putFloat(this.config.kSharpStartY);
        this.container.putFloat(this.config.kSharpScaleY);
        this.container.putFloat(this.config.kSharpStrengthMin);
        this.container.putFloat(this.config.kSharpStrengthScale);
        this.container.putFloat(this.config.kSharpLimitMin);
        this.container.putFloat(this.config.kSharpLimitScale);
        this.container.putFloat(this.config.kScaleX);
        this.container.putFloat(this.config.kScaleY);
        this.container.putFloat(this.config.kDstNormX);
        this.container.putFloat(this.config.kDstNormY);
        this.container.putFloat(this.config.kSrcNormX);
        this.container.putFloat(this.config.kSrcNormY);
        this.container.putInt(this.config.kInputViewportOriginX);
        this.container.putInt(this.config.kInputViewportOriginY);
        this.container.putInt(this.config.kInputViewportWidth);
        this.container.putInt(this.config.kInputViewportHeight);
        this.container.putInt(this.config.kOutputViewportOriginX);
        this.container.putInt(this.config.kOutputViewportOriginY);
        this.container.putInt(this.config.kOutputViewportWidth);
        this.container.putInt(this.config.kOutputViewportHeight);
        this.container.putFloat(this.config.reserved0);
        this.container.putFloat(this.config.reserved1);
        for (int writtenBytes = 112; writtenBytes < 256; ++writtenBytes) {
            this.container.put((byte)0);
        }
        this.container.position(256);
        this.container.flip();
    }

    public ByteBuffer container() {
        return this.container;
    }

    public long size() {
        return 256L;
    }
}

