/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.upscale.sgsr.v2.variants;

import io.homo.superresolution.common.config.SuperResolutionConfig;
import io.homo.superresolution.common.minecraft.handler.RenderHandlerManager;
import io.homo.superresolution.common.upscale.DispatchResource;
import io.homo.superresolution.common.upscale.sgsr.v2.AbstractSgsrVariant;
import io.homo.superresolution.common.upscale.sgsr.v2.Sgsr2;
import io.homo.superresolution.common.upscale.sgsr.v2.SgsrUtils;
import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.graphics.impl.command.ICommandBuffer;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferTextureAdapter;
import io.homo.superresolution.core.graphics.impl.pipeline.Pipeline;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineJobBuilders;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineJobResource;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineResourceAccess;
import io.homo.superresolution.core.graphics.impl.shader.ShaderDescription;
import io.homo.superresolution.core.graphics.impl.shader.ShaderSource;
import io.homo.superresolution.core.graphics.impl.shader.ShaderType;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureDescription;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.impl.texture.TextureSupplier;
import io.homo.superresolution.core.graphics.impl.texture.TextureType;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsages;
import io.homo.superresolution.core.graphics.opengl.shader.GlShaderProgram;
import java.util.Optional;
import org.joml.Vector3i;

public class Sgsr2PassCompute
extends AbstractSgsrVariant {
    private GlShaderProgram convertShader;
    private GlShaderProgram upscaleShader;
    private Pipeline sgsrPipeline;
    private ITexture PrevLumaHistory;
    private ITexture YCoCgColor;
    private ITexture MotionDepthClipAlphaBuffer;
    private ITexture PrevHistoryOutput;
    private ITexture HistoryOutput;

    private Vector3i getWorkGroupSize() {
        int dispatchX = SgsrUtils.divideRoundUp(RenderHandlerManager.getScreenWidth(), 8);
        int dispatchY = SgsrUtils.divideRoundUp(RenderHandlerManager.getScreenHeight(), 8);
        return new Vector3i(dispatchX, dispatchY, 1);
    }

    @Override
    public void dispatch(DispatchResource resource, Sgsr2 sgsr) {
        this.swapHistoryOutput();
        RenderSystems.opengl().device().commandEncoder().begin();
        ICommandBuffer commandBuffer = RenderSystems.current().device().commandEncoder().getCommandBuffer();
        this.sgsrPipeline.executeJob(commandBuffer, "convert");
        this.sgsrPipeline.executeJob(commandBuffer, "upscale");
        RenderSystems.opengl().device().commandEncoder().end();
        RenderSystems.opengl().device().submitCommandBuffer(commandBuffer);
    }

    @Override
    public void init(Sgsr2 sgsr) {
        this.convertShader = RenderSystems.current().device().createShaderProgram(ShaderDescription.create().compute(new ShaderSource(ShaderType.Compute, "/shader/sgsr/2pass_cs/sgsr2_convert.comp.glsl", true)).name("SGSR_2PCS_A").addDefine("SR_INTERNAL_TEXTURE_FORMAT", SuperResolutionConfig.getInternalTextureFormatGlslFormatQualifier()).uniformBuffer("Params", 0, (int)sgsr.getParams().getSize()).uniformSamplerTexture("InputColor", 1).uniformSamplerTexture("InputDepth", 2).uniformSamplerTexture("InputVelocity", 3).uniformStorageTexture("MotionDepthClipAlphaBuffer", 0).uniformStorageTexture("YCoCgColor", 1).build());
        this.convertShader.compile();
        this.upscaleShader = RenderSystems.current().device().createShaderProgram(ShaderDescription.create().compute(new ShaderSource(ShaderType.Compute, "/shader/sgsr/2pass_cs/sgsr2_upscale.comp.glsl", true)).name("SGSR_2PCS_B").addDefine("SR_INTERNAL_TEXTURE_FORMAT", SuperResolutionConfig.getInternalTextureFormatGlslFormatQualifier()).uniformBuffer("Params", 0, (int)sgsr.getParams().getSize()).uniformSamplerTexture("PrevHistoryOutput", 7).uniformSamplerTexture("MotionDepthClipAlphaBuffer", 8).uniformSamplerTexture("YCoCgColor", 9).uniformStorageTexture("SceneColorOutput", 0).uniformStorageTexture("HistoryOutput", 1).build());
        this.upscaleShader.compile();
        this.sgsrPipeline = new Pipeline();
        this.PrevLumaHistory = RenderSystems.current().device().createTexture(TextureDescription.create().type(TextureType.Texture2D).width(RenderHandlerManager.getRenderWidth()).height(RenderHandlerManager.getRenderHeight()).format(TextureFormat.R32UI).usages(TextureUsages.create().storage().sampler()).build());
        this.YCoCgColor = RenderSystems.current().device().createTexture(TextureDescription.create().type(TextureType.Texture2D).width(RenderHandlerManager.getRenderWidth()).height(RenderHandlerManager.getRenderHeight()).format(TextureFormat.R32UI).usages(TextureUsages.create().storage().sampler()).build());
        this.MotionDepthClipAlphaBuffer = RenderSystems.current().device().createTexture(TextureDescription.create().type(TextureType.Texture2D).width(RenderHandlerManager.getRenderWidth()).height(RenderHandlerManager.getRenderHeight()).format(TextureFormat.RGBA16F).usages(TextureUsages.create().storage().sampler()).build());
        this.PrevHistoryOutput = RenderSystems.current().device().createTexture(TextureDescription.create().type(TextureType.Texture2D).width(RenderHandlerManager.getScreenWidth()).height(RenderHandlerManager.getScreenHeight()).format(TextureFormat.RGBA16F).usages(TextureUsages.create().storage().sampler()).build());
        this.HistoryOutput = RenderSystems.current().device().createTexture(TextureDescription.create().type(TextureType.Texture2D).width(RenderHandlerManager.getScreenWidth()).height(RenderHandlerManager.getScreenHeight()).format(TextureFormat.RGBA16F).usages(TextureUsages.create().storage().sampler()).build());
        this.sgsrPipeline.job("convert", ((PipelineJobBuilders.ComputeJobBuilder)((PipelineJobBuilders.ComputeJobBuilder)((PipelineJobBuilders.ComputeJobBuilder)((PipelineJobBuilders.ComputeJobBuilder)((PipelineJobBuilders.ComputeJobBuilder)((PipelineJobBuilders.ComputeJobBuilder)PipelineJobBuilders.compute(this.convertShader).resource("InputColor", PipelineJobResource.SamplerTexture.create(() -> Optional.ofNullable(sgsr.getInputResourceSet().colorTexture())))).resource("InputDepth", PipelineJobResource.SamplerTexture.create(() -> Optional.ofNullable(sgsr.getInputResourceSet().depthTexture())))).resource("InputVelocity", PipelineJobResource.SamplerTexture.create(() -> Optional.ofNullable(sgsr.getInputResourceSet().motionVectorsTexture())))).resource("MotionDepthClipAlphaBuffer", PipelineJobResource.StorageTexture.create(this.MotionDepthClipAlphaBuffer, PipelineResourceAccess.Write))).resource("YCoCgColor", PipelineJobResource.StorageTexture.create(this.YCoCgColor, PipelineResourceAccess.Write))).resource("Params", PipelineJobResource.UniformBuffer.create(sgsr.getParams()))).workGroupSupplier(this::getWorkGroupSize).build());
        this.sgsrPipeline.job("upscale", ((PipelineJobBuilders.ComputeJobBuilder)((PipelineJobBuilders.ComputeJobBuilder)((PipelineJobBuilders.ComputeJobBuilder)((PipelineJobBuilders.ComputeJobBuilder)((PipelineJobBuilders.ComputeJobBuilder)((PipelineJobBuilders.ComputeJobBuilder)PipelineJobBuilders.compute(this.upscaleShader).resource("PrevHistoryOutput", PipelineJobResource.SamplerTexture.create(TextureSupplier.of(() -> this.PrevHistoryOutput)))).resource("MotionDepthClipAlphaBuffer", PipelineJobResource.SamplerTexture.create(this.MotionDepthClipAlphaBuffer))).resource("YCoCgColor", PipelineJobResource.SamplerTexture.create(this.YCoCgColor))).resource("SceneColorOutput", PipelineJobResource.StorageTexture.create(FrameBufferTextureAdapter.ofColor(sgsr.getOutputFrameBuffer()), PipelineResourceAccess.Write))).resource("HistoryOutput", PipelineJobResource.StorageTexture.create(TextureSupplier.of(() -> this.HistoryOutput), PipelineResourceAccess.Write))).resource("Params", PipelineJobResource.UniformBuffer.create(sgsr.getParams()))).workGroupSupplier(this::getWorkGroupSize).build());
    }

    private void swapHistoryOutput() {
        ITexture tempA = this.PrevHistoryOutput;
        this.PrevHistoryOutput = this.HistoryOutput;
        this.HistoryOutput = tempA;
    }

    @Override
    public void destroy() {
        this.HistoryOutput.destroy();
        this.PrevHistoryOutput.destroy();
        this.convertShader.destroy();
        this.upscaleShader.destroy();
        this.MotionDepthClipAlphaBuffer.destroy();
        this.YCoCgColor.destroy();
    }

    @Override
    public void resize(int width, int height) {
        this.HistoryOutput.resize(width, height);
        this.PrevHistoryOutput.resize(width, height);
        this.MotionDepthClipAlphaBuffer.resize(RenderHandlerManager.getRenderWidth(), RenderHandlerManager.getRenderHeight());
        this.YCoCgColor.resize(RenderHandlerManager.getRenderWidth(), RenderHandlerManager.getRenderHeight());
    }
}

