/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.impl.pipeline;

import io.homo.superresolution.core.graphics.impl.buffer.IBuffer;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineJobResource;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineResourceType;
import io.homo.superresolution.core.graphics.impl.shader.IShaderProgram;
import io.homo.superresolution.core.graphics.impl.shader.uniform.ShaderUniformType;
import io.homo.superresolution.core.graphics.impl.shader.uniform.ShaderUniforms;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class GpuComputeJob<SELF extends GpuComputeJob<?>> {
    protected Map<String, PipelineJobResource<?>> resources = new HashMap();

    public SELF resource(String key, PipelineJobResource<?> resource) {
        this.resources.put(key, resource);
        return (SELF)this;
    }

    public PipelineJobResource<?> resource(String key) {
        return this.resources.get(key);
    }

    protected void setupProgramResources(IShaderProgram<?> program) {
        block5: for (Map.Entry<String, PipelineJobResource<?>> resourceEntry : this.resources.entrySet()) {
            String resourceName = resourceEntry.getKey();
            PipelineJobResource<?> jobResource = resourceEntry.getValue();
            if (!program.getDescription().shaderUniforms().containsKey(resourceName)) continue;
            ShaderUniformType expectedType = ((ShaderUniforms)program.uniforms()).get(resourceName).type();
            Optional<?> resource = jobResource.getResource();
            if (resource.isEmpty()) continue;
            switch (expectedType) {
                case SamplerTexture: {
                    if (jobResource.type != PipelineResourceType.SamplerTexture) {
                        throw new IllegalArgumentException("\u8d44\u6e90\u7c7b\u578b\u4e0d\u5339\u914d: " + resourceName + " \u671f\u671b SamplerTexture\uff0c\u5b9e\u9645 " + String.valueOf((Object)jobResource.type));
                    }
                    ((ShaderUniforms)program.uniforms()).samplerTexture(resourceName).setTexture((ITexture)resource.get());
                    continue block5;
                }
                case StorageTexture: {
                    if (jobResource.type != PipelineResourceType.StorageTexture) {
                        throw new IllegalArgumentException("\u8d44\u6e90\u7c7b\u578b\u4e0d\u5339\u914d: " + resourceName + " \u671f\u671b StorageTexture\uff0c\u5b9e\u9645 " + String.valueOf((Object)jobResource.type));
                    }
                    ((ShaderUniforms)program.uniforms()).storageTexture(resourceName).setTexture((ITexture)resource.get());
                    continue block5;
                }
                case UniformBuffer: {
                    if (jobResource.type != PipelineResourceType.UniformBuffer) {
                        throw new IllegalArgumentException("\u8d44\u6e90\u7c7b\u578b\u4e0d\u5339\u914d: " + resourceName + " \u671f\u671b Buffer\uff0c\u5b9e\u9645 " + String.valueOf((Object)jobResource.type));
                    }
                    ((ShaderUniforms)program.uniforms()).uniformBuffer(resourceName).setBuffer((IBuffer)((IBuffer)resource.get()));
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684uniform\u7c7b\u578b: " + String.valueOf((Object)expectedType));
        }
    }
}

