/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.impl.texture;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum TextureFormat {
    RGBA8(32856, 37, DataType.UNSIGNED_NORMALIZED, TextureComponent.R, TextureComponent.G, TextureComponent.B, TextureComponent.A),
    RGBA16F(34842, 97, DataType.FLOAT, TextureComponent.R, TextureComponent.G, TextureComponent.B, TextureComponent.A),
    RGB8(32849, 23, DataType.UNSIGNED_NORMALIZED, TextureComponent.R, TextureComponent.G, TextureComponent.B),
    RGB16F(34843, 90, DataType.FLOAT, TextureComponent.R, TextureComponent.G, TextureComponent.B),
    RGBA16(32859, 91, DataType.UNSIGNED_NORMALIZED, TextureComponent.R, TextureComponent.G, TextureComponent.B, TextureComponent.A),
    RG16F(33327, 83, DataType.FLOAT, TextureComponent.R, TextureComponent.G),
    RG32F(33328, 103, DataType.FLOAT, TextureComponent.R, TextureComponent.G),
    RG8(33323, 16, DataType.UNSIGNED_NORMALIZED, TextureComponent.R, TextureComponent.G),
    R16F(33325, 76, DataType.FLOAT, TextureComponent.R),
    R8(33321, 9, DataType.UNSIGNED_NORMALIZED, TextureComponent.R),
    R32F(33326, 100, DataType.FLOAT, TextureComponent.R),
    R32UI(33334, 98, DataType.UNSIGNED_INTEGER, TextureComponent.R),
    DEPTH32F(36012, 126, DataType.FLOAT, TextureComponent.Depth),
    DEPTH32F_STENCIL8(36013, 130, DataType.FLOAT, TextureComponent.Depth, TextureComponent.Stencil),
    DEPTH24_STENCIL8(35056, 129, DataType.UNSIGNED_NORMALIZED, TextureComponent.Depth, TextureComponent.Stencil),
    DEPTH24(33190, 125, DataType.UNSIGNED_NORMALIZED, TextureComponent.Depth),
    DEPTH32(33191, 126, DataType.UNSIGNED_NORMALIZED, TextureComponent.Depth),
    R16_SNORM(36760, 71, DataType.SIGNED_NORMALIZED, TextureComponent.R),
    R11G11B10F(35898, 122, DataType.FLOAT, TextureComponent.R, TextureComponent.G, TextureComponent.B),
    DEPTH_COMPONENT(6402, 124, DataType.UNSIGNED_NORMALIZED, TextureComponent.Depth);

    private static final Map<Integer, TextureFormat> GL_TO_FORMAT;
    private static final Map<Integer, TextureFormat> VK_TO_FORMAT;
    private final EnumSet<TextureComponent> components = EnumSet.noneOf(TextureComponent.class);
    private final int glFormat;
    private final int vkFormat;
    private final DataType dataType;

    private TextureFormat(int glFormat, int vkFormat, DataType dataType, TextureComponent ... component) {
        this.glFormat = glFormat;
        this.vkFormat = vkFormat;
        this.dataType = dataType;
        if (component != null && component.length > 0) {
            this.components.addAll(List.of(component));
        }
    }

    @NotNull
    public static TextureFormat fromVk(int format) {
        TextureFormat result = VK_TO_FORMAT.get(format);
        if (result == null) {
            throw new IllegalArgumentException("Unsupported Vulkan format: 0x" + Integer.toHexString(format).toUpperCase());
        }
        return result;
    }

    @NotNull
    public static TextureFormat fromGl(int format) {
        TextureFormat result = GL_TO_FORMAT.get(format);
        if (result == null) {
            throw new IllegalArgumentException("Unsupported OpenGL format: 0x" + Integer.toHexString(format).toUpperCase());
        }
        return result;
    }

    public boolean isStencil() {
        return this.components.contains((Object)TextureComponent.Stencil);
    }

    public boolean isDepth() {
        return this.components.contains((Object)TextureComponent.Depth);
    }

    public boolean isInteger() {
        return this.dataType == DataType.UNSIGNED_INTEGER || this.dataType == DataType.SIGNED_INTEGER;
    }

    public boolean isFloat() {
        return this.dataType == DataType.FLOAT;
    }

    public boolean isNormalized() {
        return this.dataType == DataType.UNSIGNED_NORMALIZED || this.dataType == DataType.SIGNED_NORMALIZED;
    }

    public int getBytesPerPixel() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 4;
            case 2 -> 3;
            case 7 -> 2;
            case 9 -> 1;
            case 8, 17 -> 2;
            case 5 -> 4;
            case 6 -> 8;
            case 10, 11 -> 4;
            case 1, 4 -> 8;
            case 3, 13 -> 6;
            case 18 -> 4;
            case 12, 16, 19 -> 4;
            case 14, 15 -> 4;
        };
    }

    public int getChannelCount() {
        return this.components.size();
    }

    public boolean hasRedChannel() {
        return this.components.contains((Object)TextureComponent.R);
    }

    public boolean hasGreenChannel() {
        return this.components.contains((Object)TextureComponent.G);
    }

    public boolean hasBlueChannel() {
        return this.components.contains((Object)TextureComponent.B);
    }

    public boolean hasAlphaChannel() {
        return this.components.contains((Object)TextureComponent.A);
    }

    public boolean isDepthStencil() {
        return this.isDepth() && this.isStencil();
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public int gl() {
        return this.glFormat;
    }

    public int vk() {
        return this.vkFormat;
    }

    static {
        HashMap<Integer, TextureFormat> glMap = new HashMap<Integer, TextureFormat>();
        HashMap<Integer, TextureFormat> vkMap = new HashMap<Integer, TextureFormat>();
        for (TextureFormat format : TextureFormat.values()) {
            glMap.put(format.glFormat, format);
            vkMap.put(format.vkFormat, format);
        }
        GL_TO_FORMAT = Collections.unmodifiableMap(glMap);
        VK_TO_FORMAT = Collections.unmodifiableMap(vkMap);
    }

    public static enum TextureComponent {
        R,
        G,
        B,
        A,
        Depth,
        Stencil;

    }

    public static enum DataType {
        UNSIGNED_INTEGER,
        SIGNED_INTEGER,
        FLOAT,
        UNSIGNED_NORMALIZED,
        SIGNED_NORMALIZED;

    }
}

