/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.vulkan.utils;

import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.core.graphics.vulkan.utils.VulkanUtils;
import io.homo.superresolution.core.impl.Destroyable;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.Collections;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.vulkan.EXTDebugUtils;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VkDebugUtilsMessengerCallbackDataEXT;
import org.lwjgl.vulkan.VkDebugUtilsMessengerCallbackEXT;
import org.lwjgl.vulkan.VkDebugUtilsMessengerCallbackEXTI;
import org.lwjgl.vulkan.VkDebugUtilsMessengerCreateInfoEXT;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkLayerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VulkanValidationLayers
implements Destroyable {
    private static final Logger LOGGER = LoggerFactory.getLogger(VulkanValidationLayers.class);
    private static final Set<String> REQUIRED_LAYERS = Collections.singleton("VK_LAYER_KHRONOS_validation");
    private final VkInstance instance;
    private long debugMessenger;

    public VulkanValidationLayers(VkInstance instance) {
        this.instance = instance;
    }

    public static boolean checkValidationLayerSupport() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer layerCount = stack.ints(0);
            VulkanUtils.VK_CHECK(VK10.vkEnumerateInstanceLayerProperties((IntBuffer)layerCount, null));
            VkLayerProperties.Buffer availableLayers = VkLayerProperties.malloc((int)layerCount.get(0), (MemoryStack)stack);
            VulkanUtils.VK_CHECK(VK10.vkEnumerateInstanceLayerProperties((IntBuffer)layerCount, (VkLayerProperties.Buffer)availableLayers));
            boolean bl = availableLayers.stream().map(VkLayerProperties::layerNameString).anyMatch(REQUIRED_LAYERS::contains);
            return bl;
        }
    }

    public void setupDebugMessenger() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkDebugUtilsMessengerCreateInfoEXT createInfo = VkDebugUtilsMessengerCreateInfoEXT.calloc((MemoryStack)stack);
            VulkanValidationLayers.populateDebugMessengerCreateInfo(createInfo);
            LongBuffer pDebugMessenger = stack.mallocLong(1);
            VulkanUtils.VK_CHECK(this.createDebugUtilsMessengerEXT(this.instance, createInfo, pDebugMessenger), "Failed to set up debug messenger");
            this.debugMessenger = pDebugMessenger.get(0);
        }
    }

    public static void populateDebugMessengerCreateInfo(VkDebugUtilsMessengerCreateInfoEXT createInfo) {
        createInfo.sType(1000128004).messageSeverity(4353).messageType(7).pfnUserCallback((VkDebugUtilsMessengerCallbackEXTI)new VkDebugUtilsMessengerCallbackEXT(){

            public int invoke(int messageSeverity, int messageTypes, long pCallbackData, long pUserData) {
                VkDebugUtilsMessengerCallbackDataEXT callbackData = VkDebugUtilsMessengerCallbackDataEXT.create((long)pCallbackData);
                String message = callbackData.pMessageString();
                StackTraceElement[] elements = SuperResolution.renderThread.getStackTrace();
                if ((messageSeverity & 0x1000) != 0) {
                    LOGGER.error("[Vulkan Validation Error] {}", (Object)message);
                    for (StackTraceElement element : elements) {
                        LOGGER.error("    {}", (Object)element.toString());
                    }
                } else if ((messageSeverity & 0x100) != 0) {
                    LOGGER.warn("[Vulkan Validation Warn] {}", (Object)message);
                    for (StackTraceElement element : elements) {
                        LOGGER.warn("    {}", (Object)element.toString());
                    }
                } else {
                    LOGGER.info("[Vulkan Validation Debug] {}", (Object)message);
                    for (StackTraceElement element : elements) {
                        LOGGER.info("    {}", (Object)element.toString());
                    }
                }
                return 0;
            }
        });
    }

    private int debugCallback(int messageSeverity, int messageType, long pCallbackData, long pUserData) {
        VkDebugUtilsMessengerCallbackDataEXT callbackData = VkDebugUtilsMessengerCallbackDataEXT.create((long)pCallbackData);
        String message = callbackData.pMessageString();
        if ((messageSeverity & 0x1000) != 0) {
            LOGGER.info("[Vulkan Validation Error] {}", (Object)message);
        } else if ((messageSeverity & 0x100) != 0) {
            LOGGER.info("[Vulkan Validation Warn] {}", (Object)message);
        } else {
            LOGGER.info("[Vulkan Validation Debug] {}", (Object)message);
        }
        return 0;
    }

    public static PointerBuffer getValidationLayersPointerBuffer(MemoryStack stack) {
        PointerBuffer buffer = stack.mallocPointer(REQUIRED_LAYERS.size());
        REQUIRED_LAYERS.forEach(layer -> buffer.put(stack.UTF8((CharSequence)layer)));
        return (PointerBuffer)buffer.rewind();
    }

    @Override
    public void destroy() {
        if (this.debugMessenger != 0L) {
            this.destroyDebugUtilsMessengerEXT(this.instance, this.debugMessenger);
        }
    }

    private int createDebugUtilsMessengerEXT(VkInstance instance, VkDebugUtilsMessengerCreateInfoEXT createInfo, LongBuffer pDebugMessenger) {
        long func = VK10.vkGetInstanceProcAddr((VkInstance)instance, (CharSequence)"vkCreateDebugUtilsMessengerEXT");
        return func != 0L ? VulkanUtils.VK_CHECK(EXTDebugUtils.vkCreateDebugUtilsMessengerEXT((VkInstance)instance, (VkDebugUtilsMessengerCreateInfoEXT)createInfo, null, (LongBuffer)pDebugMessenger)) : -7;
    }

    private void destroyDebugUtilsMessengerEXT(VkInstance instance, long debugMessenger) {
        long func = VK10.vkGetInstanceProcAddr((VkInstance)instance, (CharSequence)"vkDestroyDebugUtilsMessengerEXT");
        if (func != 0L) {
            EXTDebugUtils.vkDestroyDebugUtilsMessengerEXT((VkInstance)instance, (long)debugMessenger, null);
        }
    }
}

