/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui;

import io.homo.superresolution.core.gui.MaterialTheme;
import io.homo.superresolution.core.gui.google.material.dynamiccolor.DynamicScheme;
import io.homo.superresolution.core.gui.google.material.hct.Hct;
import io.homo.superresolution.core.gui.google.material.scheme.SchemeContent;
import io.homo.superresolution.core.utils.Color;

public class MaterialScheme {
    public static final MaterialScheme defaultLight = MaterialScheme.from(MaterialTheme.Light, Color.from("#6750A4"));
    public static final MaterialScheme defaultDark = MaterialScheme.from(MaterialTheme.Dark, Color.from("#6750A4"));
    private final Color primary;
    private final Color onPrimary;
    private final Color primaryContainer;
    private final Color onPrimaryContainer;
    private final Color secondary;
    private final Color onSecondary;
    private final Color secondaryContainer;
    private final Color onSecondaryContainer;
    private final Color tertiary;
    private final Color onTertiary;
    private final Color tertiaryContainer;
    private final Color onTertiaryContainer;
    private final Color error;
    private final Color onError;
    private final Color errorContainer;
    private final Color onErrorContainer;
    private final Color background;
    private final Color onBackground;
    private final Color surface;
    private final Color onSurface;
    private final Color surfaceVariant;
    private final Color onSurfaceVariant;
    private final Color outline;
    private final Color outlineVariant;
    private final Color shadow;
    private final Color scrim;
    private final Color inverseSurface;
    private final Color inverseOnSurface;
    private final Color inversePrimary;
    private final Color primaryFixed;
    private final Color primaryFixedDim;
    private final Color onPrimaryFixed;
    private final Color onPrimaryFixedVariant;
    private final Color secondaryFixed;
    private final Color secondaryFixedDim;
    private final Color onSecondaryFixed;
    private final Color onSecondaryFixedVariant;
    private final Color tertiaryFixed;
    private final Color tertiaryFixedDim;
    private final Color onTertiaryFixed;
    private final Color onTertiaryFixedVariant;
    private final Color controlActivated;
    private final Color controlNormal;
    private final Color controlHighlight;
    private final Color textPrimaryInverse;
    private final Color textSecondaryAndTertiaryInverse;
    private final Color textPrimaryInverseDisableOnly;
    private final Color textSecondaryAndTertiaryInverseDisabled;
    private final Color textHintInverse;
    private final Color surfaceDim;
    private final Color surfaceBright;
    private final Color surfaceContainerLowest;
    private final Color surfaceContainerLow;
    private final Color surfaceContainer;
    private final Color surfaceContainerHigh;
    private final Color surfaceContainerHighest;
    private final Color surfaceTint;
    private final MaterialTheme theme;

    private MaterialScheme(MaterialTheme theme, DynamicScheme scheme) {
        this.theme = theme;
        this.primary = Color.rgba(scheme.getPrimary());
        this.onPrimary = Color.rgba(scheme.getOnPrimary());
        this.primaryContainer = Color.rgba(scheme.getPrimaryContainer());
        this.onPrimaryContainer = Color.rgba(scheme.getOnPrimaryContainer());
        this.secondary = Color.rgba(scheme.getSecondary());
        this.onSecondary = Color.rgba(scheme.getOnSecondary());
        this.secondaryContainer = Color.rgba(scheme.getSecondaryContainer());
        this.onSecondaryContainer = Color.rgba(scheme.getOnSecondaryContainer());
        this.tertiary = Color.rgba(scheme.getTertiary());
        this.onTertiary = Color.rgba(scheme.getOnTertiary());
        this.tertiaryContainer = Color.rgba(scheme.getTertiaryContainer());
        this.onTertiaryContainer = Color.rgba(scheme.getOnTertiaryContainer());
        this.error = Color.rgba(scheme.getError());
        this.onError = Color.rgba(scheme.getOnError());
        this.errorContainer = Color.rgba(scheme.getErrorContainer());
        this.onErrorContainer = Color.rgba(scheme.getOnErrorContainer());
        this.background = Color.rgba(scheme.getBackground());
        this.onBackground = Color.rgba(scheme.getOnBackground());
        this.surface = Color.rgba(scheme.getSurface());
        this.onSurface = Color.rgba(scheme.getOnSurface());
        this.surfaceVariant = Color.rgba(scheme.getSurfaceVariant());
        this.onSurfaceVariant = Color.rgba(scheme.getOnSurfaceVariant());
        this.outline = Color.rgba(scheme.getOutline());
        this.outlineVariant = Color.rgba(scheme.getOutlineVariant());
        this.shadow = Color.rgba(scheme.getShadow());
        this.scrim = Color.rgba(scheme.getScrim());
        this.inverseSurface = Color.rgba(scheme.getInverseSurface());
        this.inverseOnSurface = Color.rgba(scheme.getInverseOnSurface());
        this.inversePrimary = Color.rgba(scheme.getInversePrimary());
        this.primaryFixed = Color.rgba(scheme.getPrimaryFixed());
        this.primaryFixedDim = Color.rgba(scheme.getPrimaryFixedDim());
        this.onPrimaryFixed = Color.rgba(scheme.getOnPrimaryFixed());
        this.onPrimaryFixedVariant = Color.rgba(scheme.getOnPrimaryFixedVariant());
        this.secondaryFixed = Color.rgba(scheme.getSecondaryFixed());
        this.secondaryFixedDim = Color.rgba(scheme.getSecondaryFixedDim());
        this.onSecondaryFixed = Color.rgba(scheme.getOnSecondaryFixed());
        this.onSecondaryFixedVariant = Color.rgba(scheme.getOnSecondaryFixedVariant());
        this.tertiaryFixed = Color.rgba(scheme.getTertiaryFixed());
        this.tertiaryFixedDim = Color.rgba(scheme.getTertiaryFixedDim());
        this.onTertiaryFixed = Color.rgba(scheme.getOnTertiaryFixed());
        this.onTertiaryFixedVariant = Color.rgba(scheme.getOnTertiaryFixedVariant());
        this.controlActivated = Color.rgba(scheme.getControlActivated());
        this.controlNormal = Color.rgba(scheme.getControlNormal());
        this.controlHighlight = Color.rgba(scheme.getControlHighlight());
        this.textPrimaryInverse = Color.rgba(scheme.getTextPrimaryInverse());
        this.textSecondaryAndTertiaryInverse = Color.rgba(scheme.getTextSecondaryAndTertiaryInverse());
        this.textPrimaryInverseDisableOnly = Color.rgba(scheme.getTextPrimaryInverseDisableOnly());
        this.textSecondaryAndTertiaryInverseDisabled = Color.rgba(scheme.getTextSecondaryAndTertiaryInverseDisabled());
        this.textHintInverse = Color.rgba(scheme.getTextHintInverse());
        this.surfaceDim = Color.rgba(scheme.getSurfaceDim());
        this.surfaceBright = Color.rgba(scheme.getSurfaceBright());
        this.surfaceContainerLowest = Color.rgba(scheme.getSurfaceContainerLowest());
        this.surfaceContainerLow = Color.rgba(scheme.getSurfaceContainerLow());
        this.surfaceContainer = Color.rgba(scheme.getSurfaceContainer());
        this.surfaceContainerHigh = Color.rgba(scheme.getSurfaceContainerHigh());
        this.surfaceContainerHighest = Color.rgba(scheme.getSurfaceContainerHighest());
        this.surfaceTint = Color.rgba(scheme.getSurfaceTint());
    }

    public static MaterialScheme from(MaterialTheme theme, Color color) {
        return switch (theme) {
            default -> throw new MatchException(null, null);
            case MaterialTheme.Dark -> new MaterialScheme(theme, new SchemeContent(Hct.fromInt(color.integer()), true, 0.0));
            case MaterialTheme.Light -> new MaterialScheme(theme, new SchemeContent(Hct.fromInt(color.integer()), false, 0.0));
        };
    }

    public Color surfaceDim() {
        return this.surfaceDim;
    }

    public Color surfaceBright() {
        return this.surfaceBright;
    }

    public Color surfaceContainerLowest() {
        return this.surfaceContainerLowest;
    }

    public Color surfaceContainerLow() {
        return this.surfaceContainerLow;
    }

    public Color surfaceContainer() {
        return this.surfaceContainer;
    }

    public Color surfaceContainerHigh() {
        return this.surfaceContainerHigh;
    }

    public Color surfaceContainerHighest() {
        return this.surfaceContainerHighest;
    }

    public Color surfaceTint() {
        return this.surfaceTint;
    }

    public Color primaryFixed() {
        return this.primaryFixed;
    }

    public Color primaryFixedDim() {
        return this.primaryFixedDim;
    }

    public Color onPrimaryFixed() {
        return this.onPrimaryFixed;
    }

    public Color onPrimaryFixedVariant() {
        return this.onPrimaryFixedVariant;
    }

    public Color secondaryFixed() {
        return this.secondaryFixed;
    }

    public Color secondaryFixedDim() {
        return this.secondaryFixedDim;
    }

    public Color onSecondaryFixed() {
        return this.onSecondaryFixed;
    }

    public Color onSecondaryFixedVariant() {
        return this.onSecondaryFixedVariant;
    }

    public Color tertiaryFixed() {
        return this.tertiaryFixed;
    }

    public Color tertiaryFixedDim() {
        return this.tertiaryFixedDim;
    }

    public Color onTertiaryFixed() {
        return this.onTertiaryFixed;
    }

    public Color onTertiaryFixedVariant() {
        return this.onTertiaryFixedVariant;
    }

    public Color controlActivated() {
        return this.controlActivated;
    }

    public Color controlNormal() {
        return this.controlNormal;
    }

    public Color controlHighlight() {
        return this.controlHighlight;
    }

    public Color textPrimaryInverse() {
        return this.textPrimaryInverse;
    }

    public Color textSecondaryAndTertiaryInverse() {
        return this.textSecondaryAndTertiaryInverse;
    }

    public Color textPrimaryInverseDisableOnly() {
        return this.textPrimaryInverseDisableOnly;
    }

    public Color textSecondaryAndTertiaryInverseDisabled() {
        return this.textSecondaryAndTertiaryInverseDisabled;
    }

    public Color textHintInverse() {
        return this.textHintInverse;
    }

    public MaterialTheme theme() {
        return this.theme;
    }

    public Color inversePrimary() {
        return this.inversePrimary;
    }

    public Color inverseOnSurface() {
        return this.inverseOnSurface;
    }

    public Color inverseSurface() {
        return this.inverseSurface;
    }

    public Color scrim() {
        return this.scrim;
    }

    public Color shadow() {
        return this.shadow;
    }

    public Color outlineVariant() {
        return this.outlineVariant;
    }

    public Color outline() {
        return this.outline;
    }

    public Color onSurfaceVariant() {
        return this.onSurfaceVariant;
    }

    public Color surfaceVariant() {
        return this.surfaceVariant;
    }

    public Color onSurface() {
        return this.onSurface;
    }

    public Color surface() {
        return this.surface;
    }

    public Color onBackground() {
        return this.onBackground;
    }

    public Color background() {
        return this.background;
    }

    public Color onErrorContainer() {
        return this.onErrorContainer;
    }

    public Color errorContainer() {
        return this.errorContainer;
    }

    public Color onError() {
        return this.onError;
    }

    public Color error() {
        return this.error;
    }

    public Color onTertiaryContainer() {
        return this.onTertiaryContainer;
    }

    public Color tertiaryContainer() {
        return this.tertiaryContainer;
    }

    public Color onTertiary() {
        return this.onTertiary;
    }

    public Color tertiary() {
        return this.tertiary;
    }

    public Color onSecondaryContainer() {
        return this.onSecondaryContainer;
    }

    public Color secondaryContainer() {
        return this.secondaryContainer;
    }

    public Color onSecondary() {
        return this.onSecondary;
    }

    public Color secondary() {
        return this.secondary;
    }

    public Color onPrimaryContainer() {
        return this.onPrimaryContainer;
    }

    public Color primaryContainer() {
        return this.primaryContainer;
    }

    public Color onPrimary() {
        return this.onPrimary;
    }

    public Color primary() {
        return this.primary;
    }
}

