/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.core.backends.nanovg;

import io.homo.superresolution.common.minecraft.MinecraftWindow;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.opengl.GlStates;
import io.homo.superresolution.core.graphics.opengl.framebuffer.GlFrameBuffer;
import io.homo.superresolution.core.gui.core.backends.interfaces.Transform;
import io.homo.superresolution.core.utils.Color;
import io.homo.superresolution.core.utils.UIScalingCalculator;
import org.joml.Vector2f;
import org.lwjgl.nanovg.NVGColor;
import org.lwjgl.nanovg.NVGPaint;
import org.lwjgl.nanovg.NanoSVG;
import org.lwjgl.nanovg.NanoVG;
import org.lwjgl.nanovg.NanoVGGL3;

public class NanoVGContext {
    private static Transform S_currentTransform;
    private static Transform S_globalTransform;
    public GlFrameBuffer frameBuffer;
    public long contextPtr = -1L;
    public long rastPtr = -1L;
    public float globalScale = 1.0f;
    private Color S_fillColor = Color.black();
    private Color S_strokeColor = Color.black();
    private float S_strokeWidth = 1.0f;
    private float S_alpha = 1.0f;

    public NanoVGContext(int nvgFlags) {
        this.contextPtr = NanoVGGL3.nvgCreate((int)nvgFlags);
        this.rastPtr = NanoSVG.nsvgCreateRasterizer();
        this.frameBuffer = GlFrameBuffer.create(TextureFormat.R11G11B10F, TextureFormat.DEPTH24_STENCIL8, MinecraftWindow.getWindowWidth(), MinecraftWindow.getWindowHeight());
        this.frameBuffer.setClearColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public float globalScale() {
        return this.globalScale;
    }

    public void globalScale(float globalScale) {
        this.globalScale = globalScale;
    }

    public void begin(boolean copyMinecraftFbo) {
        Vector2f screenSize = MinecraftWindow.getWindowSize();
        GlStates.save("nanovg-frame");
        this.globalScale = (float)Math.max(UIScalingCalculator.calculateUIScaling((int)screenSize.x, (int)screenSize.y, 1.2f), 1.0);
        NanoVG.nvgBeginFrame((long)this.contextPtr, (float)screenSize.x, (float)screenSize.y, (float)this.globalScale);
        NanoVG.nvgReset((long)this.contextPtr);
        NanoVG.nvgScale((long)this.contextPtr, (float)1.0f, (float)1.0f);
    }

    public void end() {
        NanoVG.nvgEndFrame((long)this.contextPtr);
        GlStates.pop("nanovg-frame").restore();
    }

    public void save() {
        NanoVG.nvgSave((long)this.contextPtr);
    }

    public void restore() {
        NanoVG.nvgRestore((long)this.contextPtr);
    }

    public void line(float x1, float y1, float x2, float y2) {
        NanoVG.nvgMoveTo((long)this.contextPtr, (float)x1, (float)y1);
        NanoVG.nvgLineTo((long)this.contextPtr, (float)x2, (float)y2);
    }

    public void rect(float x, float y, float width, float height) {
        NanoVG.nvgRect((long)this.contextPtr, (float)x, (float)y, (float)width, (float)height);
    }

    public void roundedRect(float x, float y, float width, float height, float radius) {
        NanoVG.nvgRoundedRect((long)this.contextPtr, (float)x, (float)y, (float)width, (float)height, (float)radius);
    }

    public void beginPath() {
        NanoVG.nvgBeginPath((long)this.contextPtr);
    }

    public void endPath(boolean fill) {
        if (fill) {
            NanoVG.nvgFill((long)this.contextPtr);
        } else {
            NanoVG.nvgStroke((long)this.contextPtr);
        }
    }

    public void endPath() {
        NanoVG.nvgFill((long)this.contextPtr);
    }

    public void drawLine(float x1, float y1, float x2, float y2, Color color, float lineWidth) {
        this.beginPath();
        this.fillColor(color);
        this.strokeWidth(lineWidth);
        this.line(x1, y1, x2, y2);
        this.endPath();
    }

    public void drawRect(float x, float y, float width, float height, Color color, boolean fill) {
        this.beginPath();
        this.drawColor(fill, color);
        this.rect(x, y, width, height);
        this.endPath(fill);
    }

    public void drawRoundedRect(float x, float y, float width, float height, float radius, Color color, boolean fill) {
        this.beginPath();
        this.drawColor(fill, color);
        this.roundedRect(x, y, width, height, radius);
        this.endPath(fill);
    }

    public NVGPaint imagePattern(float ox, float oy, float ex, float ey, float width, float height, float angle, float alpha, int image) {
        return NanoVG.nvgImagePattern((long)this.contextPtr, (float)ox, (float)oy, (float)ex, (float)ey, (float)angle, (int)image, (float)alpha, (NVGPaint)NVGPaint.calloc());
    }

    public float globalAlpha() {
        return this.S_alpha;
    }

    public void globalAlpha(float alpha) {
        this.S_alpha = alpha;
    }

    public void resetScissor() {
        NanoVG.nvgResetScissor((long)this.contextPtr);
    }

    public void scissor(float x, float y, float width, float height) {
        NanoVG.nvgScissor((long)this.contextPtr, (float)x, (float)y, (float)width, (float)height);
    }

    public void transform(Transform transform) {
        this.resetTransform();
        if (S_globalTransform != null) {
            float[] globalMat = S_globalTransform.transformMatrix();
            NanoVG.nvgTransform((long)this.contextPtr, (float)globalMat[0], (float)globalMat[1], (float)globalMat[2], (float)globalMat[3], (float)globalMat[4], (float)globalMat[5]);
        }
        if (transform != null) {
            float[] mat = transform.transformMatrix();
            NanoVG.nvgTransform((long)this.contextPtr, (float)mat[0], (float)mat[1], (float)mat[2], (float)mat[3], (float)mat[4], (float)mat[5]);
            S_currentTransform = transform;
        }
    }

    public void globalTransform(Transform globalTransform) {
        if (globalTransform == null) {
            S_globalTransform = null;
            if (S_currentTransform != null) {
                this.transform(S_currentTransform);
            }
            return;
        }
        S_globalTransform = globalTransform;
        this.transform(null);
    }

    public void resetTransform() {
        NanoVG.nvgResetTransform((long)this.contextPtr);
        float[] globalScaleMat = Transform.identity().scale(this.globalScale).transformMatrix();
        NanoVG.nvgTransform((long)this.contextPtr, (float)globalScaleMat[0], (float)globalScaleMat[1], (float)globalScaleMat[2], (float)globalScaleMat[3], (float)globalScaleMat[4], (float)globalScaleMat[5]);
        S_currentTransform = null;
    }

    public void resetGlobalTransform() {
        NanoVG.nvgResetTransform((long)this.contextPtr);
        float[] globalScaleMat = Transform.identity().scale(this.globalScale).transformMatrix();
        NanoVG.nvgTransform((long)this.contextPtr, (float)globalScaleMat[0], (float)globalScaleMat[1], (float)globalScaleMat[2], (float)globalScaleMat[3], (float)globalScaleMat[4], (float)globalScaleMat[5]);
        S_globalTransform = null;
    }

    public NVGPaint linearGradient(float startX, float startY, float endX, float endY, Color from, Color to) {
        return this.linearGradient(startX, startY, endX, endY, from, to, NVGPaint.calloc());
    }

    public NVGPaint linearGradient(float startX, float startY, float endX, float endY, Color from, Color to, NVGPaint srcPaint) {
        from = from.copy().alpha((int)(this.globalAlpha() * (float)from.alpha()));
        to = to.copy().alpha((int)(this.globalAlpha() * (float)to.alpha()));
        NVGPaint paint = NanoVG.nvgLinearGradient((long)this.contextPtr, (float)startX, (float)startY, (float)endX, (float)endY, (NVGColor)from.nvg(), (NVGColor)to.nvg(), (NVGPaint)srcPaint);
        NanoVG.nvgFillPaint((long)this.contextPtr, (NVGPaint)paint);
        return paint;
    }

    public void strokeWidth(float width) {
        this.S_strokeWidth = width;
        NanoVG.nvgStrokeWidth((long)this.contextPtr, (float)width);
    }

    public void strokeColor(Color color) {
        color = color.copy().alpha((int)(this.globalAlpha() * (float)color.alpha()));
        this.S_strokeColor = Color.rgba(color.integer());
        NanoVG.nvgStrokeColor((long)this.contextPtr, (NVGColor)color.nvg());
    }

    public void fillColor(Color color) {
        color = color.copy().alpha((int)(this.globalAlpha() * (float)color.alpha()));
        this.S_fillColor = Color.rgba(color.integer());
        NanoVG.nvgFillColor((long)this.contextPtr, (NVGColor)color.nvg());
    }

    public void drawColor(boolean fill, Color color) {
        if (fill) {
            this.fillColor(color);
        } else {
            this.strokeColor(color);
        }
    }

    public void fontSize(float size) {
        NanoVG.nvgFontSize((long)this.contextPtr, (float)size);
    }

    public Color fillColor() {
        return this.S_fillColor;
    }

    public Color strokeColor() {
        return this.S_strokeColor;
    }

    public float strokeWidth() {
        return this.S_strokeWidth;
    }
}

