/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.core.backends.nanovg.commands;

import io.homo.superresolution.core.gui.core.backends.interfaces.DrawCommandType;
import io.homo.superresolution.core.gui.core.backends.nanovg.NanoVGContext;
import io.homo.superresolution.core.gui.core.backends.nanovg.commands.NVGDrawCommand;
import org.lwjgl.nanovg.NanoVG;

public class NVGPathRoundedRectComplexCommand
extends NVGDrawCommand {
    protected final float x;
    protected final float y;
    protected final float width;
    protected final float height;
    protected final float bottomLeftRadius;
    protected final float bottomRightRadius;
    protected final float topLeftRadius;
    protected final float topRightRadius;

    public NVGPathRoundedRectComplexCommand(NanoVGContext context, float x, float y, float width, float height, float bottomLeftRadius, float bottomRightRadius, float topLeftRadius, float topRightRadius) {
        super(context, DrawCommandType.PathRoundedRect);
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.bottomLeftRadius = bottomLeftRadius;
        this.bottomRightRadius = bottomRightRadius;
        this.topLeftRadius = topLeftRadius;
        this.topRightRadius = topRightRadius;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float width() {
        return this.width;
    }

    public float height() {
        return this.height;
    }

    public float bottomLeftRadius() {
        return this.bottomLeftRadius;
    }

    public float bottomRightRadius() {
        return this.bottomRightRadius;
    }

    public float topLeftRadius() {
        return this.topLeftRadius;
    }

    public float topRightRadius() {
        return this.topRightRadius;
    }

    @Override
    protected void execute() {
        float tl = this.topLeftRadius;
        float tr = this.topRightRadius;
        float bl = this.bottomLeftRadius;
        float br = this.bottomRightRadius;
        float w = this.width;
        float h = this.height;
        NanoVG.nvgMoveTo((long)this.context.contextPtr, (float)(this.x + tl), (float)this.y);
        NanoVG.nvgLineTo((long)this.context.contextPtr, (float)(this.x + w - tr), (float)this.y);
        NanoVG.nvgBezierTo((long)this.context.contextPtr, (float)(this.x + w - tr * 0.44771522f), (float)this.y, (float)(this.x + w), (float)(this.y + tr * 0.44771522f), (float)(this.x + w), (float)(this.y + tr));
        NanoVG.nvgLineTo((long)this.context.contextPtr, (float)(this.x + w), (float)(this.y + h - br));
        NanoVG.nvgBezierTo((long)this.context.contextPtr, (float)(this.x + w), (float)(this.y + h - br * 0.44771522f), (float)(this.x + w - br * 0.44771522f), (float)(this.y + h), (float)(this.x + w - br), (float)(this.y + h));
        NanoVG.nvgLineTo((long)this.context.contextPtr, (float)(this.x + bl), (float)(this.y + h));
        NanoVG.nvgBezierTo((long)this.context.contextPtr, (float)(this.x + bl * 0.44771522f), (float)(this.y + h), (float)this.x, (float)(this.y + h - bl * 0.44771522f), (float)this.x, (float)(this.y + h - bl));
        NanoVG.nvgLineTo((long)this.context.contextPtr, (float)this.x, (float)(this.y + tl));
        NanoVG.nvgBezierTo((long)this.context.contextPtr, (float)this.x, (float)(this.y + tl * 0.44771522f), (float)(this.x + tl * 0.44771522f), (float)this.y, (float)(this.x + tl), (float)this.y);
    }
}

