/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.widgets.switchs;

import io.homo.superresolution.core.gui.MaterialSymbols;
import io.homo.superresolution.core.gui.core.UIInputState;
import io.homo.superresolution.core.gui.core.animator.Easing;
import io.homo.superresolution.core.gui.core.backends.interfaces.IUIDrawContext;
import io.homo.superresolution.core.gui.core.event.EventListener;
import io.homo.superresolution.core.gui.core.event.events.WidgetEvent;
import io.homo.superresolution.core.gui.core.impl.Rectangle;
import io.homo.superresolution.core.gui.widgets.MaterialWidget;
import io.homo.superresolution.core.gui.widgets.switchs.MaterialSwitchAnimationSet;
import io.homo.superresolution.core.gui.widgets.switchs.MaterialSwitchSize;
import io.homo.superresolution.core.gui.widgets.switchs.MaterialSwitchStyle;
import io.homo.superresolution.core.utils.Color;
import io.homo.superresolution.core.utils.MouseCursor;
import org.joml.Vector2f;

public class MaterialSwitch
extends MaterialWidget<MaterialSwitch, MaterialSwitchStyle, MaterialSwitchAnimationSet> {
    private boolean checked;

    public MaterialSwitch() {
        this.style = new MaterialSwitchStyle();
        this.updateRectangle();
        this.getLayoutNode().setDebugName("MaterialSwitch");
    }

    public static MaterialSwitch create() {
        return new MaterialSwitch();
    }

    public boolean isChecked() {
        return this.checked;
    }

    @Override
    protected boolean isInteractive() {
        return true;
    }

    public MaterialSwitch toggleChecked() {
        boolean newChecked = !this.checked;
        this.eventHandler.fire(new WidgetEvent.ChangeEvent<Boolean>(newChecked));
        if (newChecked) {
            ((MaterialSwitchAnimationSet)this.animationSet).handlePosition.ease(Easing.LINEAR).animateTo(Float.valueOf(this.getBounds().width - 32.0f), 200L);
            ((MaterialSwitchAnimationSet)this.animationSet).handleSize.ease(Easing.LINEAR).animateTo(Float.valueOf(((MaterialSwitchStyle)this.style).showCheckedIconWhenEnable() || ((MaterialSwitchStyle)this.style).showCheckedIconAlways() ? MaterialSwitchSize.Default.handleSizeCheckedWithIcon() : MaterialSwitchSize.Default.handleSizeChecked()), 150L);
        } else {
            ((MaterialSwitchAnimationSet)this.animationSet).handlePosition.ease(Easing.LINEAR).animateTo(0, 200L);
            ((MaterialSwitchAnimationSet)this.animationSet).handleSize.ease(Easing.LINEAR).animateTo(Float.valueOf(((MaterialSwitchStyle)this.style).showUncheckedIconWhenEnable() || ((MaterialSwitchStyle)this.style).showUncheckedIconAlways() ? MaterialSwitchSize.Default.handleSizeWithIcon() : MaterialSwitchSize.Default.handleSize()), 150L);
        }
        ((MaterialSwitchAnimationSet)this.animationSet).change.set(0);
        ((MaterialSwitchAnimationSet)this.animationSet).change.animateTo(1, 200L);
        this.checked = newChecked;
        return this;
    }

    @Override
    protected void init() {
        this.animationSet = new MaterialSwitchAnimationSet();
        this.onHover(event -> this.onHover(event.getMousePosition(), event.isHovering()));
        this.onMouseRelease(event -> this.onRelease(event.getMousePosition()));
        this.onMousePress(event -> this.onPress(event.getMousePosition()));
    }

    private void updateRectangle() {
        this.setElementSize(MaterialSwitchSize.Default.trackWidth(), MaterialSwitchSize.Default.trackHeight());
    }

    public void onChange(EventListener<WidgetEvent.ChangeEvent> listener) {
        this.eventHandler.on(WidgetEvent.ChangeEvent.class, listener);
    }

    @Override
    public void render(IUIDrawContext drawContext, UIInputState inputState) {
        drawContext.beginBatch();
        this.updateRectangle();
        Rectangle bounds = this.getBounds();
        float f = ((MaterialSwitchAnimationSet)this.animationSet).handleSize.floatValue();
        float f2 = this.isChecked() && (((MaterialSwitchStyle)this.style).showCheckedIconWhenEnable() && this.isChecked() || ((MaterialSwitchStyle)this.style).showCheckedIconAlways()) || !this.isChecked() && (((MaterialSwitchStyle)this.style).showUncheckedIconWhenEnable() && !this.isChecked() || ((MaterialSwitchStyle)this.style).showUncheckedIconAlways()) ? MaterialSwitchSize.Default.handleSizeWithIcon() : MaterialSwitchSize.Default.handleSize();
        if (f < f2) {
            ((MaterialSwitchAnimationSet)this.animationSet).handleSize.set(Float.valueOf(this.isChecked() && (((MaterialSwitchStyle)this.style).showCheckedIconWhenEnable() && this.isChecked() || ((MaterialSwitchStyle)this.style).showCheckedIconAlways()) || !this.isChecked() && (((MaterialSwitchStyle)this.style).showUncheckedIconWhenEnable() && !this.isChecked() || ((MaterialSwitchStyle)this.style).showUncheckedIconAlways()) ? MaterialSwitchSize.Default.handleSizeWithIcon() : MaterialSwitchSize.Default.handleSize()));
        }
        ((MaterialSwitchAnimationSet)this.animationSet).update();
        SwitchColors colors = this.getSwitchColors();
        drawContext.drawRoundedRect(bounds.x, bounds.y, MaterialSwitchSize.Default.trackWidth(), MaterialSwitchSize.Default.trackHeight(), MaterialSwitchSize.Default.trackHeight() / 2.0f, colors.trackColor, true);
        if (!this.isChecked()) {
            drawContext.beginPath();
            drawContext.strokeColor(this.isDisabled() ? this.scheme().onSurface().copy().alpha(20) : this.scheme().outline());
            drawContext.strokeWidth(MaterialSwitchSize.Default.trackOutlineWidth());
            drawContext.roundedRect(bounds.x, bounds.y, MaterialSwitchSize.Default.trackWidth(), MaterialSwitchSize.Default.trackHeight(), MaterialSwitchSize.Default.trackHeight() / 2.0f);
            drawContext.endPath(false);
        }
        float handleSize = ((MaterialSwitchAnimationSet)this.animationSet).handleSize.floatValue();
        float handleX = bounds.x + 16.0f + ((MaterialSwitchAnimationSet)this.animationSet).handlePosition.floatValue();
        drawContext.drawArc(handleX, bounds.getCenterY(), handleSize / 2.0f, colors.handleColor, true);
        if (this.isHovered() || (double)((MaterialSwitchAnimationSet)this.animationSet).hover.floatValue() > 0.001) {
            drawContext.drawArc(handleX, bounds.getCenterY(), 20.0f, this.scheme().onSurface().copy().alpha((int)(25.5 * (double)((MaterialSwitchAnimationSet)this.animationSet).hover.floatValue())), true);
        }
        if (this.isChecked() && (((MaterialSwitchStyle)this.style).showCheckedIconWhenEnable() && this.isChecked() || ((MaterialSwitchStyle)this.style).showCheckedIconAlways())) {
            float checkedIconX = bounds.x + bounds.width - 16.0f;
            MaterialSymbols.iconCheck().render(drawContext, colors.iconColor.copy().alpha(!((MaterialSwitchAnimationSet)this.animationSet).handlePosition.isRunning() ? 255 : Math.min((int)((double)((MaterialSwitchAnimationSet)this.animationSet).handlePosition.progress() * 1.8 * 255.0), 255)), MaterialSwitchSize.Default.iconSize(), new Vector2f(checkedIconX, bounds.getCenterY()));
        }
        if (!this.isChecked() && (((MaterialSwitchStyle)this.style).showUncheckedIconWhenEnable() && !this.isChecked() || ((MaterialSwitchStyle)this.style).showUncheckedIconAlways())) {
            float closeIconX = bounds.x + 16.0f;
            float alpha = this.isDisabled() ? 1.0f : this.clamp(!((MaterialSwitchAnimationSet)this.animationSet).handlePosition.isRunning() ? 255.0f : Math.min(((MaterialSwitchAnimationSet)this.animationSet).handlePosition.progress() * 1.8f * 255.0f, 255.0f) / 255.0f, 0.0f, 1.0f);
            MaterialSymbols.iconClose().render(drawContext, colors.iconColor, MaterialSwitchSize.Default.iconSize(), new Vector2f(closeIconX, bounds.getCenterY()));
        }
        drawContext.endBatch(this.getZIndex());
    }

    private float clamp(float value, float min, float max) {
        return Math.min(max, Math.max(value, min));
    }

    private SwitchColors getSwitchColors() {
        SwitchColors colors = new SwitchColors();
        Color color = this.isDisabled() ? (this.isChecked() ? this.scheme().onSurface().copy().alpha(25) : this.scheme().surfaceVariant()).copy().alpha(25) : (colors.trackColor = this.isChecked() ? this.scheme().primary() : this.scheme().surfaceContainerHighest());
        Color color2 = this.isDisabled() ? (this.isChecked() ? this.scheme().surface() : this.scheme().onSurface().copy().alpha(96)) : (colors.handleColor = this.isChecked() ? this.scheme().onPrimary() : this.scheme().outline());
        colors.iconColor = this.isDisabled() ? (this.isChecked() ? this.scheme().surfaceContainerHighest().copy().alpha(0) : this.scheme().surfaceContainerHighest().copy().alpha(96)) : (this.isChecked() ? this.scheme().primary() : this.scheme().surfaceContainerHighest());
        return colors;
    }

    private void onHover(Vector2f mousePosition, boolean hover) {
        if (hover) {
            ((MaterialSwitchAnimationSet)this.animationSet).hover.ease(Easing.LINEAR).animateTo(1, 200L);
            MouseCursor.HAND.use();
        } else {
            ((MaterialSwitchAnimationSet)this.animationSet).hover.ease(Easing.LINEAR).animateTo(0, 200L);
            MouseCursor.ARROW.use();
        }
    }

    private void onPress(Vector2f mousePosition) {
        ((MaterialSwitchAnimationSet)this.animationSet).handleSize.ease(Easing.LINEAR).animateTo(Float.valueOf(((MaterialSwitchStyle)this.style).showCheckedIconWhenEnable() && this.isChecked() || ((MaterialSwitchStyle)this.style).showCheckedIconAlways() ? MaterialSwitchSize.Default.handleSizePressWithIcon() : MaterialSwitchSize.Default.handleSizePress()), 150L);
        ((MaterialSwitchAnimationSet)this.animationSet).hover.ease(Easing.LINEAR).animateTo(1, 200L);
        ((MaterialSwitchAnimationSet)this.animationSet).press.ease(Easing.LINEAR).animateTo(1, 200L);
    }

    private void onRelease(Vector2f mousePosition) {
        this.toggleChecked();
        ((MaterialSwitchAnimationSet)this.animationSet).handleSize.ease(Easing.LINEAR).animateTo(Float.valueOf(((MaterialSwitchStyle)this.style).showUncheckedIconWhenEnable() && !this.isChecked() || ((MaterialSwitchStyle)this.style).showUncheckedIconAlways() ? (!this.isChecked() ? MaterialSwitchSize.Default.handleSizeCheckedWithIcon() : MaterialSwitchSize.Default.handleSizeWithIcon()) : (this.isChecked() ? MaterialSwitchSize.Default.handleSizeChecked() : MaterialSwitchSize.Default.handleSize())), 150L);
        ((MaterialSwitchAnimationSet)this.animationSet).hover.ease(Easing.cubicBezier(0.2f, 0.0f, 0.0f, 1.0f)).animateTo(this.isHovered() ? 1 : 0, 200L);
        ((MaterialSwitchAnimationSet)this.animationSet).press.ease(Easing.cubicBezier(0.2f, 0.0f, 0.0f, 1.0f)).animateTo(0, 200L);
    }

    private static class SwitchColors {
        Color iconColor;
        Color handleColor;
        Color trackColor;

        private SwitchColors() {
        }
    }
}

