/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.srapi;

import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsage;
import io.homo.superresolution.srapi.SRResourceUsage;
import io.homo.superresolution.srapi.SRSurfaceFormat;
import java.util.EnumSet;

public class SRTextureResourceDescription {
    public SRSurfaceFormat format;
    public int width;
    public int height;
    public int mipmapCount;
    public int usage;

    public SRTextureResourceDescription(SRSurfaceFormat format, int width, int height, int mipmapCount, int usage) {
        this.format = format;
        this.width = width;
        this.height = height;
        this.mipmapCount = mipmapCount;
        this.usage = usage;
    }

    public SRTextureResourceDescription(int format, int width, int height, int mipmapCount, int usage) {
        this(SRSurfaceFormat.fromValue(format), width, height, mipmapCount, usage);
    }

    public SRTextureResourceDescription(ITexture texture) {
        this.format = switch (texture.getTextureFormat()) {
            default -> throw new MatchException(null, null);
            case TextureFormat.RGBA8 -> SRSurfaceFormat.R8G8B8A8_UNORM;
            case TextureFormat.RGBA16F -> SRSurfaceFormat.R16G16B16A16_FLOAT;
            case TextureFormat.RGB8, TextureFormat.RGB16F -> SRSurfaceFormat.UNKNOWN;
            case TextureFormat.RG16F -> SRSurfaceFormat.R16G16_FLOAT;
            case TextureFormat.RG32F -> SRSurfaceFormat.R32G32_FLOAT;
            case TextureFormat.RG8 -> SRSurfaceFormat.R8G8_UNORM;
            case TextureFormat.R16F -> SRSurfaceFormat.R16_FLOAT;
            case TextureFormat.R8 -> SRSurfaceFormat.R8_UNORM;
            case TextureFormat.R32F -> SRSurfaceFormat.R32_FLOAT;
            case TextureFormat.R32UI -> SRSurfaceFormat.R32_UINT;
            case TextureFormat.DEPTH32 -> SRSurfaceFormat.R32_TYPELESS;
            case TextureFormat.DEPTH32F -> SRSurfaceFormat.R32_FLOAT;
            case TextureFormat.DEPTH24_STENCIL8, TextureFormat.DEPTH24, TextureFormat.DEPTH_COMPONENT, TextureFormat.DEPTH32F_STENCIL8 -> SRSurfaceFormat.UNKNOWN;
            case TextureFormat.R16_SNORM -> SRSurfaceFormat.R16_SNORM;
            case TextureFormat.R11G11B10F -> SRSurfaceFormat.R11G11B10_FLOAT;
            case TextureFormat.RGBA16 -> SRSurfaceFormat.R16G16B16A16_TYPELESS;
        };
        this.width = texture.getWidth();
        this.height = texture.getHeight();
        this.mipmapCount = texture.getMipmapSettings().getLevels();
        EnumSet<SRResourceUsage> usages = EnumSet.noneOf(SRResourceUsage.class);
        for (TextureUsage textureUsage : texture.getTextureUsages().getUsages()) {
            switch (textureUsage) {
                case Sampler: {
                    usages.add(SRResourceUsage.READ_ONLY);
                    break;
                }
                case Storage: {
                    usages.add(SRResourceUsage.UAV);
                    break;
                }
                case TransferSource: {
                    usages.add(SRResourceUsage.INDIRECT);
                    break;
                }
                case TransferDestination: {
                    usages.add(SRResourceUsage.RENDERTARGET);
                    break;
                }
                case AttachmentColor: {
                    usages.add(SRResourceUsage.RENDERTARGET);
                    break;
                }
                case AttachmentDepth: {
                    usages.add(SRResourceUsage.DEPTHTARGET);
                }
            }
        }
        this.usage = SRResourceUsage.toBitmask(usages);
    }
}

