/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.fsr2.common;

import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.graphics.impl.buffer.BufferDescription;
import io.homo.superresolution.core.graphics.impl.buffer.BufferUsage;
import io.homo.superresolution.core.graphics.opengl.buffer.GlBuffer;
import io.homo.superresolution.core.graphics.opengl.texture.GlTexture2D;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2ContextConfig;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2Dimensions;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2DispatchDescription;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2MaximumBias;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2Pipeline;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2PipelineDispatchResource;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2PipelineResourceType;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2PipelineResources;
import io.homo.superresolution.thirdparty.fsr2.common.struct.Fsr2CBFSR2;
import io.homo.superresolution.thirdparty.fsr2.common.struct.Fsr2CBRcas;
import io.homo.superresolution.thirdparty.fsr2.common.struct.Fsr2CBSpd;
import io.homo.superresolution.thirdparty.fsr2.v221.Fsr2v221AccumulatePipeline;
import io.homo.superresolution.thirdparty.fsr2.v221.Fsr2v221AccumulateSharpenPipeline;
import io.homo.superresolution.thirdparty.fsr2.v221.Fsr2v221ComputeLuminancePyramidPipeline;
import io.homo.superresolution.thirdparty.fsr2.v221.Fsr2v221DepthClipPipeline;
import io.homo.superresolution.thirdparty.fsr2.v221.Fsr2v221LockPipeline;
import io.homo.superresolution.thirdparty.fsr2.v221.Fsr2v221RCASPipeline;
import io.homo.superresolution.thirdparty.fsr2.v221.Fsr2v221ReconstructPreviousDepthPipeline;
import io.homo.superresolution.thirdparty.fsr2.v233.Fsr2v233AccumulatePipeline;
import io.homo.superresolution.thirdparty.fsr2.v233.Fsr2v233AccumulateSharpenPipeline;
import io.homo.superresolution.thirdparty.fsr2.v233.Fsr2v233ComputeLuminancePyramidPipeline;
import io.homo.superresolution.thirdparty.fsr2.v233.Fsr2v233DepthClipPipeline;
import io.homo.superresolution.thirdparty.fsr2.v233.Fsr2v233LockPipeline;
import io.homo.superresolution.thirdparty.fsr2.v233.Fsr2v233RCASPipeline;
import io.homo.superresolution.thirdparty.fsr2.v233.Fsr2v233ReconstructPreviousDepthPipeline;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fsr2Context {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"SuperResolution-FSR2");
    public Fsr2Pipeline accumulatePipeline;
    public Fsr2Pipeline rcasPipeline;
    public Fsr2Pipeline accumulateSharpenPipeline;
    public Fsr2Pipeline computeLuminancePyramidPipeline;
    public Fsr2Pipeline depthClipPipeline;
    public Fsr2Pipeline lockPipeline;
    public Fsr2Pipeline reconstructPreviousDepthPipeline;
    public Fsr2PipelineResources resources = new Fsr2PipelineResources();
    public Fsr2ContextConfig config;
    public Fsr2Dimensions dimensions;
    public Fsr2CBFSR2 fsr2Constants = new Fsr2CBFSR2();
    public GlBuffer fsr2ConstantsUBO;
    public Fsr2CBSpd fsr2SpdConstants = new Fsr2CBSpd();
    public GlBuffer fsr2SpdConstantsUBO;
    public Fsr2CBRcas fsr2RcasConstants = new Fsr2CBRcas();
    public GlBuffer fsr2RcasConstantsUBO;
    private int frameIndex = 0;
    private boolean maximumBiasTextureUploaded = false;

    public Fsr2Context(Fsr2ContextConfig config, Fsr2Dimensions dimensions) {
        this.config = config;
        this.dimensions = dimensions;
    }

    public void resize(Fsr2Dimensions dimensions) {
        this.dimensions = dimensions;
        this.resources.destroy();
        this.resources = null;
        this.resources = new Fsr2PipelineResources();
        this.resources.init(dimensions.renderWidth(), dimensions.renderHeight(), dimensions.screenWidth(), dimensions.screenHeight());
        this.accumulatePipeline.resize(dimensions);
        this.rcasPipeline.resize(dimensions);
        this.accumulateSharpenPipeline.resize(dimensions);
        this.computeLuminancePyramidPipeline.resize(dimensions);
        this.depthClipPipeline.resize(dimensions);
        this.lockPipeline.resize(dimensions);
        this.reconstructPreviousDepthPipeline.resize(dimensions);
        this.maximumBiasTextureUploaded = false;
    }

    public void destroy() {
        this.resources.destroy();
        this.accumulatePipeline.destroy();
        this.rcasPipeline.destroy();
        this.accumulateSharpenPipeline.destroy();
        this.computeLuminancePyramidPipeline.destroy();
        this.depthClipPipeline.destroy();
        this.lockPipeline.destroy();
        this.reconstructPreviousDepthPipeline.destroy();
        this.fsr2Constants.free();
        this.fsr2SpdConstants.free();
        this.fsr2RcasConstants.free();
        this.fsr2ConstantsUBO.destroy();
        this.fsr2SpdConstantsUBO.destroy();
        this.fsr2RcasConstantsUBO.destroy();
    }

    public void init() {
        this.fsr2RcasConstantsUBO = RenderSystems.current().device().createBuffer(BufferDescription.create().size(this.fsr2RcasConstants.size()).usage(BufferUsage.Ubo).build());
        this.fsr2SpdConstantsUBO = RenderSystems.current().device().createBuffer(BufferDescription.create().size(this.fsr2SpdConstants.size()).usage(BufferUsage.Ubo).build());
        this.fsr2ConstantsUBO = RenderSystems.current().device().createBuffer(BufferDescription.create().size(this.fsr2Constants.size()).usage(BufferUsage.Ubo).build());
        this.fsr2SpdConstantsUBO.setBufferData(this.fsr2SpdConstants);
        this.fsr2ConstantsUBO.setBufferData(this.fsr2Constants);
        this.fsr2RcasConstantsUBO.setBufferData(this.fsr2RcasConstants);
        this.resources = new Fsr2PipelineResources();
        this.resources.init(this.dimensions.renderWidth(), this.dimensions.renderHeight(), this.dimensions.screenWidth(), this.dimensions.screenHeight());
        switch (this.config.getVersion()) {
            case V221: {
                this.accumulatePipeline = new Fsr2v221AccumulatePipeline(this);
                this.rcasPipeline = new Fsr2v221RCASPipeline(this);
                this.accumulateSharpenPipeline = new Fsr2v221AccumulateSharpenPipeline(this);
                this.computeLuminancePyramidPipeline = new Fsr2v221ComputeLuminancePyramidPipeline(this);
                this.depthClipPipeline = new Fsr2v221DepthClipPipeline(this);
                this.lockPipeline = new Fsr2v221LockPipeline(this);
                this.reconstructPreviousDepthPipeline = new Fsr2v221ReconstructPreviousDepthPipeline(this);
                break;
            }
            case V233: {
                this.accumulatePipeline = new Fsr2v233AccumulatePipeline(this);
                this.rcasPipeline = new Fsr2v233RCASPipeline(this);
                this.accumulateSharpenPipeline = new Fsr2v233AccumulateSharpenPipeline(this);
                this.computeLuminancePyramidPipeline = new Fsr2v233ComputeLuminancePyramidPipeline(this);
                this.depthClipPipeline = new Fsr2v233DepthClipPipeline(this);
                this.lockPipeline = new Fsr2v233LockPipeline(this);
                this.reconstructPreviousDepthPipeline = new Fsr2v233ReconstructPreviousDepthPipeline(this);
            }
        }
        this.accumulatePipeline.init();
        this.rcasPipeline.init();
        this.accumulateSharpenPipeline.init();
        this.computeLuminancePyramidPipeline.init();
        this.depthClipPipeline.init();
        this.lockPipeline.init();
        this.reconstructPreviousDepthPipeline.init();
        this.resize(this.dimensions);
        this.maximumBiasTextureUploaded = false;
    }

    public void dispatch(Fsr2DispatchDescription dispatchDescription) {
        GlTexture2D maximumBiasTexture;
        if (!this.maximumBiasTextureUploaded && (maximumBiasTexture = (GlTexture2D)this.resources.resource(Fsr2PipelineResourceType.UPSAMPLE_MAXIMUM_BIAS_LUT).getResource()) != null) {
            int textureSize = Fsr2MaximumBias.FFX_FSR2_MAXIMUM_BIAS_TEXTURE_WIDTH * Fsr2MaximumBias.FFX_FSR2_MAXIMUM_BIAS_TEXTURE_HEIGHT;
            short[] data = new short[textureSize];
            for (int dataIndex = 0; dataIndex < data.length; ++dataIndex) {
                short converted;
                data[dataIndex] = converted = (short)Math.round(Fsr2MaximumBias.ffxFsr2MaximumBiasData[dataIndex] / 2.0f * 32767.0f);
            }
            int prevTex = GL11.glGetInteger((int)32873);
            GL11.glBindTexture((int)3553, (int)((int)maximumBiasTexture.handle()));
            GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)maximumBiasTexture.getWidth(), (int)maximumBiasTexture.getHeight(), (int)6403, (int)5122, (short[])data);
            GL11.glBindTexture((int)3553, (int)prevTex);
            this.maximumBiasTextureUploaded = true;
        }
        this.resources.resource(Fsr2PipelineResourceType.INPUT_COLOR).setResource(dispatchDescription.color);
        this.resources.resource(Fsr2PipelineResourceType.INPUT_MOTION_VECTORS).setResource(dispatchDescription.motionVectors);
        this.resources.resource(Fsr2PipelineResourceType.INPUT_DEPTH).setResource(dispatchDescription.depth);
        this.resources.resource(Fsr2PipelineResourceType.INPUT_EXPOSURE).setResource(dispatchDescription.exposure == null ? this.resources.resource(Fsr2PipelineResourceType.INTERNAL_DEFAULT_EXPOSURE).getResource() : dispatchDescription.exposure);
        this.resources.resource(Fsr2PipelineResourceType.INPUT_REACTIVE_MASK).setResource(dispatchDescription.reactive == null ? this.resources.resource(Fsr2PipelineResourceType.INTERNAL_DEFAULT_REACTIVITY).getResource() : dispatchDescription.reactive);
        this.resources.resource(Fsr2PipelineResourceType.INPUT_TRANSPARENCY_AND_COMPOSITION_MASK).setResource(dispatchDescription.transparencyAndComposition == null ? this.resources.resource(Fsr2PipelineResourceType.INTERNAL_DEFAULT_REACTIVITY).getResource() : dispatchDescription.transparencyAndComposition);
        this.resources.resource(Fsr2PipelineResourceType.UPSCALED_OUTPUT).setResource(dispatchDescription.output);
        this.fsr2Constants.update(this, dispatchDescription, this.dimensions);
        this.fsr2SpdConstants.update(this, dispatchDescription, this.dimensions);
        this.fsr2RcasConstants.update(this, dispatchDescription, this.dimensions);
        this.fsr2ConstantsUBO.upload();
        this.fsr2SpdConstantsUBO.upload();
        this.fsr2RcasConstantsUBO.upload();
        Fsr2PipelineDispatchResource pipelineDispatchResource = new Fsr2PipelineDispatchResource(this.resources, this.config, this.dimensions, dispatchDescription, dispatchDescription.commandBuffer);
        this.computeLuminancePyramidPipeline.execute(pipelineDispatchResource);
        this.reconstructPreviousDepthPipeline.execute(pipelineDispatchResource);
        this.depthClipPipeline.execute(pipelineDispatchResource);
        this.lockPipeline.execute(pipelineDispatchResource);
        if (dispatchDescription.enableSharpening()) {
            this.accumulateSharpenPipeline.execute(pipelineDispatchResource);
            this.rcasPipeline.execute(pipelineDispatchResource);
        } else {
            this.accumulatePipeline.execute(pipelineDispatchResource);
        }
        if (dispatchDescription.reset()) {
            this.frameIndex = 0;
        } else {
            ++this.frameIndex;
            this.frameIndex %= 16;
        }
    }

    public boolean isOddFrame() {
        return (this.frameIndex & 1) != 0;
    }
}

