/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm;

import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.PixelGrid;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.SizingMode;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.config.YogaConfig;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.numeric.Comparison;

public class Cache {
    private static boolean sizeIsExactAndMatchesOldMeasuredSize(SizingMode sizeMode, float size, float lastComputedSize) {
        return sizeMode == SizingMode.STRETCH_FIT && Comparison.inexactEquals(size, lastComputedSize);
    }

    private static boolean oldSizeIsMaxContentAndStillFits(SizingMode sizeMode, float size, SizingMode lastSizeMode, float lastComputedSize) {
        return sizeMode == SizingMode.FIT_CONTENT && lastSizeMode == SizingMode.MAX_CONTENT && (size >= lastComputedSize || Comparison.inexactEquals(size, lastComputedSize));
    }

    private static boolean newSizeIsStricterAndStillValid(SizingMode sizeMode, float size, SizingMode lastSizeMode, float lastSize, float lastComputedSize) {
        return lastSizeMode == SizingMode.FIT_CONTENT && sizeMode == SizingMode.FIT_CONTENT && Comparison.isDefined(lastSize) && Comparison.isDefined(size) && Comparison.isDefined(lastComputedSize) && lastSize > size && (lastComputedSize <= size || Comparison.inexactEquals(size, lastComputedSize));
    }

    public static boolean canUseCachedMeasurement(SizingMode widthMode, float availableWidth, SizingMode heightMode, float availableHeight, SizingMode lastWidthMode, float lastAvailableWidth, SizingMode lastHeightMode, float lastAvailableHeight, float lastComputedWidth, float lastComputedHeight, float marginRow, float marginColumn, YogaConfig config) {
        if (Comparison.isDefined(lastComputedHeight) && lastComputedHeight < 0.0f || Comparison.isDefined(lastComputedWidth) && lastComputedWidth < 0.0f) {
            return false;
        }
        float pointScaleFactor = config.getPointScaleFactor();
        boolean useRoundedComparison = config != null && pointScaleFactor != 0.0f;
        float effectiveWidth = useRoundedComparison ? PixelGrid.roundValueToPixelGrid(availableWidth, pointScaleFactor, false, false) : availableWidth;
        float effectiveHeight = useRoundedComparison ? PixelGrid.roundValueToPixelGrid(availableHeight, pointScaleFactor, false, false) : availableHeight;
        float effectiveLastWidth = useRoundedComparison ? PixelGrid.roundValueToPixelGrid(lastAvailableWidth, pointScaleFactor, false, false) : lastAvailableWidth;
        float effectiveLastHeight = useRoundedComparison ? PixelGrid.roundValueToPixelGrid(lastAvailableHeight, pointScaleFactor, false, false) : lastAvailableHeight;
        boolean hasSameWidthSpec = lastWidthMode == widthMode && Comparison.inexactEquals(effectiveLastWidth, effectiveWidth);
        boolean hasSameHeightSpec = lastHeightMode == heightMode && Comparison.inexactEquals(effectiveLastHeight, effectiveHeight);
        boolean widthIsCompatible = hasSameWidthSpec || Cache.sizeIsExactAndMatchesOldMeasuredSize(widthMode, availableWidth - marginRow, lastComputedWidth) || Cache.oldSizeIsMaxContentAndStillFits(widthMode, availableWidth - marginRow, lastWidthMode, lastComputedWidth) || Cache.newSizeIsStricterAndStillValid(widthMode, availableWidth - marginRow, lastWidthMode, lastAvailableWidth, lastComputedWidth);
        boolean heightIsCompatible = hasSameHeightSpec || Cache.sizeIsExactAndMatchesOldMeasuredSize(heightMode, availableHeight - marginColumn, lastComputedHeight) || Cache.oldSizeIsMaxContentAndStillFits(heightMode, availableHeight - marginColumn, lastHeightMode, lastComputedHeight) || Cache.newSizeIsStricterAndStillValid(heightMode, availableHeight - marginColumn, lastHeightMode, lastAvailableHeight, lastComputedHeight);
        return widthIsCompatible && heightIsCompatible;
    }
}

