/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.style;

import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaAlign;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaBoxSizing;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDimension;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDirection;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDisplay;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaEdge;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaFlexDirection;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaGutter;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaJustify;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaOverflow;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaPhysicalEdge;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaPositionType;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaWrap;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.FlexDirectionUtil;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.numeric.Comparison;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.numeric.FloatOptional;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.style.StyleLength;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.style.StyleSizeLength;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.style.StyleValueHandle;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.style.StyleValuePool;

public class YogaStyle {
    public static final float DEFAULT_FLEX_GROW = 0.0f;
    public static final float DEFAULT_FLEX_SHRINK = 0.0f;
    public static final float WEB_DEFAULT_FLEX_SHRINK = 1.0f;
    private YogaDirection direction = YogaDirection.INHERIT;
    private YogaFlexDirection flexDirection = YogaFlexDirection.COLUMN;
    private YogaJustify justifyContent = YogaJustify.FLEX_START;
    private YogaAlign alignContent = YogaAlign.FLEX_START;
    private YogaAlign alignItems = YogaAlign.STRETCH;
    private YogaAlign alignSelf = YogaAlign.AUTO;
    private YogaPositionType positionType = YogaPositionType.RELATIVE;
    private YogaWrap flexWrap = YogaWrap.NO_WRAP;
    private YogaOverflow overflow = YogaOverflow.VISIBLE;
    private YogaDisplay display = YogaDisplay.FLEX;
    private YogaBoxSizing boxSizing = YogaBoxSizing.BORDER_BOX;
    private StyleValueHandle flex = new StyleValueHandle();
    private StyleValueHandle flexGrow = new StyleValueHandle();
    private StyleValueHandle flexShrink = new StyleValueHandle();
    private StyleValueHandle flexBasis = StyleValueHandle.ofAuto();
    private StyleValueHandle[] margin = new StyleValueHandle[YogaEdge.values().length];
    private StyleValueHandle[] position = new StyleValueHandle[YogaEdge.values().length];
    private StyleValueHandle[] padding = new StyleValueHandle[YogaEdge.values().length];
    private StyleValueHandle[] border = new StyleValueHandle[YogaEdge.values().length];
    private StyleValueHandle[] gap = new StyleValueHandle[YogaGutter.values().length];
    private StyleValueHandle[] dimensions = new StyleValueHandle[]{StyleValueHandle.ofAuto(), StyleValueHandle.ofAuto()};
    private StyleValueHandle[] minDimensions = new StyleValueHandle[]{new StyleValueHandle(), new StyleValueHandle()};
    private StyleValueHandle[] maxDimensions = new StyleValueHandle[]{new StyleValueHandle(), new StyleValueHandle()};
    private StyleValueHandle aspectRatio = new StyleValueHandle();
    private StyleValuePool pool = new StyleValuePool();

    public YogaStyle() {
        int i;
        for (i = 0; i < YogaEdge.values().length; ++i) {
            this.margin[i] = new StyleValueHandle();
            this.position[i] = new StyleValueHandle();
            this.padding[i] = new StyleValueHandle();
            this.border[i] = new StyleValueHandle();
        }
        for (i = 0; i < YogaGutter.values().length; ++i) {
            this.gap[i] = new StyleValueHandle();
        }
    }

    public YogaStyle(YogaStyle other) {
        int i;
        this.direction = other.direction;
        this.flexDirection = other.flexDirection;
        this.justifyContent = other.justifyContent;
        this.alignContent = other.alignContent;
        this.alignItems = other.alignItems;
        this.alignSelf = other.alignSelf;
        this.positionType = other.positionType;
        this.flexWrap = other.flexWrap;
        this.overflow = other.overflow;
        this.display = other.display;
        this.boxSizing = other.boxSizing;
        this.flex = new StyleValueHandle();
        this.flexGrow = new StyleValueHandle();
        this.flexShrink = new StyleValueHandle();
        this.flexBasis = new StyleValueHandle();
        this.aspectRatio = new StyleValueHandle();
        this.margin = new StyleValueHandle[YogaEdge.values().length];
        this.position = new StyleValueHandle[YogaEdge.values().length];
        this.padding = new StyleValueHandle[YogaEdge.values().length];
        this.border = new StyleValueHandle[YogaEdge.values().length];
        this.gap = new StyleValueHandle[YogaGutter.values().length];
        this.dimensions = new StyleValueHandle[2];
        this.minDimensions = new StyleValueHandle[YogaDimension.values().length];
        this.maxDimensions = new StyleValueHandle[YogaDimension.values().length];
        this.pool = new StyleValuePool();
        this.setFlex(other.getFlex());
        this.setFlexGrow(other.getFlexGrow());
        this.setFlexShrink(other.getFlexShrink());
        this.setFlexBasis(other.getFlexBasis());
        this.setAspectRatio(other.getAspectRatio());
        for (i = 0; i < YogaEdge.values().length; ++i) {
            YogaEdge edge = YogaEdge.values()[i];
            this.margin[i] = new StyleValueHandle();
            this.position[i] = new StyleValueHandle();
            this.padding[i] = new StyleValueHandle();
            this.border[i] = new StyleValueHandle();
            this.setMargin(edge, other.getMargin(edge));
            this.setPosition(edge, other.getPosition(edge));
            this.setPadding(edge, other.getPadding(edge));
            this.setBorder(edge, other.getBorder(edge));
        }
        for (i = 0; i < YogaGutter.values().length; ++i) {
            YogaGutter gutter = YogaGutter.values()[i];
            this.gap[i] = new StyleValueHandle();
            this.setGap(gutter, other.getGap(gutter));
        }
        for (i = 0; i < YogaDimension.values().length; ++i) {
            YogaDimension dimension = YogaDimension.values()[i];
            if (i < this.dimensions.length) {
                this.dimensions[i] = new StyleValueHandle();
                this.setDimension(dimension, other.getDimension(dimension));
            }
            this.minDimensions[i] = new StyleValueHandle();
            this.maxDimensions[i] = new StyleValueHandle();
            this.setMinDimension(dimension, other.getMinDimension(dimension));
            this.setMaxDimension(dimension, other.getMaxDimension(dimension));
        }
    }

    public YogaDirection getDirection() {
        return this.direction;
    }

    public void setDirection(YogaDirection value) {
        this.direction = value;
    }

    public YogaFlexDirection getFlexDirection() {
        return this.flexDirection;
    }

    public void setFlexDirection(YogaFlexDirection value) {
        this.flexDirection = value;
    }

    public YogaJustify getJustifyContent() {
        return this.justifyContent;
    }

    public void setJustifyContent(YogaJustify value) {
        this.justifyContent = value;
    }

    public YogaAlign getAlignContent() {
        return this.alignContent;
    }

    public void setAlignContent(YogaAlign value) {
        this.alignContent = value;
    }

    public YogaAlign getAlignItems() {
        return this.alignItems;
    }

    public void setAlignItems(YogaAlign value) {
        this.alignItems = value;
    }

    public YogaAlign getAlignSelf() {
        return this.alignSelf;
    }

    public void setAlignSelf(YogaAlign value) {
        this.alignSelf = value;
    }

    public YogaPositionType getPositionType() {
        return this.positionType;
    }

    public void setPositionType(YogaPositionType value) {
        this.positionType = value;
    }

    public YogaWrap getFlexWrap() {
        return this.flexWrap;
    }

    public void setFlexWrap(YogaWrap value) {
        this.flexWrap = value;
    }

    public YogaOverflow getOverflow() {
        return this.overflow;
    }

    public void setOverflow(YogaOverflow value) {
        this.overflow = value;
    }

    public YogaDisplay getDisplay() {
        return this.display;
    }

    public void setDisplay(YogaDisplay value) {
        this.display = value;
    }

    public FloatOptional getFlex() {
        return this.pool.getNumber(this.flex);
    }

    public void setFlex(FloatOptional value) {
        this.pool.store(this.flex, value);
    }

    public FloatOptional getFlexGrow() {
        return this.pool.getNumber(this.flexGrow);
    }

    public void setFlexGrow(FloatOptional value) {
        this.pool.store(this.flexGrow, value);
    }

    public FloatOptional getFlexShrink() {
        return this.pool.getNumber(this.flexShrink);
    }

    public void setFlexShrink(FloatOptional value) {
        this.pool.store(this.flexShrink, value);
    }

    public StyleSizeLength getFlexBasis() {
        return this.pool.getSize(this.flexBasis);
    }

    public void setFlexBasis(StyleSizeLength value) {
        this.pool.store(this.flexBasis, value);
    }

    public StyleLength getMargin(YogaEdge edge) {
        return this.pool.getLength(this.margin[edge.ordinal()]);
    }

    public void setMargin(YogaEdge edge, StyleLength value) {
        this.pool.store(this.margin[edge.ordinal()], value);
    }

    public StyleLength getPosition(YogaEdge edge) {
        return this.pool.getLength(this.position[edge.ordinal()]);
    }

    public void setPosition(YogaEdge edge, StyleLength value) {
        this.pool.store(this.position[edge.ordinal()], value);
    }

    public StyleLength getPadding(YogaEdge edge) {
        return this.pool.getLength(this.padding[edge.ordinal()]);
    }

    public void setPadding(YogaEdge edge, StyleLength value) {
        this.pool.store(this.padding[edge.ordinal()], value);
    }

    public StyleLength getBorder(YogaEdge edge) {
        return this.pool.getLength(this.border[edge.ordinal()]);
    }

    public void setBorder(YogaEdge edge, StyleLength value) {
        this.pool.store(this.border[edge.ordinal()], value);
    }

    public StyleLength getGap(YogaGutter gutter) {
        return this.pool.getLength(this.gap[gutter.ordinal()]);
    }

    public void setGap(YogaGutter gutter, StyleLength value) {
        this.pool.store(this.gap[gutter.ordinal()], value);
    }

    public StyleSizeLength getDimension(YogaDimension axis) {
        return this.pool.getSize(this.dimensions[axis.ordinal()]);
    }

    public void setDimension(YogaDimension axis, StyleSizeLength value) {
        this.pool.store(this.dimensions[axis.ordinal()], value);
    }

    public StyleSizeLength getMinDimension(YogaDimension axis) {
        return this.pool.getSize(this.minDimensions[axis.ordinal()]);
    }

    public void setMinDimension(YogaDimension axis, StyleSizeLength value) {
        this.pool.store(this.minDimensions[axis.ordinal()], value);
    }

    public FloatOptional resolveMinDimension(YogaDirection direction, YogaDimension axis, float referenceLength, float ownerWidth) {
        FloatOptional value = this.getMinDimension(axis).resolve(referenceLength);
        if (this.boxSizing == YogaBoxSizing.BORDER_BOX) {
            return value;
        }
        FloatOptional dimensionPaddingAndBorder = FloatOptional.of(this.computePaddingAndBorderForDimension(direction, axis, ownerWidth));
        return dimensionPaddingAndBorder.isDefined() ? value.add(dimensionPaddingAndBorder) : value.add(FloatOptional.of(0.0f));
    }

    public StyleSizeLength getMaxDimension(YogaDimension axis) {
        return this.pool.getSize(this.maxDimensions[axis.ordinal()]);
    }

    public void setMaxDimension(YogaDimension axis, StyleSizeLength value) {
        this.pool.store(this.maxDimensions[axis.ordinal()], value);
    }

    public FloatOptional resolveMaxDimension(YogaDirection direction, YogaDimension axis, float referenceLength, float ownerWidth) {
        FloatOptional value = this.getMaxDimension(axis).resolve(referenceLength);
        if (this.boxSizing == YogaBoxSizing.BORDER_BOX) {
            return value;
        }
        FloatOptional dimensionPaddingAndBorder = FloatOptional.of(this.computePaddingAndBorderForDimension(direction, axis, ownerWidth));
        return dimensionPaddingAndBorder.isDefined() ? value.add(dimensionPaddingAndBorder) : value.add(FloatOptional.of(0.0f));
    }

    public FloatOptional getAspectRatio() {
        return this.pool.getNumber(this.aspectRatio);
    }

    public void setAspectRatio(FloatOptional value) {
        if (value.isDefined() && (value.unwrap() == 0.0f || Float.isInfinite(value.unwrap()))) {
            this.pool.store(this.aspectRatio, FloatOptional.of());
        } else {
            this.pool.store(this.aspectRatio, value);
        }
    }

    public YogaBoxSizing getBoxSizing() {
        return this.boxSizing;
    }

    public void setBoxSizing(YogaBoxSizing value) {
        this.boxSizing = value;
    }

    public boolean horizontalInsetsDefined() {
        return this.position[YogaEdge.LEFT.ordinal()].isDefined() || this.position[YogaEdge.RIGHT.ordinal()].isDefined() || this.position[YogaEdge.ALL.ordinal()].isDefined() || this.position[YogaEdge.HORIZONTAL.ordinal()].isDefined() || this.position[YogaEdge.START.ordinal()].isDefined() || this.position[YogaEdge.END.ordinal()].isDefined();
    }

    public boolean verticalInsetsDefined() {
        return this.position[YogaEdge.TOP.ordinal()].isDefined() || this.position[YogaEdge.BOTTOM.ordinal()].isDefined() || this.position[YogaEdge.ALL.ordinal()].isDefined() || this.position[YogaEdge.VERTICAL.ordinal()].isDefined();
    }

    public boolean isFlexStartPositionDefined(YogaFlexDirection axis, YogaDirection direction) {
        return this.computePosition(FlexDirectionUtil.flexStartEdge(axis), direction).isDefined();
    }

    public boolean isFlexStartPositionAuto(YogaFlexDirection axis, YogaDirection direction) {
        return this.computePosition(FlexDirectionUtil.flexStartEdge(axis), direction).isAuto();
    }

    public boolean isInlineStartPositionDefined(YogaFlexDirection axis, YogaDirection direction) {
        return this.computePosition(FlexDirectionUtil.inlineStartEdge(axis, direction), direction).isDefined();
    }

    public boolean isInlineStartPositionAuto(YogaFlexDirection axis, YogaDirection direction) {
        return this.computePosition(FlexDirectionUtil.inlineStartEdge(axis, direction), direction).isAuto();
    }

    public boolean isFlexEndPositionDefined(YogaFlexDirection axis, YogaDirection direction) {
        return this.computePosition(FlexDirectionUtil.flexEndEdge(axis), direction).isDefined();
    }

    public boolean isFlexEndPositionAuto(YogaFlexDirection axis, YogaDirection direction) {
        return this.computePosition(FlexDirectionUtil.flexEndEdge(axis), direction).isAuto();
    }

    public boolean isInlineEndPositionDefined(YogaFlexDirection axis, YogaDirection direction) {
        return this.computePosition(FlexDirectionUtil.inlineEndEdge(axis, direction), direction).isDefined();
    }

    public boolean isInlineEndPositionAuto(YogaFlexDirection axis, YogaDirection direction) {
        return this.computePosition(FlexDirectionUtil.inlineEndEdge(axis, direction), direction).isAuto();
    }

    public float computeFlexStartPosition(YogaFlexDirection axis, YogaDirection direction, float axisSize) {
        return this.computePosition(FlexDirectionUtil.flexStartEdge(axis), direction).resolve(axisSize).unwrapOrDefault(0.0f);
    }

    public float computeInlineStartPosition(YogaFlexDirection axis, YogaDirection direction, float axisSize) {
        return this.computePosition(FlexDirectionUtil.inlineStartEdge(axis, direction), direction).resolve(axisSize).unwrapOrDefault(0.0f);
    }

    public float computeFlexEndPosition(YogaFlexDirection axis, YogaDirection direction, float axisSize) {
        return this.computePosition(FlexDirectionUtil.flexEndEdge(axis), direction).resolve(axisSize).unwrapOrDefault(0.0f);
    }

    public float computeInlineEndPosition(YogaFlexDirection axis, YogaDirection direction, float axisSize) {
        return this.computePosition(FlexDirectionUtil.inlineEndEdge(axis, direction), direction).resolve(axisSize).unwrapOrDefault(0.0f);
    }

    public float computeFlexStartMargin(YogaFlexDirection axis, YogaDirection direction, float widthSize) {
        return this.computeMargin(FlexDirectionUtil.flexStartEdge(axis), direction).resolve(widthSize).unwrapOrDefault(0.0f);
    }

    public float computeInlineStartMargin(YogaFlexDirection axis, YogaDirection direction, float widthSize) {
        return this.computeMargin(FlexDirectionUtil.inlineStartEdge(axis, direction), direction).resolve(widthSize).unwrapOrDefault(0.0f);
    }

    public float computeFlexEndMargin(YogaFlexDirection axis, YogaDirection direction, float widthSize) {
        return this.computeMargin(FlexDirectionUtil.flexEndEdge(axis), direction).resolve(widthSize).unwrapOrDefault(0.0f);
    }

    public float computeInlineEndMargin(YogaFlexDirection axis, YogaDirection direction, float widthSize) {
        return this.computeMargin(FlexDirectionUtil.inlineEndEdge(axis, direction), direction).resolve(widthSize).unwrapOrDefault(0.0f);
    }

    public float computeFlexStartBorder(YogaFlexDirection axis, YogaDirection direction) {
        return Comparison.maxOrDefined(this.computeBorder(FlexDirectionUtil.flexStartEdge(axis), direction).resolve(0.0f).unwrap(), 0.0f);
    }

    public float computeInlineStartBorder(YogaFlexDirection axis, YogaDirection direction) {
        return Comparison.maxOrDefined(this.computeBorder(FlexDirectionUtil.inlineStartEdge(axis, direction), direction).resolve(0.0f).unwrap(), 0.0f);
    }

    public float computeFlexEndBorder(YogaFlexDirection axis, YogaDirection direction) {
        return Comparison.maxOrDefined(this.computeBorder(FlexDirectionUtil.flexEndEdge(axis), direction).resolve(0.0f).unwrap(), 0.0f);
    }

    public float computeInlineEndBorder(YogaFlexDirection axis, YogaDirection direction) {
        return Comparison.maxOrDefined(this.computeBorder(FlexDirectionUtil.inlineEndEdge(axis, direction), direction).resolve(0.0f).unwrap(), 0.0f);
    }

    public float computeFlexStartPadding(YogaFlexDirection axis, YogaDirection direction, float widthSize) {
        return Comparison.maxOrDefined(this.computePadding(FlexDirectionUtil.flexStartEdge(axis), direction).resolve(widthSize).unwrap(), 0.0f);
    }

    public float computeInlineStartPadding(YogaFlexDirection axis, YogaDirection direction, float widthSize) {
        return Comparison.maxOrDefined(this.computePadding(FlexDirectionUtil.inlineStartEdge(axis, direction), direction).resolve(widthSize).unwrap(), 0.0f);
    }

    public float computeFlexEndPadding(YogaFlexDirection axis, YogaDirection direction, float widthSize) {
        return Comparison.maxOrDefined(this.computePadding(FlexDirectionUtil.flexEndEdge(axis), direction).resolve(widthSize).unwrap(), 0.0f);
    }

    public float computeInlineEndPadding(YogaFlexDirection axis, YogaDirection direction, float widthSize) {
        return Comparison.maxOrDefined(this.computePadding(FlexDirectionUtil.inlineEndEdge(axis, direction), direction).resolve(widthSize).unwrap(), 0.0f);
    }

    public float computeInlineStartPaddingAndBorder(YogaFlexDirection axis, YogaDirection direction, float widthSize) {
        return this.computeInlineStartPadding(axis, direction, widthSize) + this.computeInlineStartBorder(axis, direction);
    }

    public float computeFlexStartPaddingAndBorder(YogaFlexDirection axis, YogaDirection direction, float widthSize) {
        return this.computeFlexStartPadding(axis, direction, widthSize) + this.computeFlexStartBorder(axis, direction);
    }

    public float computeInlineEndPaddingAndBorder(YogaFlexDirection axis, YogaDirection direction, float widthSize) {
        return this.computeInlineEndPadding(axis, direction, widthSize) + this.computeInlineEndBorder(axis, direction);
    }

    public float computeFlexEndPaddingAndBorder(YogaFlexDirection axis, YogaDirection direction, float widthSize) {
        return this.computeFlexEndPadding(axis, direction, widthSize) + this.computeFlexEndBorder(axis, direction);
    }

    public float computePaddingAndBorderForDimension(YogaDirection direction, YogaDimension dimension, float widthSize) {
        YogaFlexDirection flexDirectionForDimension = dimension == YogaDimension.WIDTH ? YogaFlexDirection.ROW : YogaFlexDirection.COLUMN;
        return this.computeFlexStartPaddingAndBorder(flexDirectionForDimension, direction, widthSize) + this.computeFlexEndPaddingAndBorder(flexDirectionForDimension, direction, widthSize);
    }

    public float computeBorderForAxis(YogaFlexDirection axis) {
        return this.computeInlineStartBorder(axis, YogaDirection.LTR) + this.computeInlineEndBorder(axis, YogaDirection.LTR);
    }

    public float computeMarginForAxis(YogaFlexDirection axis, float widthSize) {
        return this.computeInlineStartMargin(axis, YogaDirection.LTR, widthSize) + this.computeInlineEndMargin(axis, YogaDirection.LTR, widthSize);
    }

    public float computeGapForAxis(YogaFlexDirection axis, float ownerSize) {
        StyleLength gap = FlexDirectionUtil.isRow(axis) ? this.computeColumnGap() : this.computeRowGap();
        return Comparison.maxOrDefined(gap.resolve(ownerSize).unwrap(), 0.0f);
    }

    public boolean flexStartMarginIsAuto(YogaFlexDirection axis, YogaDirection direction) {
        return this.computeMargin(FlexDirectionUtil.flexStartEdge(axis), direction).isAuto();
    }

    public boolean flexEndMarginIsAuto(YogaFlexDirection axis, YogaDirection direction) {
        return this.computeMargin(FlexDirectionUtil.flexEndEdge(axis), direction).isAuto();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        YogaStyle other = (YogaStyle)obj;
        return this.direction == other.direction && this.flexDirection == other.flexDirection && this.justifyContent == other.justifyContent && this.alignContent == other.alignContent && this.alignItems == other.alignItems && this.alignSelf == other.alignSelf && this.positionType == other.positionType && this.flexWrap == other.flexWrap && this.overflow == other.overflow && this.display == other.display && YogaStyle.numbersEqual(this.flex, this.pool, other.flex, other.pool) && YogaStyle.numbersEqual(this.flexGrow, this.pool, other.flexGrow, other.pool) && YogaStyle.numbersEqual(this.flexShrink, this.pool, other.flexShrink, other.pool) && YogaStyle.lengthsEqual(this.flexBasis, this.pool, other.flexBasis, other.pool) && YogaStyle.arraysEqual(this.margin, this.pool, other.margin, other.pool) && YogaStyle.arraysEqual(this.position, this.pool, other.position, other.pool) && YogaStyle.arraysEqual(this.padding, this.pool, other.padding, other.pool) && YogaStyle.arraysEqual(this.border, this.pool, other.border, other.pool) && YogaStyle.arraysEqual(this.gap, this.pool, other.gap, other.pool) && YogaStyle.arraysEqual(this.dimensions, this.pool, other.dimensions, other.pool) && YogaStyle.arraysEqual(this.minDimensions, this.pool, other.minDimensions, other.pool) && YogaStyle.arraysEqual(this.maxDimensions, this.pool, other.maxDimensions, other.pool) && YogaStyle.numbersEqual(this.aspectRatio, this.pool, other.aspectRatio, other.pool);
    }

    private StyleLength computeColumnGap() {
        if (this.gap[YogaGutter.COLUMN.ordinal()].isDefined()) {
            return this.pool.getLength(this.gap[YogaGutter.COLUMN.ordinal()]);
        }
        return this.pool.getLength(this.gap[YogaGutter.ALL.ordinal()]);
    }

    private StyleLength computeRowGap() {
        if (this.gap[YogaGutter.ROW.ordinal()].isDefined()) {
            return this.pool.getLength(this.gap[YogaGutter.ROW.ordinal()]);
        }
        return this.pool.getLength(this.gap[YogaGutter.ALL.ordinal()]);
    }

    private StyleLength computeLeftEdge(StyleValueHandle[] edges, YogaDirection layoutDirection) {
        if (layoutDirection == YogaDirection.LTR && edges[YogaEdge.START.ordinal()].isDefined()) {
            return this.pool.getLength(edges[YogaEdge.START.ordinal()]);
        }
        if (layoutDirection == YogaDirection.RTL && edges[YogaEdge.END.ordinal()].isDefined()) {
            return this.pool.getLength(edges[YogaEdge.END.ordinal()]);
        }
        if (edges[YogaEdge.LEFT.ordinal()].isDefined()) {
            return this.pool.getLength(edges[YogaEdge.LEFT.ordinal()]);
        }
        if (edges[YogaEdge.HORIZONTAL.ordinal()].isDefined()) {
            return this.pool.getLength(edges[YogaEdge.HORIZONTAL.ordinal()]);
        }
        return this.pool.getLength(edges[YogaEdge.ALL.ordinal()]);
    }

    private StyleLength computeTopEdge(StyleValueHandle[] edges) {
        if (edges[YogaEdge.TOP.ordinal()].isDefined()) {
            return this.pool.getLength(edges[YogaEdge.TOP.ordinal()]);
        }
        if (edges[YogaEdge.VERTICAL.ordinal()].isDefined()) {
            return this.pool.getLength(edges[YogaEdge.VERTICAL.ordinal()]);
        }
        return this.pool.getLength(edges[YogaEdge.ALL.ordinal()]);
    }

    private StyleLength computeRightEdge(StyleValueHandle[] edges, YogaDirection layoutDirection) {
        if (layoutDirection == YogaDirection.LTR && edges[YogaEdge.END.ordinal()].isDefined()) {
            return this.pool.getLength(edges[YogaEdge.END.ordinal()]);
        }
        if (layoutDirection == YogaDirection.RTL && edges[YogaEdge.START.ordinal()].isDefined()) {
            return this.pool.getLength(edges[YogaEdge.START.ordinal()]);
        }
        if (edges[YogaEdge.RIGHT.ordinal()].isDefined()) {
            return this.pool.getLength(edges[YogaEdge.RIGHT.ordinal()]);
        }
        if (edges[YogaEdge.HORIZONTAL.ordinal()].isDefined()) {
            return this.pool.getLength(edges[YogaEdge.HORIZONTAL.ordinal()]);
        }
        return this.pool.getLength(edges[YogaEdge.ALL.ordinal()]);
    }

    private StyleLength computeBottomEdge(StyleValueHandle[] edges) {
        if (edges[YogaEdge.BOTTOM.ordinal()].isDefined()) {
            return this.pool.getLength(edges[YogaEdge.BOTTOM.ordinal()]);
        }
        if (edges[YogaEdge.VERTICAL.ordinal()].isDefined()) {
            return this.pool.getLength(edges[YogaEdge.VERTICAL.ordinal()]);
        }
        return this.pool.getLength(edges[YogaEdge.ALL.ordinal()]);
    }

    private StyleLength computePosition(YogaPhysicalEdge edge, YogaDirection direction) {
        switch (edge) {
            case LEFT: {
                return this.computeLeftEdge(this.position, direction);
            }
            case TOP: {
                return this.computeTopEdge(this.position);
            }
            case RIGHT: {
                return this.computeRightEdge(this.position, direction);
            }
            case BOTTOM: {
                return this.computeBottomEdge(this.position);
            }
        }
        throw new IllegalArgumentException("Invalid physical edge");
    }

    private StyleLength computeMargin(YogaPhysicalEdge edge, YogaDirection direction) {
        switch (edge) {
            case LEFT: {
                return this.computeLeftEdge(this.margin, direction);
            }
            case TOP: {
                return this.computeTopEdge(this.margin);
            }
            case RIGHT: {
                return this.computeRightEdge(this.margin, direction);
            }
            case BOTTOM: {
                return this.computeBottomEdge(this.margin);
            }
        }
        throw new IllegalArgumentException("Invalid physical edge");
    }

    private StyleLength computePadding(YogaPhysicalEdge edge, YogaDirection direction) {
        switch (edge) {
            case LEFT: {
                return this.computeLeftEdge(this.padding, direction);
            }
            case TOP: {
                return this.computeTopEdge(this.padding);
            }
            case RIGHT: {
                return this.computeRightEdge(this.padding, direction);
            }
            case BOTTOM: {
                return this.computeBottomEdge(this.padding);
            }
        }
        throw new IllegalArgumentException("Invalid physical edge");
    }

    private StyleLength computeBorder(YogaPhysicalEdge edge, YogaDirection direction) {
        switch (edge) {
            case LEFT: {
                return this.computeLeftEdge(this.border, direction);
            }
            case TOP: {
                return this.computeTopEdge(this.border);
            }
            case RIGHT: {
                return this.computeRightEdge(this.border, direction);
            }
            case BOTTOM: {
                return this.computeBottomEdge(this.border);
            }
        }
        throw new IllegalArgumentException("Invalid physical edge");
    }

    private static boolean numbersEqual(StyleValueHandle lhsHandle, StyleValuePool lhsPool, StyleValueHandle rhsHandle, StyleValuePool rhsPool) {
        return lhsHandle.isUndefined() && rhsHandle.isUndefined() || lhsPool.getNumber(lhsHandle).equals(rhsPool.getNumber(rhsHandle));
    }

    private static boolean lengthsEqual(StyleValueHandle lhsHandle, StyleValuePool lhsPool, StyleValueHandle rhsHandle, StyleValuePool rhsPool) {
        return lhsHandle.isUndefined() && rhsHandle.isUndefined() || lhsPool.getLength(lhsHandle).equals(rhsPool.getLength(rhsHandle));
    }

    private static boolean arraysEqual(StyleValueHandle[] lhs, StyleValuePool lhsPool, StyleValueHandle[] rhs, StyleValuePool rhsPool) {
        if (lhs.length != rhs.length) {
            return false;
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (YogaStyle.lengthsEqual(lhs[i], lhsPool, rhs[i], rhsPool)) continue;
            return false;
        }
        return true;
    }
}

