/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.test;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaConstants;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDimension;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDirection;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaEdge;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaErrata;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaExperimentalFeature;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaGutter;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaNode;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaUnit;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaValue;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.config.YogaConfig;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.style.StyleLength;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.style.StyleSizeLength;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.test.PrintOptions;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.test.SerializedMeasureFunc;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NodeToString {
    private static void appendFloatIfNotDefault(JsonObject json, String key, float num, float defaultNum) {
        if (num != defaultNum && !YogaConstants.isUndefined(num)) {
            json.addProperty(key, (Number)Float.valueOf(num));
        }
    }

    private static void appendYogaValueIfNotDefault(JsonObject json, String key, YogaValue value, YogaValue defaultValue) {
        if (!value.equals(defaultValue)) {
            if (value.unit == YogaUnit.AUTO) {
                json.addProperty(key, "auto");
            } else if (value.unit == YogaUnit.UNDEFINED) {
                json.addProperty(key, "undefined");
            } else {
                JsonObject valueObj = new JsonObject();
                valueObj.addProperty("value", (Number)Float.valueOf(value.value));
                valueObj.addProperty("unit", value.unit == YogaUnit.POINT ? "px" : "pct");
                json.add(key, (JsonElement)valueObj);
            }
        }
    }

    private static void appendEnumValueIfNotDefault(JsonObject json, String key, String value, String defaultValue) {
        if (!value.equals(defaultValue)) {
            json.addProperty(key, value);
        }
    }

    private static void appendBoolIfNotDefault(JsonObject json, String key, boolean value, boolean defaultValue) {
        if (value != defaultValue) {
            json.addProperty(key, Boolean.valueOf(value));
        }
    }

    private static void appendEdges(JsonObject json, String key, YogaNode node, YogaNode defaultNode, EdgeValueGetter valueGetter) {
        NodeToString.appendYogaValueIfNotDefault(json.getAsJsonObject("style"), key + "-left", valueGetter.getValue(node, YogaEdge.LEFT), valueGetter.getValue(defaultNode, YogaEdge.LEFT));
        NodeToString.appendYogaValueIfNotDefault(json.getAsJsonObject("style"), key + "-right", valueGetter.getValue(node, YogaEdge.RIGHT), valueGetter.getValue(defaultNode, YogaEdge.RIGHT));
        NodeToString.appendYogaValueIfNotDefault(json.getAsJsonObject("style"), key + "-top", valueGetter.getValue(node, YogaEdge.TOP), valueGetter.getValue(defaultNode, YogaEdge.TOP));
        NodeToString.appendYogaValueIfNotDefault(json.getAsJsonObject("style"), key + "-bottom", valueGetter.getValue(node, YogaEdge.BOTTOM), valueGetter.getValue(defaultNode, YogaEdge.BOTTOM));
        NodeToString.appendYogaValueIfNotDefault(json.getAsJsonObject("style"), key + "-all", valueGetter.getValue(node, YogaEdge.ALL), valueGetter.getValue(defaultNode, YogaEdge.ALL));
        NodeToString.appendYogaValueIfNotDefault(json.getAsJsonObject("style"), key + "-start", valueGetter.getValue(node, YogaEdge.START), valueGetter.getValue(defaultNode, YogaEdge.START));
        NodeToString.appendYogaValueIfNotDefault(json.getAsJsonObject("style"), key + "-end", valueGetter.getValue(node, YogaEdge.END), valueGetter.getValue(defaultNode, YogaEdge.END));
        NodeToString.appendYogaValueIfNotDefault(json.getAsJsonObject("style"), key + "-vertical", valueGetter.getValue(node, YogaEdge.VERTICAL), valueGetter.getValue(defaultNode, YogaEdge.VERTICAL));
        NodeToString.appendYogaValueIfNotDefault(json.getAsJsonObject("style"), key + "-horizontal", valueGetter.getValue(node, YogaEdge.HORIZONTAL), valueGetter.getValue(defaultNode, YogaEdge.HORIZONTAL));
    }

    private static YogaValue borderFloatToYogaValue(YogaNode node, YogaEdge edge) {
        float val = node.getBorder(edge);
        YogaUnit unit = YogaConstants.isUndefined(val) ? YogaUnit.UNDEFINED : YogaUnit.POINT;
        return new YogaValue(val, unit);
    }

    private static void serializeMeasureFuncResults(JsonObject json, List<SerializedMeasureFunc> measureFuncs) {
        JsonArray measureFuncsArray = new JsonArray();
        for (SerializedMeasureFunc measureFunc : measureFuncs) {
            JsonObject measureFuncObj = new JsonObject();
            measureFuncObj.addProperty("width", (Number)Float.valueOf(measureFunc.inputWidth()));
            measureFuncObj.addProperty("width-mode", measureFunc.widthMode().toString());
            measureFuncObj.addProperty("height", (Number)Float.valueOf(measureFunc.inputHeight()));
            measureFuncObj.addProperty("height-mode", measureFunc.heightMode().toString());
            measureFuncObj.addProperty("output-width", (Number)Float.valueOf(measureFunc.outputWidth()));
            measureFuncObj.addProperty("output-height", (Number)Float.valueOf(measureFunc.outputHeight()));
            measureFuncObj.addProperty("duration-ns", (Number)measureFunc.durationNs());
            measureFuncsArray.add((JsonElement)measureFuncObj);
        }
        json.add("measure-funcs", (JsonElement)measureFuncsArray);
    }

    private static void serializeTreeImpl(JsonObject json, Map<YogaNode, List<SerializedMeasureFunc>> nodesToMeasureFuncs, YogaNode node, Set<PrintOptions> options) {
        if (options.contains((Object)PrintOptions.LAYOUT)) {
            JsonObject layoutObj = new JsonObject();
            layoutObj.add("width", NodeToString.toJson(node.getStyle().getDimension(YogaDimension.WIDTH)));
            layoutObj.add("height", NodeToString.toJson(node.getStyle().getDimension(YogaDimension.HEIGHT)));
            layoutObj.add("top", NodeToString.toJson(node.getStyle().getPosition(YogaEdge.TOP)));
            layoutObj.add("left", NodeToString.toJson(node.getStyle().getPosition(YogaEdge.LEFT)));
            layoutObj.add("layout-width", (JsonElement)new JsonPrimitive((Number)Float.valueOf(node.getLayoutWidth())));
            layoutObj.add("layout-height", (JsonElement)new JsonPrimitive((Number)Float.valueOf(node.getLayoutWidth())));
            layoutObj.add("layout-top", (JsonElement)new JsonPrimitive((Number)Float.valueOf(node.getLayoutX())));
            layoutObj.add("layout-left", (JsonElement)new JsonPrimitive((Number)Float.valueOf(node.getLayoutY())));
            json.add("layout", (JsonElement)layoutObj);
        }
        YogaNode defaultNode = new YogaNode();
        if (options.contains((Object)PrintOptions.STYLE)) {
            if (!json.has("style")) {
                json.add("style", (JsonElement)new JsonObject());
            }
            NodeToString.appendEnumValueIfNotDefault(json.getAsJsonObject("style"), "flex-direction", node.getFlexDirection().toString(), defaultNode.getFlexDirection().toString());
            NodeToString.appendEnumValueIfNotDefault(json.getAsJsonObject("style"), "justify-content", node.getJustifyContent().toString(), defaultNode.getJustifyContent().toString());
            NodeToString.appendEnumValueIfNotDefault(json.getAsJsonObject("style"), "align-items", node.getAlignItems().toString(), defaultNode.getAlignItems().toString());
            NodeToString.appendEnumValueIfNotDefault(json.getAsJsonObject("style"), "align-content", node.getAlignContent().toString(), defaultNode.getAlignContent().toString());
            NodeToString.appendEnumValueIfNotDefault(json.getAsJsonObject("style"), "align-self", node.getAlignSelf().toString(), defaultNode.getAlignSelf().toString());
            NodeToString.appendEnumValueIfNotDefault(json.getAsJsonObject("style"), "flex-wrap", node.getStyle().getFlexWrap().toString(), defaultNode.getStyle().getFlexWrap().toString());
            NodeToString.appendEnumValueIfNotDefault(json.getAsJsonObject("style"), "overflow", node.getOverflow().toString(), defaultNode.getOverflow().toString());
            NodeToString.appendEnumValueIfNotDefault(json.getAsJsonObject("style"), "display", node.getDisplay().toString(), defaultNode.getDisplay().toString());
            NodeToString.appendEnumValueIfNotDefault(json.getAsJsonObject("style"), "position-type", node.getPositionType().toString(), defaultNode.getPositionType().toString());
            NodeToString.appendFloatIfNotDefault(json.getAsJsonObject("style"), "flex-grow", node.getFlexGrow(), defaultNode.getFlexGrow());
            NodeToString.appendFloatIfNotDefault(json.getAsJsonObject("style"), "flex-shrink", node.getFlexShrink(), defaultNode.getFlexShrink());
            NodeToString.appendFloatIfNotDefault(json.getAsJsonObject("style"), "flex", node.getFlex(), defaultNode.getFlex());
            NodeToString.appendYogaValueIfNotDefault(json.getAsJsonObject("style"), "flex-basis", node.getFlexBasis(), defaultNode.getFlexBasis());
            NodeToString.appendEdges(json, "margin", node, defaultNode, YogaNode::getMargin);
            NodeToString.appendEdges(json, "padding", node, defaultNode, YogaNode::getPadding);
            NodeToString.appendEdges(json, "border", node, defaultNode, NodeToString::borderFloatToYogaValue);
            EdgeValueGetter positionGetter = (n, e) -> n.getStyle().getPosition(e).asYogaValue();
            NodeToString.appendEdges(json, "position", node, defaultNode, positionGetter);
            NodeToString.appendYogaValueIfNotDefault(json.getAsJsonObject("style"), "gap", node.getGap(YogaGutter.ALL), defaultNode.getGap(YogaGutter.ALL));
            NodeToString.appendYogaValueIfNotDefault(json.getAsJsonObject("style"), "column-gap", node.getGap(YogaGutter.COLUMN), defaultNode.getGap(YogaGutter.COLUMN));
            NodeToString.appendYogaValueIfNotDefault(json.getAsJsonObject("style"), "row-gap", node.getGap(YogaGutter.ROW), defaultNode.getGap(YogaGutter.ROW));
            NodeToString.appendYogaValueIfNotDefault(json.getAsJsonObject("style"), "width", node.getStyle().getDimension(YogaDimension.WIDTH).asYogaValue(), defaultNode.getStyle().getDimension(YogaDimension.WIDTH).asYogaValue());
            NodeToString.appendYogaValueIfNotDefault(json.getAsJsonObject("style"), "height", node.getStyle().getDimension(YogaDimension.HEIGHT).asYogaValue(), defaultNode.getStyle().getDimension(YogaDimension.HEIGHT).asYogaValue());
            NodeToString.appendYogaValueIfNotDefault(json.getAsJsonObject("style"), "max-width", node.getMaxWidth(), defaultNode.getMaxWidth());
            NodeToString.appendYogaValueIfNotDefault(json.getAsJsonObject("style"), "max-height", node.getMaxHeight(), defaultNode.getMaxHeight());
            NodeToString.appendYogaValueIfNotDefault(json.getAsJsonObject("style"), "min-width", node.getMinWidth(), defaultNode.getMinWidth());
            NodeToString.appendYogaValueIfNotDefault(json.getAsJsonObject("style"), "min-height", node.getMinHeight(), defaultNode.getMinHeight());
        }
        if (options.contains((Object)PrintOptions.CONFIG)) {
            JsonObject configObj = new JsonObject();
            YogaConfig yogaConfig = node.getConfig();
            YogaConfig defaultConfig = YogaConfig.getDefault();
            NodeToString.appendBoolIfNotDefault(configObj, "use-web-defaults", yogaConfig.useWebDefaults(), defaultConfig.useWebDefaults());
            NodeToString.appendFloatIfNotDefault(configObj, "point-scale-factor", yogaConfig.getPointScaleFactor(), defaultConfig.getPointScaleFactor());
            EnumSet<YogaErrata> errata = yogaConfig.getErrata();
            EnumSet<YogaErrata> defaultErrata = defaultConfig.getErrata();
            if (errata.equals(YogaErrata.NONE) || errata.equals(YogaErrata.ALL) || errata.equals(YogaErrata.CLASSIC)) {
                NodeToString.appendEnumValueIfNotDefault(configObj, "errata", NodeToString.errataToString(errata), NodeToString.errataToString(defaultErrata));
            }
            if (yogaConfig.isExperimentalFeatureEnabled(YogaExperimentalFeature.WEB_FLEX_BASIS) != defaultConfig.isExperimentalFeatureEnabled(YogaExperimentalFeature.WEB_FLEX_BASIS)) {
                JsonArray featuresArray = new JsonArray();
                featuresArray.add(YogaExperimentalFeature.WEB_FLEX_BASIS.toString());
                configObj.add("experimental-features", (JsonElement)featuresArray);
            }
            if (node.getDebugName() != null) {
                json.addProperty("name", node.getDebugName());
            }
            json.add("config", (JsonElement)configObj);
        }
        if (options.contains((Object)PrintOptions.NODE)) {
            JsonObject nodeObj = new JsonObject();
            NodeToString.appendBoolIfNotDefault(nodeObj, "always-forms-containing-block", node.alwaysFormsContainingBlock(), defaultNode.alwaysFormsContainingBlock());
            if (node.isMeasureDefined()) {
                List<SerializedMeasureFunc> measureFuncs = nodesToMeasureFuncs.get(node);
                if (measureFuncs == null) {
                    nodeObj.add("measure-funcs", (JsonElement)new JsonArray());
                } else {
                    NodeToString.serializeMeasureFuncResults(nodeObj, measureFuncs);
                }
            }
            json.add("node", (JsonElement)nodeObj);
        }
        int childCount = node.getChildCount();
        if (options.contains((Object)PrintOptions.CHILDREN) && childCount > 0) {
            JsonArray childrenArray = new JsonArray();
            for (int i = 0; i < childCount; ++i) {
                JsonObject childObj = new JsonObject();
                NodeToString.serializeTreeImpl(childObj, nodesToMeasureFuncs, node.getChild(i), options);
                childrenArray.add((JsonElement)childObj);
            }
            json.add("children", (JsonElement)childrenArray);
        }
    }

    private static String errataToString(Set<YogaErrata> errata) {
        if (errata.equals(YogaErrata.ALL)) {
            return "all";
        }
        if (errata.equals(YogaErrata.CLASSIC)) {
            return "classic";
        }
        if (errata.equals(YogaErrata.NONE)) {
            return "none";
        }
        return errata.toString();
    }

    private static JsonElement toJson(StyleLength length) {
        return new JsonPrimitive(length.asYogaValue().toString());
    }

    private static JsonElement toJson(StyleSizeLength length) {
        return new JsonPrimitive(length.toString());
    }

    public static void serializeTree(JsonObject json, Map<YogaNode, List<SerializedMeasureFunc>> nodesToMeasureFuncs, YogaNode node, Set<PrintOptions> options) {
        JsonObject treeObj = new JsonObject();
        json.add("tree", (JsonElement)treeObj);
        NodeToString.serializeTreeImpl(treeObj, nodesToMeasureFuncs, node, options);
    }

    public static void serializeLayoutInputs(JsonObject json, float availableWidth, float availableHeight, YogaDirection ownerDirection) {
        JsonObject layoutInputsObj = new JsonObject();
        layoutInputsObj.addProperty("available-width", (Number)Float.valueOf(availableWidth));
        layoutInputsObj.addProperty("available-height", (Number)Float.valueOf(availableHeight));
        layoutInputsObj.addProperty("owner-direction", ownerDirection.toString());
        json.add("layout-inputs", (JsonElement)layoutInputsObj);
    }

    @FunctionalInterface
    private static interface EdgeValueGetter {
        public YogaValue getValue(YogaNode var1, YogaEdge var2);
    }
}

