/*
 * Decompiled with CFR 0.152.
 */
package com.samxel.villagerexplorer;

import com.samxel.villagerexplorer.VillagerInfoScreen;
import com.samxel.villagerexplorer.VillagerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_10017;
import net.minecraft.class_10042;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_3730;
import net.minecraft.class_3852;
import net.minecraft.class_437;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class VillagerExplorerScreen
extends class_437 {
    private final List<String> allVillagers = List.of("Farmer", "Librarian", "Cleric", "Armorer", "Butcher", "Cartographer", "Fisherman", "Fletcher", "Leatherworker", "Mason", "Shepherd", "Toolsmith", "Weaponsmith");
    private final int windowWidth = 420;
    private final int windowHeight = 340;
    private final int tileSize = 90;
    private final int tileSpacing = 18;
    private final int tilesPerRow = 3;
    private final int tileAreaTop = 140;
    private final int tileAreaBottom = 320;
    private final List<VillagerTile> visibleTiles = new ArrayList<VillagerTile>();
    private class_342 searchField;
    private List<String> filteredVillagers = new ArrayList<String>();
    private int scrollOffset = 0;
    private int maxScroll = 0;

    public VillagerExplorerScreen() {
        super(class_2561.method_30163((String)"Villager Explorer"));
    }

    public static void renderVillagerInBox(class_332 drawer, int x1, int y1, int x2, int y2, float scale, Vector3f translation, float yaw, float pitch, @Nullable Quaternionf overrideCameraAngle, class_1309 entity) {
        class_898 entityRenderManager = class_310.method_1551().method_1561();
        class_897 entityRenderer = entityRenderManager.method_3953((class_1297)entity);
        class_10017 entityRenderState = entityRenderer.method_62425((class_1297)entity, 1.0f);
        if (entityRenderState instanceof class_10042) {
            class_10042 state = (class_10042)entityRenderState;
            state.field_53446 = yaw;
            state.field_53448 = pitch;
            state.field_53447 = yaw;
        }
        entityRenderState.field_61820 = 0xF000F0;
        entityRenderState.field_58169 = null;
        entityRenderState.field_61823.clear();
        entityRenderState.field_61821 = 0;
        Quaternionf rotation = new Quaternionf().rotateZ((float)Math.PI).rotateY((float)Math.toRadians(180.0f - yaw)).rotateX((float)Math.toRadians(pitch));
        drawer.method_70856(entityRenderState, scale, translation, rotation, overrideCameraAngle, x1, y1, x2, y2);
    }

    protected void method_25426() {
        int centerX = this.field_22789 / 2;
        int windowX = centerX - 210;
        int windowY = this.field_22790 / 2 - 170;
        this.searchField = new class_342(this.field_22793, windowX + 20, windowY + 85, 380, 20, class_2561.method_30163((String)"Search Villager"));
        this.searchField.method_1863(this::updateFilter);
        this.method_37063((class_364)this.searchField);
        this.method_48265((class_364)this.searchField);
        this.updateFilter("");
    }

    private void updateFilter(String filter) {
        this.filteredVillagers = this.allVillagers.stream().filter(name -> name.toLowerCase().contains(filter.toLowerCase())).collect(Collectors.toList());
        this.updateScroll();
    }

    private void updateScroll() {
        int rows = (int)Math.ceil((float)this.filteredVillagers.size() / 3.0f);
        int visibleRows = 1;
        this.maxScroll = Math.max(0, rows - visibleRows);
        this.scrollOffset = Math.min(this.scrollOffset, this.maxScroll);
        this.scrollOffset = Math.max(this.scrollOffset, 0);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        double amount;
        double d = amount = verticalAmount != 0.0 ? verticalAmount : horizontalAmount;
        if (this.maxScroll > 0 && amount != 0.0) {
            this.scrollOffset -= (int)Math.signum(amount);
            if (this.scrollOffset < 0) {
                this.scrollOffset = 0;
            } else if (this.scrollOffset > this.maxScroll) {
                this.scrollOffset = this.maxScroll;
            }
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25404(class_11908 input) {
        if (this.searchField.method_25404(input)) {
            return true;
        }
        if (input.comp_4795() == 264 && this.scrollOffset < this.maxScroll) {
            ++this.scrollOffset;
            return true;
        }
        if (input.comp_4795() == 265 && this.scrollOffset > 0) {
            --this.scrollOffset;
            return true;
        }
        return super.method_25404(input);
    }

    public boolean method_25400(class_11905 input) {
        if (this.searchField.method_25400(input)) {
            return true;
        }
        return super.method_25400(input);
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (super.method_25402(click, doubled)) {
            return true;
        }
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        for (VillagerTile tile : this.visibleTiles) {
            if (!tile.contains(mouseX, mouseY)) continue;
            class_310.method_1551().method_1507((class_437)new VillagerInfoScreen(tile.name));
            return true;
        }
        return false;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int windowX = centerX - 210;
        int windowY = centerY - 170;
        this.visibleTiles.clear();
        context.method_25294(windowX, windowY, windowX + 420, windowY + 340, -870178270);
        context.method_73198(windowX, windowY, 420, 340, -16777216);
        String titleText = "Villager Explorer";
        int titleWidth = this.field_22793.method_1727(titleText);
        int titleX = windowX + (420 - titleWidth) / 2;
        int titleY = windowY + 55;
        context.method_51439(this.field_22793, class_2561.method_30163((String)titleText), titleX, titleY, -1, false);
        int startY = windowY + 140;
        int totalTiles = this.filteredVillagers.size();
        int rows = (int)Math.ceil((float)totalTiles / 3.0f);
        int visibleRows = 1;
        int firstRow = this.scrollOffset;
        int lastRow = Math.min(rows, firstRow + visibleRows);
        for (int row = firstRow; row < lastRow; ++row) {
            int idx;
            int tilesInThisRow = Math.min(3, totalTiles - row * 3);
            int rowWidth = tilesInThisRow * 90 + (tilesInThisRow - 1) * 18;
            int rowStartX = windowX + (420 - rowWidth) / 2;
            for (int col = 0; col < tilesInThisRow && (idx = row * 3 + col) < totalTiles; ++col) {
                class_1646 villager;
                int x = rowStartX + col * 108;
                int y = startY + (row - firstRow) * 108;
                context.method_25294(x, y, x + 90, y + 90, 0x10FFFFFF);
                context.method_73198(x, y, 90, 90, -1);
                String villagerName = this.filteredVillagers.get(idx);
                class_310 client = class_310.method_1551();
                if (client.field_1687 == null || (villager = (class_1646)class_1299.field_6077.method_5883((class_1937)client.field_1687, class_3730.field_16461)) == null) continue;
                class_3852 prof = VillagerUtils.getProfessionByName(villagerName);
                class_6880 entry = class_7923.field_41195.method_47983((Object)prof);
                villager.method_7195(villager.method_7231().method_16921(entry));
                int boxHalf = 28;
                int x1 = x + 45 - boxHalf;
                int y1 = y + 10;
                int x2 = x + 45 + boxHalf;
                int y2 = y + 10 + boxHalf * 2;
                float yaw = 0.0f;
                float pitch = -3.0f;
                VillagerExplorerScreen.renderVillagerInBox(context, x1, y1, x2, y2, 30.0f, new Vector3f(0.0f, 1.0f, 0.0f), yaw, pitch, null, (class_1309)villager);
                int nWidth = this.field_22793.method_1727(villagerName);
                int NameTextX = x + (90 - nWidth) / 2;
                context.method_51439(this.field_22793, class_2561.method_30163((String)villagerName), NameTextX, y + 90 - 18, -1, false);
                this.visibleTiles.add(new VillagerTile(x, y, 90, 90, idx, villagerName));
            }
        }
        if (this.maxScroll > 0) {
            int barArea = 180;
            int barHeight = Math.max(20, (int)((float)visibleRows / (float)rows * (float)barArea));
            int barY = windowY + 140 + (int)((float)this.scrollOffset / (float)this.maxScroll * (float)(barArea - barHeight));
            int barX = windowX + 420 - 8;
            context.method_25294(barX, windowY + 140, barX + 6, windowY + 320, 0x22000000);
            context.method_25294(barX, barY, barX + 6, barY + barHeight, -7829368);
        }
        this.searchField.method_25394(context, mouseX, mouseY, delta);
    }

    private static class VillagerTile {
        int x;
        int y;
        int width;
        int height;
        int index;
        String name;

        VillagerTile(int x, int y, int width, int height, int index, String name) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.index = index;
            this.name = name;
        }

        boolean contains(double mouseX, double mouseY) {
            return mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
        }
    }
}

