/*
 * Decompiled with CFR 0.152.
 */
package com.samxel.villagerexplorer;

import com.samxel.villagerexplorer.VillagerTrades;
import com.samxel.villagerexplorer.VillagerUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3730;
import net.minecraft.class_3852;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class VillagerInfoScreen
extends class_437 {
    private static final int TRADES_VISIBLE = 7;
    private final int windowWidth = 420;
    private final int windowHeight = 340;
    private final String villagerName;
    private int tradeScrollOffset = 0;

    public VillagerInfoScreen(String villagerName) {
        super(class_2561.method_30163((String)"Villager Info"));
        this.villagerName = villagerName;
    }

    protected void method_25426() {
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        double amount;
        List<VillagerTrades.Trade> trades = VillagerTrades.getTradesForVillager(this.villagerName);
        int maxOffset = Math.max(0, trades.size() - 7);
        double d = amount = verticalAmount != 0.0 ? verticalAmount : horizontalAmount;
        if (amount < 0.0) {
            this.tradeScrollOffset = Math.min(this.tradeScrollOffset + 1, maxOffset);
        } else if (amount > 0.0) {
            this.tradeScrollOffset = Math.max(this.tradeScrollOffset - 1, 0);
        }
        return true;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        class_1799 resultStack;
        class_1646 villager;
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int windowX = centerX - 210;
        int windowY = centerY - 170;
        context.method_25294(windowX, windowY, windowX + 420, windowY + 340, -870178270);
        context.method_73198(windowX, windowY, 420, 340, -16777216);
        context.method_51439(this.field_22793, class_2561.method_30163((String)this.villagerName), windowX + 30, windowY + 70, -1, false);
        int villagerX = windowX + 420 - 70;
        int villagerY = windowY + 150;
        int villagerScale = 45;
        class_310 client = class_310.method_1551();
        if (client.field_1687 != null && (villager = (class_1646)class_1299.field_6077.method_5883((class_1937)client.field_1687, class_3730.field_16461)) != null) {
            class_3852 prof = VillagerUtils.getProfessionByName(this.villagerName);
            class_6880 profEntry = class_7923.field_41195.method_47983((Object)prof);
            villager.method_7195(villager.method_7231().method_16921(profEntry));
            int x1 = villagerX - 25;
            int y1 = villagerY - 190;
            int x2 = villagerX + 25;
            int y2 = villagerY + 90;
            float mouseYaw = (float)Math.atan((float)(villagerX - mouseX) / 40.0f);
            float mousePitch = (float)Math.atan((float)(villagerY - mouseY) / 40.0f);
            villager.method_5636(180.0f + mouseYaw * 20.0f);
            villager.method_5847(180.0f + mouseYaw * 40.0f);
            villager.method_36457(mousePitch * 20.0f);
            villager.field_6220 = villager.method_73188();
            villager.field_6259 = villager.method_5791();
            villager.field_6004 = villager.method_36455();
            class_490.method_2486((class_332)context, (int)x1, (int)y1, (int)x2, (int)y2, (int)villagerScale, (float)1.0f, (float)mouseX, (float)mouseY, (class_1309)villager);
        }
        List<VillagerTrades.Trade> trades = VillagerTrades.getTradesForVillager(this.villagerName);
        int tableStartX = windowX + 50;
        int tableStartY = windowY + 110;
        int levelWidth = 60;
        int itemSlotSize = 18;
        int itemSpacing = 4;
        int rowHeight = itemSlotSize + 6;
        int start = this.tradeScrollOffset;
        int end = Math.min(trades.size(), start + 7);
        String lastLevel = "";
        for (int row = start; row < end; ++row) {
            VillagerTrades.Trade trade = trades.get(row);
            int y = tableStartY + (row - start) * rowHeight;
            if (!trade.level().equals(lastLevel)) {
                context.method_51439(this.field_22793, class_2561.method_30163((String)trade.level()), tableStartX - 5, y + 4, -1, false);
                lastLevel = trade.level();
            }
            for (int i = 0; i < trade.wanted().size(); ++i) {
                int slotX = tableStartX + levelWidth + i * (itemSlotSize + itemSpacing);
                class_1799 stack = trade.wanted().get(i);
                context.method_25294(slotX, y, slotX + itemSlotSize, y + itemSlotSize, -12303292);
                context.method_73198(slotX, y, itemSlotSize, itemSlotSize, -16777216);
                context.method_51427(stack, slotX + 1, y + 1);
                if (stack.method_7947() > 1) {
                    context.method_51439(this.field_22793, class_2561.method_30163((String)Integer.toString(stack.method_7947())), slotX + 2, y + itemSlotSize - 8, -1, true);
                }
                if (mouseX < slotX || mouseX >= slotX + itemSlotSize || mouseY < y || mouseY >= y + itemSlotSize) continue;
                context.method_51446(this.field_22793, stack, slotX, y);
            }
            int arrowX = tableStartX + levelWidth + trade.wanted().size() * (itemSlotSize + itemSpacing) + 2;
            context.method_51439(this.field_22793, class_2561.method_30163((String)"\u2192"), arrowX, y + 5, -1, false);
            for (int i = 0; i < trade.given().size(); ++i) {
                int slotX = arrowX + 15 + i * (itemSlotSize + itemSpacing);
                class_1799 stack = trade.given().get(i);
                context.method_25294(slotX, y, slotX + itemSlotSize, y + itemSlotSize, -12303292);
                context.method_73198(slotX, y, itemSlotSize, itemSlotSize, -16777216);
                context.method_51427(stack, slotX + 1, y + 1);
                if (stack.method_7947() > 1) {
                    context.method_51439(this.field_22793, class_2561.method_30163((String)Integer.toString(stack.method_7947())), slotX + 2, y + itemSlotSize - 8, -1, true);
                }
                if (mouseX < slotX || mouseX >= slotX + itemSlotSize || mouseY < y || mouseY >= y + itemSlotSize) continue;
                context.method_51446(this.field_22793, stack, slotX, y);
            }
        }
        if (trades.size() > 7) {
            int barArea = 7 * rowHeight;
            int barHeight = (int)(7.0f / (float)trades.size() * (float)barArea);
            int barY = tableStartY + (int)((float)this.tradeScrollOffset / (float)trades.size() * (float)barArea);
            int barX = tableStartX + 230;
            context.method_25294(barX, tableStartY, barX + 6, tableStartY + barArea, -14540254);
            context.method_25294(barX, barY, barX + 6, barY + barHeight, -7829368);
        }
        int gridSize = 18;
        int gridX = windowX + 420 - 120;
        int gridY = windowY + 340 - gridSize * 3 - 60;
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                int slotX = gridX + c * gridSize;
                int slotY = gridY + r * gridSize;
                context.method_25294(slotX, slotY, slotX + gridSize, slotY + gridSize, -12303292);
                context.method_73198(slotX, slotY, gridSize, gridSize, -16777216);
            }
        }
        List<GridItem> gridItems = this.getJobBlockRecipe(this.villagerName);
        for (GridItem gridItem : gridItems) {
            int slotX = gridX + gridItem.col * gridSize;
            int slotY = gridY + gridItem.row * gridSize;
            context.method_51427(gridItem.stack, slotX + 1, slotY + 1);
            if (mouseX < slotX || mouseX >= slotX + gridSize || mouseY < slotY || mouseY >= slotY + gridSize) continue;
            context.method_51446(this.field_22793, gridItem.stack, slotX, slotY);
        }
        int arrowX = gridX + gridSize * 4;
        int arrowY = gridY + gridSize;
        context.method_51439(this.field_22793, class_2561.method_30163((String)"\u2192"), arrowX - 10, arrowY + 5, -1, false);
        switch (this.villagerName.toLowerCase()) {
            case "farmer": {
                class_1799 class_17992 = new class_1799((class_1935)class_1802.field_17530);
                break;
            }
            case "librarian": {
                class_1799 class_17992 = new class_1799((class_1935)class_1802.field_16312);
                break;
            }
            case "cleric": {
                class_1799 class_17992 = new class_1799((class_1935)class_1802.field_8740);
                break;
            }
            case "armorer": {
                class_1799 class_17992 = new class_1799((class_1935)class_1802.field_16306);
                break;
            }
            case "butcher": {
                class_1799 class_17992 = new class_1799((class_1935)class_1802.field_16309);
                break;
            }
            case "cartographer": {
                class_1799 class_17992 = new class_1799((class_1935)class_1802.field_16313);
                break;
            }
            case "fisherman": {
                class_1799 class_17992 = new class_1799((class_1935)class_1802.field_16307);
                break;
            }
            case "fletcher": {
                class_1799 class_17992 = new class_1799((class_1935)class_1802.field_16310);
                break;
            }
            case "leatherworker": {
                class_1799 class_17992 = new class_1799((class_1935)class_1802.field_8638);
                break;
            }
            case "mason": {
                class_1799 class_17992 = new class_1799((class_1935)class_1802.field_16305);
                break;
            }
            case "shepherd": {
                class_1799 class_17992 = new class_1799((class_1935)class_1802.field_8772);
                break;
            }
            case "toolsmith": {
                class_1799 class_17992 = new class_1799((class_1935)class_1802.field_16308);
                break;
            }
            case "weaponsmith": {
                class_1799 class_17992 = new class_1799((class_1935)class_1802.field_16311);
                break;
            }
            default: {
                class_1799 class_17992 = resultStack = class_1799.field_8037;
            }
        }
        if (!resultStack.method_7960()) {
            int resultX = gridX + gridSize * 4 + 5;
            int resultY = gridY + gridSize;
            context.method_51427(resultStack, resultX, resultY);
            if (mouseX >= resultX && mouseX < resultX + gridSize && mouseY >= resultY && mouseY < resultY + gridSize) {
                context.method_51446(this.field_22793, resultStack, resultX, resultY);
            }
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private List<GridItem> getJobBlockRecipe(String profession) {
        ArrayList<GridItem> items = new ArrayList<GridItem>();
        switch (profession.toLowerCase()) {
            case "farmer": {
                class_1799 slab = new class_1799((class_1935)class_1802.field_8320);
                items.add(new GridItem(slab, 0, 0));
                items.add(new GridItem(slab, 0, 2));
                items.add(new GridItem(slab, 1, 0));
                items.add(new GridItem(slab, 1, 2));
                items.add(new GridItem(slab, 2, 0));
                items.add(new GridItem(slab, 2, 1));
                items.add(new GridItem(slab, 2, 2));
                break;
            }
            case "librarian": {
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8320), 0, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8320), 0, 1));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8320), 0, 2));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8536), 1, 1));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8320), 2, 1));
                break;
            }
            case "cleric": {
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8894), 0, 1));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_20412), 1, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_20412), 1, 1));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_20412), 1, 2));
                break;
            }
            case "armorer": {
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8620), 0, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8620), 0, 1));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8620), 0, 2));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8620), 1, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8732), 1, 1));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8620), 1, 2));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_20389), 2, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_20389), 2, 1));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_20389), 2, 2));
                break;
            }
            case "butcher": {
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8583), 0, 1));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8583), 1, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8732), 1, 1));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8583), 1, 2));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8583), 2, 1));
                break;
            }
            case "cartographer": {
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8407), 0, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8407), 0, 1));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8118), 1, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8118), 1, 1));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8118), 2, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8118), 2, 1));
                break;
            }
            case "fisherman": {
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8118), 0, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8320), 0, 1));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8118), 0, 2));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8118), 1, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8118), 1, 2));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8118), 2, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8320), 2, 1));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8118), 2, 2));
                break;
            }
            case "fletcher": {
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8145), 0, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8145), 0, 1));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8118), 1, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8118), 1, 1));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8118), 2, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8118), 2, 1));
                break;
            }
            case "leatherworker": {
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8620), 0, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8620), 0, 2));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8620), 1, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8620), 1, 2));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8620), 2, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8620), 2, 1));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8620), 2, 2));
                break;
            }
            case "mason": {
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8620), 0, 1));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_20391), 1, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_20391), 1, 1));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_20391), 1, 2));
                break;
            }
            case "shepherd": {
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8276), 0, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8276), 0, 1));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8118), 1, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8118), 1, 1));
                break;
            }
            case "toolsmith": {
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8620), 0, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8620), 0, 1));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8118), 1, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8118), 1, 1));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8118), 2, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8118), 2, 1));
                break;
            }
            case "weaponsmith": {
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8600), 0, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8595), 0, 1));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8600), 0, 2));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8118), 1, 0));
                items.add(new GridItem(new class_1799((class_1935)class_1802.field_8118), 1, 2));
                break;
            }
        }
        return items;
    }

    public static class GridItem {
        public final class_1799 stack;
        public final int row;
        public final int col;

        public GridItem(class_1799 stack, int row, int col) {
            this.stack = stack;
            this.row = row;
            this.col = col;
        }
    }
}

