/*
 * Decompiled with CFR 0.152.
 */
package walksy.shieldfixes.manager;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import walksy.shieldfixes.ShieldFixes;
import walksy.shieldfixes.config.Config;

public class EnvironmentEffectShieldManager {
    public void onExplosion(WorldExplosion explosion) {
        if (!explosion.world.field_9236 || class_310.method_1551().field_1724 == null) {
            return;
        }
        for (class_1657 affectedPlayer : EnvironmentEffectShieldManager.getNearPlayers(explosion)) {
            double distance;
            if (!affectedPlayer.method_5805() || !((distance = Math.sqrt(affectedPlayer.method_5707(explosion.pos))) < (double)explosion.getMaxDistance()) || !ShieldFixes.getShieldStateManager().isUsingShield(affectedPlayer, explosion.pos(), Config.factorDelay)) continue;
            EnvironmentEffectShieldManager.play((class_1309)affectedPlayer, class_3417.field_15150);
        }
    }

    public void onDisable(class_1309 livingEntity) {
        EnvironmentEffectShieldManager.play(livingEntity, class_3417.field_15239);
    }

    public void onAttack(class_1657 livingEntity) {
        if (ShieldFixes.getShieldStateManager().isUsingShield(livingEntity, class_310.method_1551().field_1724.method_19538(), true)) {
            EnvironmentEffectShieldManager.play((class_1309)livingEntity, class_3417.field_15150);
        }
    }

    public static List<class_1657> getNearPlayers(WorldExplosion explosion) {
        return explosion.world().method_8390(class_1657.class, explosion.getBoundingBox(), Objects::nonNull);
    }

    public static void play(class_1309 entity, class_3414 soundEvent) {
        if (class_310.method_1551().field_1687 == null) {
            return;
        }
        class_310.method_1551().field_1687.method_8486(entity.method_23317(), entity.method_23318(), entity.method_23321(), soundEvent, entity.method_5634(), 1.0f, 0.8f + class_310.method_1551().field_1687.field_9229.method_43057() * 0.4f, false);
    }

    public record WorldExplosion(class_243 pos, class_1937 world, float power) {
        public float getMaxDistance() {
            return this.power * 2.0f;
        }

        public class_238 getBoundingBox() {
            float maxDistance = this.getMaxDistance();
            double x = this.pos.method_10216();
            double y = this.pos.method_10214();
            double z = this.pos.method_10215();
            int x1 = class_3532.method_15357((double)(x - (double)maxDistance - 1.0));
            int x2 = class_3532.method_15357((double)(x + (double)maxDistance + 1.0));
            int y1 = class_3532.method_15357((double)(y - (double)maxDistance - 1.0));
            int y2 = class_3532.method_15357((double)(y + (double)maxDistance + 1.0));
            int z1 = class_3532.method_15357((double)(z - (double)maxDistance - 1.0));
            int z2 = class_3532.method_15357((double)(z + (double)maxDistance + 1.0));
            return new class_238((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
        }
    }
}

