/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.firefront.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.firefront.client.model.Modelblackcat;
import net.mcreator.firefront.client.model.animations.blackcatAnimation;
import net.mcreator.firefront.entity.BlackCatEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class BlackCatRenderer
extends MobRenderer<BlackCatEntity, Modelblackcat<BlackCatEntity>> {
    public BlackCatRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelblackcat.LAYER_LOCATION)), 0.3f);
    }

    protected void scale(BlackCatEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(BlackCatEntity entity) {
        return ResourceLocation.parse((String)("firefront:textures/entities/" + entity.getTexture() + ".png"));
    }

    private static final class AnimatedModel
    extends Modelblackcat<BlackCatEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<BlackCatEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(BlackCatEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(blackcatAnimation.walk, limbSwing, limbSwingAmount, 1.0f, 1.0f);
                this.animate(entity.animationState1, blackcatAnimation.sprint, ageInTicks, 1.0f);
                this.animate(entity.animationState2, blackcatAnimation.idle, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(BlackCatEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

