/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.firefront.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.firefront.client.model.ModelDuende;
import net.mcreator.firefront.client.model.animations.duendeAnimation;
import net.mcreator.firefront.entity.DuendeEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class DuendeRenderer
extends MobRenderer<DuendeEntity, ModelDuende<DuendeEntity>> {
    public DuendeRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelDuende.LAYER_LOCATION)), 0.3f);
    }

    protected void scale(DuendeEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(1.08f, 1.08f, 1.08f);
    }

    public ResourceLocation getTextureLocation(DuendeEntity entity) {
        return ResourceLocation.parse((String)("firefront:textures/entities/" + entity.getTexture() + ".png"));
    }

    private static final class AnimatedModel
    extends ModelDuende<DuendeEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<DuendeEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(DuendeEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(duendeAnimation.walk, limbSwing, limbSwingAmount, 1.2f, 1.0f);
                this.animate(entity.animationState1, duendeAnimation.idle, ageInTicks, 1.0f);
                this.animate(entity.animationState2, duendeAnimation.attack, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(DuendeEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

