/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.firefront.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.firefront.client.model.ModelThelyphonida;
import net.mcreator.firefront.client.model.animations.ThelyphonidaAnimation;
import net.mcreator.firefront.entity.ThelyphonidaEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ThelyphonidaRenderer
extends MobRenderer<ThelyphonidaEntity, ModelThelyphonida<ThelyphonidaEntity>> {
    public ThelyphonidaRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelThelyphonida.LAYER_LOCATION)), 0.8f);
    }

    protected void scale(ThelyphonidaEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(2.5f, 2.5f, 2.5f);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(ThelyphonidaEntity entity) {
        return ResourceLocation.parse((String)("firefront:textures/entities/" + entity.getTexture() + ".png"));
    }

    private static final class AnimatedModel
    extends ModelThelyphonida<ThelyphonidaEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<ThelyphonidaEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(ThelyphonidaEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(ThelyphonidaAnimation.walk, limbSwing, limbSwingAmount, 1.0f, 1.0f);
                this.animate(entity.animationState1, ThelyphonidaAnimation.sprint, ageInTicks, 1.2f);
                this.animate(entity.animationState2, ThelyphonidaAnimation.idle, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(ThelyphonidaEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

