/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.firefront.init;

import net.mcreator.firefront.entity.BlackCatEntity;
import net.mcreator.firefront.entity.DesertknightEntity;
import net.mcreator.firefront.entity.DuendeEntity;
import net.mcreator.firefront.entity.HogEntity;
import net.mcreator.firefront.entity.ThelyphonidaEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class FirefrontModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"firefront");
    public static final DeferredHolder<EntityType<?>, EntityType<HogEntity>> HOG = FirefrontModEntities.register("hog", EntityType.Builder.of(HogEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.0f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<BlackCatEntity>> BLACK_CAT = FirefrontModEntities.register("black_cat", EntityType.Builder.of(BlackCatEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 0.6f));
    public static final DeferredHolder<EntityType<?>, EntityType<DesertknightEntity>> DESERTKNIGHT = FirefrontModEntities.register("desertknight", EntityType.Builder.of(DesertknightEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.0f, 2.3f));
    public static final DeferredHolder<EntityType<?>, EntityType<ThelyphonidaEntity>> THELYPHONIDA = FirefrontModEntities.register("thelyphonida", EntityType.Builder.of(ThelyphonidaEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<DuendeEntity>> DUENDE = FirefrontModEntities.register("duende", EntityType.Builder.of(DuendeEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        HogEntity.init(event);
        BlackCatEntity.init(event);
        DesertknightEntity.init(event);
        ThelyphonidaEntity.init(event);
        DuendeEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)HOG.get(), HogEntity.createAttributes().build());
        event.put((EntityType)BLACK_CAT.get(), BlackCatEntity.createAttributes().build());
        event.put((EntityType)DESERTKNIGHT.get(), DesertknightEntity.createAttributes().build());
        event.put((EntityType)THELYPHONIDA.get(), ThelyphonidaEntity.createAttributes().build());
        event.put((EntityType)DUENDE.get(), DuendeEntity.createAttributes().build());
    }
}

