/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.firefront.init;

import net.mcreator.firefront.init.FirefrontModBlocks;
import net.mcreator.firefront.mixin.NoiseGeneratorSettingsAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;

@EventBusSubscriber
public class FirefrontModSurfaceRules {
    @SubscribeEvent
    public static void init(ServerAboutToStartEvent event) {
        LevelStem levelStem = (LevelStem)event.getServer().registryAccess().registryOrThrow(Registries.LEVEL_STEM).get(LevelStem.END);
        ChunkGenerator chunkGenerator = levelStem.generator();
        boolean hasEndBiomes = chunkGenerator.getBiomeSource().possibleBiomes().stream().anyMatch(biomeHolder -> ((ResourceKey)biomeHolder.unwrapKey().orElseThrow()).location().getNamespace().equals("firefront"));
        if (hasEndBiomes && chunkGenerator instanceof NoiseBasedChunkGenerator) {
            NoiseBasedChunkGenerator generator = (NoiseBasedChunkGenerator)chunkGenerator;
            NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)generator.settings.value();
            FirefrontModSurfaceRules.registerSurfaceRules(ResourceLocation.parse((String)"firefront:kepler_22b"), noiseGeneratorSettings, ((Block)FirefrontModBlocks.KEPLERSTONE.get()).defaultBlockState(), ((Block)FirefrontModBlocks.KEPLERSTONE.get()).defaultBlockState());
        }
    }

    public static void registerSurfaceRules(ResourceLocation biome, NoiseGeneratorSettings noiseGeneratorSettings, BlockState groundBlock, BlockState undergroundBlock) {
        ((NoiseGeneratorSettingsAccess)noiseGeneratorSettings).addSurfaceRule(SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)biome)}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)groundBlock)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)undergroundBlock))})), noiseGeneratorSettings.surfaceRule()}));
    }
}

