/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.advancedmedieval.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class DuskWeedBlock
extends FlowerBlock
implements BonemealableBlock {
    public DuskWeedBlock() {
        super(MobEffects.UNLUCK, 71.0f, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).sound(SoundType.GRASS).instabreak().noCollission().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public boolean mayPlaceOn(BlockState groundState, BlockGetter worldIn, BlockPos pos) {
        return groundState.is(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:sand"))) || groundState.is(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"c:sandstone/blocks"))) || groundState.is(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"c:sandstone/blocks"))) || groundState.is(Blocks.SANDSTONE_WALL) || groundState.is(Blocks.RED_SANDSTONE_WALL) || groundState.is(Blocks.SMOOTH_SANDSTONE_STAIRS) || groundState.is(Blocks.SMOOTH_RED_SANDSTONE_STAIRS) || groundState.is(Blocks.SMOOTH_SANDSTONE_SLAB) || groundState.is(Blocks.SMOOTH_RED_SANDSTONE_SLAB) || groundState.is(Blocks.CUT_SANDSTONE_SLAB) || groundState.is(Blocks.CUT_RED_SANDSTONE_SLAB) || groundState.is(Blocks.SANDSTONE_SLAB) || groundState.is(Blocks.RED_SANDSTONE_SLAB) || groundState.is(Blocks.SANDSTONE_STAIRS) || groundState.is(Blocks.RED_SANDSTONE_STAIRS);
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState groundState = worldIn.getBlockState(blockpos);
        return this.mayPlaceOn(groundState, (BlockGetter)worldIn, blockpos);
    }

    public boolean isValidBonemealTarget(LevelReader worldIn, BlockPos pos, BlockState blockstate) {
        return true;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState blockstate) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState blockstate) {
    }
}

