/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.advancedmedieval.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.advancedmedieval.client.model.Modelamber_crawler;
import net.mcreator.advancedmedieval.client.model.animations.amber_crawlerAnimation;
import net.mcreator.advancedmedieval.entity.AmberCrawlerEntity;
import net.mcreator.advancedmedieval.procedures.AmberCrawlerPlaybackConditionProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class AmberCrawlerRenderer
extends MobRenderer<AmberCrawlerEntity, Modelamber_crawler<AmberCrawlerEntity>> {
    public AmberCrawlerRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelamber_crawler.LAYER_LOCATION)), 1.1f);
    }

    protected void scale(AmberCrawlerEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(AmberCrawlerEntity entity) {
        return ResourceLocation.parse((String)"advanced_medieval:textures/entities/ambercrawlertexture.png");
    }

    private static final class AnimatedModel
    extends Modelamber_crawler<AmberCrawlerEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<AmberCrawlerEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(AmberCrawlerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, amber_crawlerAnimation.idle, ageInTicks, 1.1f);
                if (AmberCrawlerPlaybackConditionProcedure.execute((Entity)entity)) {
                    this.animateWalk(amber_crawlerAnimation.walk, limbSwing, limbSwingAmount, 1.2f, 1.1f);
                }
                this.animate(entity.animationState2, amber_crawlerAnimation.attack, ageInTicks, 1.5f);
                if (AmberCrawlerPlaybackConditionProcedure.execute((Entity)entity)) {
                    this.animateWalk(amber_crawlerAnimation.run, limbSwing, limbSwingAmount, 1.3f, 1.1f);
                }
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(AmberCrawlerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

