/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.advancedmedieval.client.renderer;

import net.mcreator.advancedmedieval.client.model.Modelblight;
import net.mcreator.advancedmedieval.client.model.animations.blightAnimation;
import net.mcreator.advancedmedieval.entity.BlightEntity;
import net.mcreator.advancedmedieval.procedures.BlightPlaybackCondition2Procedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class BlightRenderer
extends MobRenderer<BlightEntity, Modelblight<BlightEntity>> {
    public BlightRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelblight.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(BlightEntity entity) {
        return ResourceLocation.parse((String)"advanced_medieval:textures/entities/blighttexture.png");
    }

    private static final class AnimatedModel
    extends Modelblight<BlightEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<BlightEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(BlightEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, blightAnimation.idle, ageInTicks, 1.0f);
                if (BlightPlaybackCondition2Procedure.execute((Entity)entity)) {
                    this.animateWalk(blightAnimation.walk, limbSwing, limbSwingAmount, 1.0f, 1.1f);
                }
                this.animate(entity.animationState2, blightAnimation.attack, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(BlightEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

