/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.advancedmedieval.client.renderer;

import net.mcreator.advancedmedieval.client.model.Modelbloom;
import net.mcreator.advancedmedieval.client.model.animations.bloomAnimation;
import net.mcreator.advancedmedieval.entity.BloomEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class BloomRenderer
extends MobRenderer<BloomEntity, Modelbloom<BloomEntity>> {
    public BloomRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelbloom.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(BloomEntity entity) {
        return ResourceLocation.parse((String)"advanced_medieval:textures/entities/bloomtexture.png");
    }

    private static final class AnimatedModel
    extends Modelbloom<BloomEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<BloomEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(BloomEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, bloomAnimation.Idle, ageInTicks, 1.2f);
                this.animate(entity.animationState1, bloomAnimation.attack, ageInTicks, 1.0f);
                this.animateWalk(bloomAnimation.walk, limbSwing, limbSwingAmount, 1.1f, 1.1f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(BloomEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

