/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.advancedmedieval.client.renderer;

import net.mcreator.advancedmedieval.client.model.Modelbright;
import net.mcreator.advancedmedieval.client.model.animations.brightAnimation;
import net.mcreator.advancedmedieval.entity.BrightEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class BrightRenderer
extends MobRenderer<BrightEntity, Modelbright<BrightEntity>> {
    public BrightRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelbright.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(BrightEntity entity) {
        return ResourceLocation.parse((String)"advanced_medieval:textures/entities/brighttexture.png");
    }

    private static final class AnimatedModel
    extends Modelbright<BrightEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<BrightEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(BrightEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, brightAnimation.idle, ageInTicks, 1.0f);
                this.animate(entity.animationState1, brightAnimation.attack, ageInTicks, 1.1f);
                this.animateWalk(brightAnimation.walk, limbSwing, limbSwingAmount, 1.2f, 1.1f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(BrightEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

