/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.advancedmedieval.client.renderer;

import net.mcreator.advancedmedieval.client.model.ModelBrumal;
import net.mcreator.advancedmedieval.client.model.animations.BrumalAnimation;
import net.mcreator.advancedmedieval.entity.BrumalEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class BrumalRenderer
extends MobRenderer<BrumalEntity, ModelBrumal<BrumalEntity>> {
    public BrumalRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelBrumal.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(BrumalEntity entity) {
        return ResourceLocation.parse((String)"advanced_medieval:textures/entities/brumaltexture.png");
    }

    private static final class AnimatedModel
    extends ModelBrumal<BrumalEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<BrumalEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(BrumalEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, BrumalAnimation.idle, ageInTicks, 1.1f);
                this.animateWalk(BrumalAnimation.Walk, limbSwing, limbSwingAmount, 1.0f, 1.3f);
                this.animate(entity.animationState2, BrumalAnimation.attack, ageInTicks, 1.2f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(BrumalEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

